/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver.firefox;

import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FirefoxProfileEnhancer {
    private static final String FIREBUGS_VERSION = "1.9.0b1";
    private static final String MAX_FIREBUGS_VERSION = "999.99.0";
    private static final String FIREBUGS_XPI_FILE = "/firefox/firebug-1.9.0b1.xpi";
    private static final String FIREFINDER_VERSION = "1.1-fx";
    private static final String MAX_FIREFINDER_VERSION = "999.9";
    private static final String FIREFINDER_XPI_FILE = "/firefox/firefinder_for_firebug-1.1-fx.xpi";
    private static final Logger LOGGER = LoggerFactory.getLogger(FirefoxProfileEnhancer.class);
    private static final String FIREFOX_NETWORK_PROXY_TYPE = "network.proxy.type";
    private static final String FIREFOX_NETWORK_PROXY_HTTP = "network.proxy.http";
    private static final String FIREFOX_NETWORK_PROXY_HTTP_PORT = "network.proxy.http_port";
    private final EnvironmentVariables environmentVariables;

    public FirefoxProfileEnhancer(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public boolean shouldActivateFirebugs() {
        return this.environmentVariables.getPropertyAsBoolean(ThucydidesSystemProperty.ACTIVATE_FIREBUGS.getPropertyName(), false);
    }

    public void addFirebugsTo(FirefoxProfile profile) {
        try {
            profile.addExtension(this.getClass(), FIREBUGS_XPI_FILE);
            profile.setPreference("extensions.firebug.currentVersion", MAX_FIREBUGS_VERSION);
            profile.addExtension(this.getClass(), FIREFINDER_XPI_FILE);
            profile.setPreference("extensions.firebug.currentVersion", MAX_FIREFINDER_VERSION);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to add Firebugs extension to Firefox");
        }
    }

    public void enableNativeEventsFor(FirefoxProfile profile) {
        profile.setEnableNativeEvents(true);
    }

    public void configureJavaSupport(FirefoxProfile profile) {
        boolean enableJava = this.environmentVariables.getPropertyAsBoolean(ThucydidesSystemProperty.SECURITY_ENABLE_JAVA, false);
        profile.setPreference("security.enable_java", enableJava);
    }

    public void allowWindowResizeFor(FirefoxProfile profile) {
        profile.setPreference("dom.disable_window_move_resize", false);
    }

    public void activateProxy(FirefoxProfile profile, String proxyUrl, String proxyPort) {
        profile.setPreference(FIREFOX_NETWORK_PROXY_HTTP, proxyUrl);
        profile.setPreference(FIREFOX_NETWORK_PROXY_HTTP_PORT, proxyPort);
        profile.setPreference(FIREFOX_NETWORK_PROXY_TYPE, "1");
    }

    public void addPreferences(FirefoxProfile profile) {
        String preferences = this.environmentVariables.getProperty(ThucydidesSystemProperty.FIREFOX_PREFERENCES);
        List<PreferenceValue> preferenceValues = this.getPreferenceValuesFrom(preferences);
        for (PreferenceValue preference : preferenceValues) {
            preference.applyTo(profile);
        }
    }

    private List<PreferenceValue> getPreferenceValuesFrom(String preferences) {
        ArrayList preferenceValues = Lists.newArrayList();
        if (StringUtils.isNotEmpty((CharSequence)preferences)) {
            ArrayList<String> arguments = this.split(preferences, ";");
            for (String argument : arguments) {
                preferenceValues.addAll(this.convertToPreferenceValue(argument).asSet());
            }
        }
        return preferenceValues;
    }

    private Optional<PreferenceValue> convertToPreferenceValue(String argument) {
        ArrayList<String> arguments = this.split(argument, "=");
        if (arguments.size() == 1) {
            String key = (String)arguments.get(0);
            return Optional.of((Object)new PreferenceValue(key, Boolean.TRUE));
        }
        if (arguments.size() == 2) {
            String key = (String)arguments.get(0);
            String value = (String)arguments.get(1);
            return Optional.of((Object)new PreferenceValue(key, this.argumentValueOf(value)));
        }
        return Optional.absent();
    }

    private Object argumentValueOf(String value) {
        if (NumberUtils.isDigits((String)value)) {
            return Integer.parseInt(value);
        }
        if (value.toLowerCase().equals("true") || value.toLowerCase().equals("false")) {
            return Boolean.valueOf(value);
        }
        return value;
    }

    private ArrayList<String> split(String values, String separator) {
        return Lists.newArrayList((Iterable)Splitter.on((String)separator).trimResults().split((CharSequence)values));
    }

    static class PreferenceValue {
        private final String key;
        private final Object value;

        PreferenceValue(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public void applyTo(FirefoxProfile profile) {
            if (this.value instanceof Boolean) {
                profile.setPreference(this.key, ((Boolean)this.value).booleanValue());
            } else if (this.value instanceof Integer) {
                profile.setPreference(this.key, ((Integer)this.value).intValue());
            } else {
                profile.setPreference(this.key, this.value.toString());
            }
        }
    }
}

