/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.jbehave;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.thucydides.core.Thucydides;
import net.thucydides.core.ThucydidesListeners;
import net.thucydides.core.ThucydidesReports;
import net.thucydides.core.model.DataTable;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.reports.ReportService;
import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepFailure;
import net.thucydides.core.util.Inflector;
import net.thucydides.core.util.NameConverter;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.ThucydidesWebDriverSupport;
import net.thucydides.core.webdriver.WebdriverProxyFactory;
import net.thucydides.jbehave.GivenStoryMonitor;
import net.thucydides.jbehave.ThucydidesJBehaveSystemProperties;
import net.thucydides.jbehave.ThucydidesStepFactory;
import org.codehaus.plexus.util.StringUtils;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.GivenStories;
import org.jbehave.core.model.GivenStory;
import org.jbehave.core.model.Meta;
import org.jbehave.core.model.Narrative;
import org.jbehave.core.model.OutcomesTable;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.StoryDuration;
import org.jbehave.core.reporters.StoryReporter;
import org.junit.internal.AssumptionViolatedException;
import org.openqa.selenium.WebDriver;

public class ThucydidesReporter
implements StoryReporter {
    private ThreadLocal<ThucydidesListeners> thucydidesListenersThreadLocal;
    private ThreadLocal<ReportService> reportServiceThreadLocal;
    private final List<BaseStepListener> baseStepListeners;
    private final Configuration systemConfiguration;
    private static final String OPEN_PARAM_CHAR = "\uff5f";
    private static final String CLOSE_PARAM_CHAR = "\uff60";
    private GivenStoryMonitor givenStoryMonitor;
    private Stack<org.jbehave.core.model.Story> storyStack = new Stack();
    private Stack<String> activeScenarios = new Stack();
    private List<String> givenStories = Lists.newArrayList();
    private Map<String, String> storyMetadata;
    private boolean nestScenarios = false;
    List<Map<String, String>> exampleData;
    int exampleCount = 0;

    public ThucydidesReporter(Configuration systemConfiguration) {
        this.systemConfiguration = systemConfiguration;
        this.thucydidesListenersThreadLocal = new ThreadLocal();
        this.reportServiceThreadLocal = new ThreadLocal();
        this.baseStepListeners = Lists.newArrayList();
        this.givenStoryMonitor = new GivenStoryMonitor();
    }

    protected void clearListeners() {
        this.thucydidesListenersThreadLocal.remove();
        this.reportServiceThreadLocal.remove();
        this.givenStoryMonitor.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ThucydidesListeners getThucydidesListeners() {
        if (this.thucydidesListenersThreadLocal.get() == null) {
            ThucydidesListeners listeners = ThucydidesReports.setupListeners((Configuration)this.systemConfiguration);
            this.thucydidesListenersThreadLocal.set(listeners);
            List<BaseStepListener> list = this.baseStepListeners;
            synchronized (list) {
                this.baseStepListeners.add(listeners.getBaseStepListener());
            }
        }
        return this.thucydidesListenersThreadLocal.get();
    }

    protected ReportService getReportService() {
        return ThucydidesReports.getReportService((Configuration)this.systemConfiguration);
    }

    public void storyNotAllowed(org.jbehave.core.model.Story story, String filter) {
    }

    public void storyCancelled(org.jbehave.core.model.Story story, StoryDuration storyDuration) {
    }

    private org.jbehave.core.model.Story currentStory() {
        return this.storyStack.peek();
    }

    private void currentStoryIs(org.jbehave.core.model.Story story) {
        this.storyStack.push(story);
    }

    public void beforeStory(org.jbehave.core.model.Story story, boolean givenStory) {
        System.out.println("Before story" + story.getName());
        this.currentStoryIs(story);
        this.noteAnyGivenStoriesFor(story);
        this.storyMetadata = this.getMetadataFrom(story.getMeta());
        if (!this.isFixture(story) && !givenStory) {
            this.activeScenarios.clear();
            this.configureDriver(story);
            ThucydidesStepFactory.resetContext();
            this.getThucydidesListeners().withDriver(ThucydidesWebDriverSupport.getDriver());
            if (!this.isAStoryLevelGiven(story)) {
                this.startTestSuiteForStory(story);
                if (this.givenStoriesPresentFor(story)) {
                    this.startTestForFirstScenarioIn(story);
                }
            }
        } else if (givenStory) {
            this.shouldNestScenarios(true);
        }
    }

    private boolean shouldNestScenarios() {
        return this.nestScenarios;
    }

    private void shouldNestScenarios(boolean nestScenarios) {
        this.nestScenarios = nestScenarios;
    }

    private void startTestForFirstScenarioIn(org.jbehave.core.model.Story story) {
        System.out.println("Starting first test for " + story.getName());
        Scenario firstScenario = (Scenario)story.getScenarios().get(0);
        this.startScenarioCalled(firstScenario.getTitle());
        StepEventBus.getEventBus().stepStarted(ExecutedStepDescription.withTitle((String)"Preconditions"));
        this.shouldNestScenarios(true);
    }

    public void beforeScenario(String scenarioTitle) {
        if (this.shouldRestartDriverBeforeEachScenario() && !this.shouldNestScenarios()) {
            WebdriverProxyFactory.resetDriver((WebDriver)ThucydidesWebDriverSupport.getDriver());
        }
        if (this.shouldResetStepsBeforeEachScenario()) {
            ThucydidesStepFactory.resetContext();
        }
        if (!this.isCurrentScenario(scenarioTitle)) {
            if (this.shouldNestScenarios()) {
                this.startNewStep(scenarioTitle);
            } else {
                this.startScenarioCalled(scenarioTitle);
            }
        }
    }

    private boolean isCurrentScenario(String scenarioTitle) {
        return !this.activeScenarios.empty() && scenarioTitle.equals(this.activeScenarios.peek());
    }

    private void startNewStep(String scenarioTitle) {
        if (this.givenStoryMonitor.isInGivenStory() && StepEventBus.getEventBus().areStepsRunning()) {
            StepEventBus.getEventBus().updateCurrentStepTitle(scenarioTitle);
        } else {
            StepEventBus.getEventBus().stepStarted(ExecutedStepDescription.withTitle((String)scenarioTitle));
        }
    }

    private boolean givenStoriesPresentFor(org.jbehave.core.model.Story story) {
        return !story.getGivenStories().getStories().isEmpty();
    }

    private void startTestSuiteForStory(org.jbehave.core.model.Story story) {
        String storyName = this.removeSuffixFrom(story.getName());
        String storyTitle = NameConverter.humanize((String)storyName);
        Story userStory = Story.withIdAndPath((String)storyName, (String)storyTitle, (String)story.getPath()).withNarrative(story.getNarrative().asA());
        StepEventBus.getEventBus().testSuiteStarted(userStory);
        this.registerTags(story);
    }

    private void noteAnyGivenStoriesFor(org.jbehave.core.model.Story story) {
        for (GivenStory given : story.getGivenStories().getStories()) {
            String givenStoryName = new File(given.getPath()).getName();
            this.givenStories.add(givenStoryName);
        }
    }

    private boolean isAStoryLevelGiven(org.jbehave.core.model.Story story) {
        for (String givenStoryName : this.givenStories) {
            if (!this.hasSameName(story, givenStoryName)) continue;
            return true;
        }
        return false;
    }

    private void givenStoryDone(org.jbehave.core.model.Story story) {
        this.givenStories.remove(story.getName());
    }

    private boolean hasSameName(org.jbehave.core.model.Story story, String givenStoryName) {
        return story.getName().equalsIgnoreCase(givenStoryName);
    }

    private void configureDriver(org.jbehave.core.model.Story story) {
        StepEventBus.getEventBus().setUniqueSession(this.systemConfiguration.getUseUniqueBrowser());
        String requestedDriver = this.getRequestedDriver(story.getMeta());
        if (StringUtils.isNotEmpty((String)requestedDriver)) {
            ThucydidesWebDriverSupport.initialize((String)requestedDriver);
        } else {
            ThucydidesWebDriverSupport.initialize();
        }
    }

    private void registerTags(org.jbehave.core.model.Story story) {
        this.registerStoryIssues(story.getMeta());
        this.registerStoryFeaturesAndEpics(story.getMeta());
        this.registerStoryTags(story.getMeta());
        this.registerStoryMeta(story.getMeta());
    }

    private boolean isFixture(org.jbehave.core.model.Story story) {
        return story.getName().equals("BeforeStories") || story.getName().equals("AfterStories");
    }

    private String getRequestedDriver(Meta metaData) {
        if (StringUtils.isNotEmpty((String)metaData.getProperty("driver"))) {
            return metaData.getProperty("driver");
        }
        if (this.systemConfiguration.getDriverType() != null) {
            return this.systemConfiguration.getDriverType().toString();
        }
        return null;
    }

    private List<String> getIssueOrIssuesPropertyValues(Meta metaData) {
        return this.getTagPropertyValues(metaData, "issue");
    }

    private List<TestTag> getFeatureOrFeaturesPropertyValues(Meta metaData) {
        List<String> features = this.getTagPropertyValues(metaData, "feature");
        return Lambda.convert(features, this.toFeatureTags());
    }

    private List<TestTag> getEpicOrEpicsPropertyValues(Meta metaData) {
        List<String> epics = this.getTagPropertyValues(metaData, "epic");
        return Lambda.convert(epics, this.toEpicTags());
    }

    private List<TestTag> getTagOrTagsPropertyValues(Meta metaData) {
        List<String> tags = this.getTagPropertyValues(metaData, "tag");
        return Lambda.convert(tags, this.toTags());
    }

    private Converter<String, TestTag> toTags() {
        return new Converter<String, TestTag>(){

            public TestTag convert(String tag) {
                ArrayList tagParts = Lists.newArrayList((Iterable)Splitter.on((String)":").trimResults().split((CharSequence)tag));
                if (tagParts.size() == 2) {
                    return TestTag.withName((String)((String)tagParts.get(1))).andType((String)tagParts.get(0));
                }
                return TestTag.withName((String)"true").andType((String)tagParts.get(0));
            }
        };
    }

    private Converter<String, TestTag> toFeatureTags() {
        return new Converter<String, TestTag>(){

            public TestTag convert(String featureName) {
                return TestTag.withName((String)featureName).andType("feature");
            }
        };
    }

    private Converter<String, TestTag> toEpicTags() {
        return new Converter<String, TestTag>(){

            public TestTag convert(String featureName) {
                return TestTag.withName((String)featureName).andType("epic");
            }
        };
    }

    private List<String> getTagPropertyValues(Meta metaData, String tagType) {
        String singularTag = metaData.getProperty(tagType);
        String pluralTagType = Inflector.getInstance().pluralize((Object)tagType);
        String multipleTags = metaData.getProperty(pluralTagType);
        String allTags = Joiner.on((char)',').skipNulls().join((Object)singularTag, (Object)multipleTags, new Object[0]);
        return Lists.newArrayList((Iterable)Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)allTags));
    }

    private void registerIssues(Meta metaData) {
        List<String> issues = this.getIssueOrIssuesPropertyValues(metaData);
        if (!issues.isEmpty()) {
            StepEventBus.getEventBus().addIssuesToCurrentTest(issues);
        }
    }

    private void registerStoryIssues(Meta metaData) {
        List<String> issues = this.getIssueOrIssuesPropertyValues(metaData);
        if (!issues.isEmpty()) {
            StepEventBus.getEventBus().addIssuesToCurrentStory(issues);
        }
    }

    private void registerFeaturesAndEpics(Meta metaData) {
        List<TestTag> featuresAndEpics = this.featureAndEpicTags(metaData);
        if (!featuresAndEpics.isEmpty()) {
            StepEventBus.getEventBus().addTagsToCurrentTest(featuresAndEpics);
        }
    }

    private List<TestTag> featureAndEpicTags(Meta metaData) {
        ArrayList featuresAndEpics = Lists.newArrayList();
        featuresAndEpics.addAll(this.getFeatureOrFeaturesPropertyValues(metaData));
        featuresAndEpics.addAll(this.getEpicOrEpicsPropertyValues(metaData));
        return featuresAndEpics;
    }

    private void registerStoryFeaturesAndEpics(Meta metaData) {
        List<TestTag> featuresAndEpics = this.featureAndEpicTags(metaData);
        if (!featuresAndEpics.isEmpty()) {
            StepEventBus.getEventBus().addTagsToCurrentStory(featuresAndEpics);
        }
    }

    private void registerTags(Meta metaData) {
        List<TestTag> tags = this.getTagOrTagsPropertyValues(metaData);
        if (!tags.isEmpty()) {
            StepEventBus.getEventBus().addTagsToCurrentTest(tags);
        }
    }

    private Map<String, String> getMetadataFrom(Meta metaData) {
        HashMap metadata = Maps.newHashMap();
        for (String propertyName : metaData.getPropertyNames()) {
            metadata.put(propertyName, metaData.getProperty(propertyName));
        }
        return metadata;
    }

    private void registerMetadata(Meta metaData) {
        Thucydides.getCurrentSession().clearMetaData();
        Map<String, String> scenarioMetadata = this.getMetadataFrom(metaData);
        scenarioMetadata.putAll(this.storyMetadata);
        for (String key : scenarioMetadata.keySet()) {
            Thucydides.getCurrentSession().addMetaData(key, scenarioMetadata.get(key));
        }
    }

    private void registerStoryTags(Meta metaData) {
        List<TestTag> tags = this.getTagOrTagsPropertyValues(metaData);
        if (!tags.isEmpty()) {
            StepEventBus.getEventBus().addTagsToCurrentStory(tags);
        }
    }

    private void registerStoryMeta(Meta metaData) {
    }

    private String removeSuffixFrom(String name) {
        return name.contains(".") ? name.substring(0, name.indexOf(".")) : name;
    }

    public void afterStory(boolean given) {
        this.shouldNestScenarios(false);
        if (given) {
            this.givenStoryMonitor.exitingGivenStory();
            this.givenStoryDone(this.currentStory());
        } else if (this.isAfterStory(this.currentStory())) {
            this.closeBrowsersForThisStory();
            this.generateReports();
        } else if (!(this.isFixture(this.currentStory()) || given || this.isAStoryLevelGiven(this.currentStory()))) {
            StepEventBus.getEventBus().testSuiteFinished();
            this.clearListeners();
        }
        this.storyStack.pop();
    }

    private void closeBrowsersForThisStory() {
        if (!this.systemConfiguration.getUseUniqueBrowser()) {
            ThucydidesWebDriverSupport.closeAllDrivers();
        }
    }

    private boolean isAfterStory(org.jbehave.core.model.Story currentStory) {
        return currentStory.getName().equals("AfterStories");
    }

    private synchronized void generateReports() {
        this.getReportService().generateReportsFor(this.getAllTestOutcomes());
    }

    public List<TestOutcome> getAllTestOutcomes() {
        return Lambda.flatten((Object)Lambda.extract(this.baseStepListeners, (Object)((BaseStepListener)Lambda.on(BaseStepListener.class)).getTestOutcomes()));
    }

    public void narrative(Narrative narrative) {
    }

    public void scenarioNotAllowed(Scenario scenario, String s) {
    }

    private void startScenarioCalled(String scenarioTitle) {
        StepEventBus.getEventBus().testStarted(scenarioTitle);
        this.activeScenarios.add(scenarioTitle);
    }

    private boolean shouldRestartDriverBeforeEachScenario() {
        return this.systemConfiguration.getEnvironmentVariables().getPropertyAsBoolean(ThucydidesJBehaveSystemProperties.RESTART_BROWSER_EACH_SCENARIO.getName(), false);
    }

    private boolean shouldResetStepsBeforeEachScenario() {
        return this.systemConfiguration.getEnvironmentVariables().getPropertyAsBoolean(ThucydidesJBehaveSystemProperties.RESET_STEPS_EACH_SCENARIO.getName(), true);
    }

    public void scenarioMeta(Meta meta) {
        this.registerIssues(meta);
        this.registerFeaturesAndEpics(meta);
        this.registerTags(meta);
        this.registerMetadata(meta);
    }

    public void afterScenario() {
        if (this.givenStoryMonitor.isInGivenStory() || this.shouldNestScenarios()) {
            StepEventBus.getEventBus().stepFinished();
        } else {
            StepEventBus.getEventBus().testFinished();
            this.activeScenarios.pop();
        }
    }

    public void givenStories(GivenStories givenStories) {
        this.givenStoryMonitor.enteringGivenStory();
    }

    public void givenStories(List<String> strings) {
    }

    public void beforeExamples(List<String> steps, ExamplesTable table) {
        this.exampleCount = 0;
        this.exampleData = ImmutableList.copyOf((Collection)table.getRows());
        StepEventBus.getEventBus().useExamplesFrom(this.thucydidesTableFrom(table));
    }

    private DataTable thucydidesTableFrom(ExamplesTable table) {
        return DataTable.withHeaders((List)table.getHeaders()).andMappedRows(table.getRows()).build();
    }

    public void example(Map<String, String> tableRow) {
        if (this.shouldRestartDriverBeforeEachScenario()) {
            WebdriverProxyFactory.resetDriver((WebDriver)ThucydidesWebDriverSupport.getDriver());
        }
        StepEventBus.getEventBus().clearStepFailures();
        if (this.executingExamples()) {
            this.finishExample();
        }
        this.restartPeriodically();
        this.startExample();
    }

    private void startExample() {
        Map<String, String> data = this.exampleData.get(this.exampleCount - 1);
        StepEventBus.getEventBus().exampleStarted(data);
    }

    private void finishExample() {
        StepEventBus.getEventBus().exampleFinished();
    }

    private boolean executingExamples() {
        return this.exampleCount > 0;
    }

    private void restartPeriodically() {
        ++this.exampleCount;
        if (this.systemConfiguration.getRestartFrequency() > 0 && this.exampleCount % this.systemConfiguration.getRestartFrequency() == 0) {
            WebdriverProxyFactory.resetDriver((WebDriver)ThucydidesWebDriverSupport.getDriver());
        }
    }

    public void afterExamples() {
        this.finishExample();
    }

    public void beforeStep(String stepTitle) {
        StepEventBus.getEventBus().stepStarted(ExecutedStepDescription.withTitle((String)stepTitle));
    }

    public void successful(String title) {
        StepEventBus.getEventBus().updateCurrentStepTitle(this.normalized(title));
        StepEventBus.getEventBus().stepFinished();
    }

    public void ignorable(String title) {
        StepEventBus.getEventBus().updateCurrentStepTitle(this.normalized(title));
        StepEventBus.getEventBus().stepIgnored();
    }

    public void pending(String stepTitle) {
        StepEventBus.getEventBus().stepStarted(ExecutedStepDescription.withTitle((String)this.normalized(stepTitle)));
        StepEventBus.getEventBus().stepPending();
    }

    public void notPerformed(String stepTitle) {
        StepEventBus.getEventBus().stepStarted(ExecutedStepDescription.withTitle((String)this.normalized(stepTitle)));
        StepEventBus.getEventBus().stepIgnored();
    }

    public void failed(String stepTitle, Throwable cause) {
        Throwable rootCause = cause.getCause() != null ? cause.getCause() : cause;
        StepEventBus.getEventBus().updateCurrentStepTitle(stepTitle);
        if (this.isAssumptionFailure(rootCause)) {
            StepEventBus.getEventBus().assumptionViolated(rootCause.getMessage());
        } else {
            StepEventBus.getEventBus().stepFailed(new StepFailure(ExecutedStepDescription.withTitle((String)this.normalized(stepTitle)), rootCause));
        }
    }

    private boolean isAssumptionFailure(Throwable rootCause) {
        return AssumptionViolatedException.class.isAssignableFrom(rootCause.getClass());
    }

    public void failedOutcomes(String s, OutcomesTable outcomesTable) {
    }

    public void restarted(String s, Throwable throwable) {
    }

    public void dryRun() {
    }

    public void pendingMethods(List<String> strings) {
    }

    private String normalized(String value) {
        return value.replaceAll(OPEN_PARAM_CHAR, "{").replaceAll(CLOSE_PARAM_CHAR, "}");
    }
}

