/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.jbehave;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.jbehave.ThucydidesJBehave;
import net.thucydides.jbehave.ThucydidesStepFactory;
import net.thucydides.jbehave.runners.ThucydidesReportingRunner;
import org.codehaus.plexus.util.StringUtils;
import org.jbehave.core.Embeddable;
import org.jbehave.core.io.StoryFinder;
import org.jbehave.core.junit.JUnitStories;
import org.jbehave.core.reporters.Format;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.junit.runner.RunWith;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=ThucydidesReportingRunner.class)
public class ThucydidesJUnitStories
extends JUnitStories {
    public static final String DEFAULT_STORY_NAME = "**/*.story";
    private Configuration systemConfiguration;
    private EnvironmentVariables environmentVariables;
    private String storyFolder = "";
    private String storyNamePattern = "**/*.story";
    private org.jbehave.core.configuration.Configuration configuration;
    private List<Format> formats = Arrays.asList(Format.CONSOLE, Format.HTML, Format.XML);

    public ThucydidesJUnitStories() {
    }

    protected ThucydidesJUnitStories(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables.copy();
    }

    protected ThucydidesJUnitStories(Configuration configuration) {
        this.setSystemConfiguration(configuration);
    }

    public org.jbehave.core.configuration.Configuration configuration() {
        if (this.configuration == null) {
            Configuration thucydidesConfiguration = this.getSystemConfiguration();
            if (this.environmentVariables != null) {
                thucydidesConfiguration = thucydidesConfiguration.withEnvironmentVariables(this.environmentVariables);
            }
            this.configuration = ThucydidesJBehave.defaultConfiguration(thucydidesConfiguration, this.formats, (Embeddable)this);
        }
        return this.configuration;
    }

    public InjectableStepsFactory stepsFactory() {
        return ThucydidesStepFactory.withStepsFromPackage(this.getRootPackage(), this.configuration()).andClassLoader(this.getClassLoader());
    }

    public ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public List<String> storyPaths() {
        HashSet storyPaths = Sets.newHashSet();
        Iterable<String> pathExpressions = this.getStoryPathExpressions();
        StoryFinder storyFinder = new StoryFinder();
        for (String pathExpression : pathExpressions) {
            ArrayList<URL> classpathRoots = this.findAllClasspathRoots();
            for (URL classpathRootUrl : classpathRoots) {
                storyPaths.addAll(storyFinder.findPaths(classpathRootUrl, pathExpression, ""));
            }
        }
        return Lists.newArrayList((Iterable)storyPaths);
    }

    private ArrayList<URL> findAllClasspathRoots() {
        try {
            return Collections.list(Thread.currentThread().getContextClassLoader().getResources("."));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not load the classpath roots when looking for story files", e);
        }
    }

    protected String getRootPackage() {
        return ((Object)((Object)this)).getClass().getPackage().getName();
    }

    protected Iterable<String> getStoryPathExpressions() {
        return Splitter.on((char)';').trimResults().split((CharSequence)this.getStoryPath());
    }

    protected String getStoryPath() {
        return StringUtils.isEmpty((String)this.storyFolder) ? this.storyNamePattern : this.storyFolder + "/" + this.storyNamePattern;
    }

    public void findStoriesIn(String storyFolder) {
        this.storyFolder = storyFolder;
    }

    public void useFormats(Format ... formats) {
        this.formats = Arrays.asList(formats);
    }

    public void findStoriesCalled(String storyName) {
        this.storyNamePattern = storyName.startsWith("**/") ? storyName : "**/" + storyName;
    }

    public void setSystemConfiguration(Configuration systemConfiguration) {
        this.systemConfiguration = this.copyOf(systemConfiguration);
    }

    private Configuration copyOf(Configuration systemConfiguration) {
        return systemConfiguration.copy();
    }

    public Configuration getSystemConfiguration() {
        if (this.systemConfiguration == null) {
            this.systemConfiguration = this.copyOf((Configuration)Injectors.getInjector().getInstance(Configuration.class));
        }
        return this.systemConfiguration;
    }

    protected void useDriver(String driver) {
        this.getSystemConfiguration().setIfUndefined(ThucydidesSystemProperty.DRIVER.getPropertyName(), driver);
    }

    protected void useUniqueSession() {
        this.getSystemConfiguration().setIfUndefined(ThucydidesSystemProperty.UNIQUE_BROWSER.getPropertyName(), "true");
    }

    public ThucydidesConfigurationBuilder runThucydides() {
        return new ThucydidesConfigurationBuilder(this);
    }

    public class ThucydidesPropertySetter {
        private final ThucydidesJUnitStories thucydidesJUnitStories;
        private final ThucydidesSystemProperty propertyToSet;

        public ThucydidesPropertySetter(ThucydidesJUnitStories thucydidesJUnitStories2, ThucydidesSystemProperty propertyToSet) {
            this.thucydidesJUnitStories = thucydidesJUnitStories2;
            this.propertyToSet = propertyToSet;
        }

        public void setTo(boolean value) {
            this.thucydidesJUnitStories.getSystemConfiguration().setIfUndefined(this.propertyToSet.getPropertyName(), Boolean.toString(value));
        }

        public void setTo(String value) {
            this.thucydidesJUnitStories.getSystemConfiguration().setIfUndefined(this.propertyToSet.getPropertyName(), value);
        }

        public void setTo(Integer value) {
            this.thucydidesJUnitStories.getSystemConfiguration().setIfUndefined(this.propertyToSet.getPropertyName(), Integer.toString(value));
        }
    }

    public class ThucydidesConfigurationBuilder {
        private final ThucydidesJUnitStories thucydidesJUnitStories;

        public ThucydidesConfigurationBuilder(ThucydidesJUnitStories thucydidesJUnitStories2) {
            this.thucydidesJUnitStories = thucydidesJUnitStories2;
        }

        public ThucydidesConfigurationBuilder withDriver(String driver) {
            ThucydidesJUnitStories.this.useDriver(driver);
            return this;
        }

        public ThucydidesPropertySetter withProperty(ThucydidesSystemProperty property) {
            return new ThucydidesPropertySetter(this.thucydidesJUnitStories, property);
        }

        public ThucydidesConfigurationBuilder inASingleSession() {
            ThucydidesJUnitStories.this.useUniqueSession();
            return this;
        }
    }
}

