/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.jbehave;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.thucydides.core.ThucydidesListeners;
import net.thucydides.core.ThucydidesReports;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.reports.ReportService;
import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepFailure;
import net.thucydides.core.util.Inflector;
import net.thucydides.core.util.NameConverter;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.ThucydidesWebDriverSupport;
import net.thucydides.core.webdriver.WebdriverProxyFactory;
import net.thucydides.jbehave.ThucydidesStepFactory;
import org.codehaus.plexus.util.StringUtils;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.GivenStories;
import org.jbehave.core.model.Meta;
import org.jbehave.core.model.Narrative;
import org.jbehave.core.model.OutcomesTable;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.StoryDuration;
import org.jbehave.core.reporters.StoryReporter;
import org.openqa.selenium.WebDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThucydidesReporter
implements StoryReporter {
    private ThreadLocal<ThucydidesListeners> thucydidesListenersThreadLocal;
    private ThreadLocal<ReportService> reportServiceThreadLocal;
    private final List<BaseStepListener> baseStepListeners;
    private final Configuration systemConfiguration;
    private static final String OPEN_PARAM_CHAR = "\uff5f";
    private static final String CLOSE_PARAM_CHAR = "\uff60";
    private org.jbehave.core.model.Story currentStory;
    int exampleCount = 0;

    public ThucydidesReporter(Configuration systemConfiguration) {
        this.systemConfiguration = systemConfiguration;
        this.thucydidesListenersThreadLocal = new ThreadLocal();
        this.reportServiceThreadLocal = new ThreadLocal();
        this.baseStepListeners = Lists.newArrayList();
    }

    protected void clearListeners() {
        this.thucydidesListenersThreadLocal.remove();
        this.reportServiceThreadLocal.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ThucydidesListeners getThucydidesListeners() {
        if (this.thucydidesListenersThreadLocal.get() == null) {
            ThucydidesListeners listeners = ThucydidesReports.setupListeners((Configuration)this.systemConfiguration);
            this.thucydidesListenersThreadLocal.set(listeners);
            List<BaseStepListener> list = this.baseStepListeners;
            synchronized (list) {
                this.baseStepListeners.add(listeners.getBaseStepListener());
            }
        }
        return this.thucydidesListenersThreadLocal.get();
    }

    protected ReportService getReportService() {
        if (this.reportServiceThreadLocal.get() == null) {
            this.reportServiceThreadLocal.set(ThucydidesReports.getReportService((Configuration)this.systemConfiguration));
        }
        return this.reportServiceThreadLocal.get();
    }

    public void storyNotAllowed(org.jbehave.core.model.Story story, String s) {
    }

    public void storyCancelled(org.jbehave.core.model.Story story, StoryDuration storyDuration) {
    }

    public void beforeStory(org.jbehave.core.model.Story story, boolean b) {
        this.currentStory = story;
        if (!this.isFixture(story)) {
            this.configureDriver(story);
            ThucydidesStepFactory.resetContext();
            this.getThucydidesListeners().withDriver(ThucydidesWebDriverSupport.getDriver());
            String storyName = this.removeSuffixFrom(story.getName());
            String storyTitle = NameConverter.humanize((String)storyName);
            Story userStory = Story.withIdAndPath((String)storyName, (String)storyTitle, (String)story.getPath()).withNarrative(story.getNarrative().asA());
            StepEventBus.getEventBus().testSuiteStarted(userStory);
            this.registerTags(story);
        }
    }

    private void configureDriver(org.jbehave.core.model.Story story) {
        StepEventBus.getEventBus().setUniqueSession(this.systemConfiguration.getUseUniqueBrowser());
        String requestedDriver = this.getRequestedDriver(story.getMeta());
        if (StringUtils.isNotEmpty((String)requestedDriver)) {
            ThucydidesWebDriverSupport.initialize((String)requestedDriver);
        } else {
            ThucydidesWebDriverSupport.initialize();
        }
    }

    private void registerTags(org.jbehave.core.model.Story story) {
        this.registerStoryIssues(story.getMeta());
        this.registerStoryFeaturesAndEpics(story.getMeta());
        this.registerStoryTags(story.getMeta());
    }

    private boolean isFixture(org.jbehave.core.model.Story story) {
        return story.getName().equals("BeforeStories") || story.getName().equals("AfterStories");
    }

    private String getRequestedDriver(Meta metaData) {
        if (StringUtils.isNotEmpty((String)metaData.getProperty("driver"))) {
            return metaData.getProperty("driver");
        }
        if (this.systemConfiguration.getDriverType() != null) {
            return this.systemConfiguration.getDriverType().toString();
        }
        return null;
    }

    private List<String> getIssueOrIssuesPropertyValues(Meta metaData) {
        return this.getTagPropertyValues(metaData, "issue");
    }

    private List<TestTag> getFeatureOrFeaturesPropertyValues(Meta metaData) {
        List<String> features = this.getTagPropertyValues(metaData, "feature");
        return Lambda.convert(features, this.toFeatureTags());
    }

    private List<TestTag> getEpicOrEpicsPropertyValues(Meta metaData) {
        List<String> epics = this.getTagPropertyValues(metaData, "epic");
        return Lambda.convert(epics, this.toEpicTags());
    }

    private List<TestTag> getTagOrTagsPropertyValues(Meta metaData) {
        List<String> tags = this.getTagPropertyValues(metaData, "tag");
        return Lambda.convert(tags, this.toTags());
    }

    private Converter<String, TestTag> toTags() {
        return new Converter<String, TestTag>(){

            public TestTag convert(String tag) {
                ArrayList tagParts = Lists.newArrayList((Iterable)Splitter.on((String)":").trimResults().split((CharSequence)tag));
                return TestTag.withName((String)((String)tagParts.get(1))).andType((String)tagParts.get(0));
            }
        };
    }

    private Converter<String, TestTag> toFeatureTags() {
        return new Converter<String, TestTag>(){

            public TestTag convert(String featureName) {
                return TestTag.withName((String)featureName).andType("feature");
            }
        };
    }

    private Converter<String, TestTag> toEpicTags() {
        return new Converter<String, TestTag>(){

            public TestTag convert(String featureName) {
                return TestTag.withName((String)featureName).andType("epic");
            }
        };
    }

    private List<String> getTagPropertyValues(Meta metaData, String tagType) {
        String singularTag = metaData.getProperty(tagType);
        String pluralTagType = Inflector.getInstance().pluralize((Object)tagType);
        String multipleTags = metaData.getProperty(pluralTagType);
        String allTags = Joiner.on((char)',').skipNulls().join((Object)singularTag, (Object)multipleTags, new Object[0]);
        return Lists.newArrayList((Iterable)Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)allTags));
    }

    private void registerIssues(Meta metaData) {
        List<String> issues = this.getIssueOrIssuesPropertyValues(metaData);
        if (!issues.isEmpty()) {
            StepEventBus.getEventBus().addIssuesToCurrentTest(issues);
        }
    }

    private void registerStoryIssues(Meta metaData) {
        List<String> issues = this.getIssueOrIssuesPropertyValues(metaData);
        if (!issues.isEmpty()) {
            StepEventBus.getEventBus().addIssuesToCurrentStory(issues);
        }
    }

    private void registerFeaturesAndEpics(Meta metaData) {
        List<TestTag> featuresAndEpics = this.featureAndEpicTags(metaData);
        if (!featuresAndEpics.isEmpty()) {
            StepEventBus.getEventBus().addTagsToCurrentTest(featuresAndEpics);
        }
    }

    private List<TestTag> featureAndEpicTags(Meta metaData) {
        ArrayList featuresAndEpics = Lists.newArrayList();
        featuresAndEpics.addAll(this.getFeatureOrFeaturesPropertyValues(metaData));
        featuresAndEpics.addAll(this.getEpicOrEpicsPropertyValues(metaData));
        return featuresAndEpics;
    }

    private void registerStoryFeaturesAndEpics(Meta metaData) {
        List<TestTag> featuresAndEpics = this.featureAndEpicTags(metaData);
        if (!featuresAndEpics.isEmpty()) {
            StepEventBus.getEventBus().addTagsToCurrentStory(featuresAndEpics);
        }
    }

    private void registerTags(Meta metaData) {
        List<TestTag> tags = this.getTagOrTagsPropertyValues(metaData);
        if (!tags.isEmpty()) {
            StepEventBus.getEventBus().addTagsToCurrentTest(tags);
        }
    }

    private void registerStoryTags(Meta metaData) {
        List<TestTag> tags = this.getTagOrTagsPropertyValues(metaData);
        if (!tags.isEmpty()) {
            StepEventBus.getEventBus().addTagsToCurrentStory(tags);
        }
    }

    private String removeSuffixFrom(String name) {
        return name.contains(".") ? name.substring(0, name.indexOf(".")) : name;
    }

    public void afterStory(boolean given) {
        if (this.isAfterStory(this.currentStory)) {
            this.closeBrowsersForThisStory();
            this.generateReports();
        } else if (!this.isFixture(this.currentStory)) {
            StepEventBus.getEventBus().testSuiteFinished();
            this.clearListeners();
        }
    }

    private void closeBrowsersForThisStory() {
        if (!this.systemConfiguration.getUseUniqueBrowser()) {
            ThucydidesWebDriverSupport.closeAllDrivers();
        }
    }

    private boolean isAfterStory(org.jbehave.core.model.Story currentStory) {
        return currentStory.getName().equals("AfterStories");
    }

    private synchronized void generateReports() {
        for (BaseStepListener listener : this.baseStepListeners) {
            this.getReportService().generateReportsFor(listener.getTestOutcomes());
        }
    }

    public void narrative(Narrative narrative) {
    }

    public void scenarioNotAllowed(Scenario scenario, String s) {
    }

    public void beforeScenario(String scenarioTitle) {
        StepEventBus.getEventBus().testStarted(scenarioTitle);
    }

    public void scenarioMeta(Meta meta) {
        this.registerIssues(meta);
        this.registerFeaturesAndEpics(meta);
        this.registerTags(meta);
    }

    public void afterScenario() {
        StepEventBus.getEventBus().testFinished();
    }

    public void givenStories(GivenStories givenStories) {
    }

    public void givenStories(List<String> strings) {
    }

    public void beforeExamples(List<String> strings, ExamplesTable examplesTable) {
        this.exampleCount = 0;
    }

    public void example(Map<String, String> stringStringMap) {
        StepEventBus.getEventBus().clearStepFailures();
        if (this.systemConfiguration.getRestartFrequency() > 0) {
            ++this.exampleCount;
            if (this.exampleCount % this.systemConfiguration.getRestartFrequency() == 0) {
                WebdriverProxyFactory.resetDriver((WebDriver)ThucydidesWebDriverSupport.getDriver());
            }
        }
    }

    public void afterExamples() {
    }

    public void beforeStep(String stepTitle) {
        StepEventBus.getEventBus().stepStarted(ExecutedStepDescription.withTitle((String)stepTitle));
    }

    public void successful(String title) {
        StepEventBus.getEventBus().updateCurrentStepTitle(this.normalized(title));
        StepEventBus.getEventBus().stepFinished();
    }

    public void ignorable(String title) {
        StepEventBus.getEventBus().updateCurrentStepTitle(this.normalized(title));
        StepEventBus.getEventBus().stepIgnored();
    }

    public void pending(String stepTitle) {
        StepEventBus.getEventBus().stepStarted(ExecutedStepDescription.withTitle((String)this.normalized(stepTitle)));
        StepEventBus.getEventBus().stepPending();
    }

    public void notPerformed(String stepTitle) {
        StepEventBus.getEventBus().stepStarted(ExecutedStepDescription.withTitle((String)this.normalized(stepTitle)));
        StepEventBus.getEventBus().stepIgnored();
    }

    public void failed(String stepTitle, Throwable cause) {
        Throwable rootCause = cause.getCause() != null ? cause.getCause() : cause;
        StepEventBus.getEventBus().updateCurrentStepTitle(stepTitle);
        StepEventBus.getEventBus().stepFailed(new StepFailure(ExecutedStepDescription.withTitle((String)this.normalized(stepTitle)), rootCause));
    }

    public void failedOutcomes(String s, OutcomesTable outcomesTable) {
    }

    public void restarted(String s, Throwable throwable) {
    }

    public void dryRun() {
    }

    public void pendingMethods(List<String> strings) {
    }

    private String normalized(String value) {
        return value.replaceAll(OPEN_PARAM_CHAR, "{").replaceAll(CLOSE_PARAM_CHAR, "}");
    }
}

