/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.junit.runners;

import ch.lambdaj.Lambda;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.thucydides.core.model.DataTableRow;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestResultList;
import net.thucydides.core.model.TestStep;
import net.thucydides.junit.runners.ThucydidesParameterizedRunner;
import net.thucydides.junit.runners.ThucydidesRunner;
import org.apache.commons.lang3.StringUtils;
import org.junit.runner.Runner;

public class ParameterizedTestsOutcomeAggregator {
    private final ThucydidesParameterizedRunner thucydidesParameterizedRunner;

    private ParameterizedTestsOutcomeAggregator(ThucydidesParameterizedRunner thucydidesParameterizedRunner) {
        this.thucydidesParameterizedRunner = thucydidesParameterizedRunner;
    }

    public static ParameterizedTestsOutcomeAggregator from(ThucydidesParameterizedRunner thucydidesParameterizedRunner) {
        return new ParameterizedTestsOutcomeAggregator(thucydidesParameterizedRunner);
    }

    public List<TestOutcome> aggregateTestOutcomesByTestMethods() {
        List<TestOutcome> allOutcomes = this.getTestOutcomesForAllParameterSets();
        if (allOutcomes.isEmpty()) {
            return Lists.newArrayList();
        }
        return this.aggregatedScenarioOutcomes(allOutcomes);
    }

    private List<TestOutcome> aggregatedScenarioOutcomes(List<TestOutcome> allOutcomes) {
        HashMap<String, TestOutcome> scenarioOutcomes = new HashMap<String, TestOutcome>();
        for (TestOutcome testOutcome : allOutcomes) {
            String normalizedMethodName = this.normalizeMethodName(testOutcome.getMethodName());
            if (scenarioOutcomes.containsKey(normalizedMethodName)) {
                List testSteps = testOutcome.getTestSteps();
                if (!testSteps.isEmpty()) {
                    TestStep nextStep = (TestStep)testSteps.get(0);
                    nextStep.setDescription(this.normalizeTestStepDescription(nextStep.getDescription(), ((TestOutcome)scenarioOutcomes.get(normalizedMethodName)).getTestSteps().size() + 1));
                    ((TestOutcome)scenarioOutcomes.get(normalizedMethodName)).recordStep(nextStep);
                }
                this.updateResultsForAnyExternalFailures((TestOutcome)scenarioOutcomes.get(normalizedMethodName), testOutcome);
                ((TestOutcome)scenarioOutcomes.get(normalizedMethodName)).getDataTable().addRows(testOutcome.getDataTable().getRows());
                continue;
            }
            TestOutcome scenarioOutcome = this.createScenarioOutcome(testOutcome);
            scenarioOutcomes.put(scenarioOutcome.getMethodName(), scenarioOutcome);
        }
        ArrayList<TestOutcome> aggregatedScenarioOutcomes = new ArrayList<TestOutcome>();
        aggregatedScenarioOutcomes.addAll(scenarioOutcomes.values());
        return aggregatedScenarioOutcomes;
    }

    private void updateResultsForAnyExternalFailures(TestOutcome scenarioOutcome, TestOutcome testOutcome) {
        if (this.rowResultsAreInconsistantWithOverallResult(testOutcome)) {
            ((DataTableRow)testOutcome.getDataTable().getRows().get(0)).updateResult(testOutcome.getResult());
            scenarioOutcome.addFailingExternalStep(testOutcome.getTestFailureCause());
        }
    }

    private boolean rowResultsAreInconsistantWithOverallResult(TestOutcome testOutcome) {
        TestResult overallRowResult = this.overallResultFrom(testOutcome.getDataTable().getRows());
        return (testOutcome.isError() != false || testOutcome.isFailure() != false) && !testOutcome.getDataTable().getRows().isEmpty() && testOutcome.getResult() != overallRowResult;
    }

    private TestResult overallResultFrom(List<DataTableRow> rows) {
        TestResultList rowResults = TestResultList.of((List)Lambda.extract(rows, (Object)((DataTableRow)Lambda.on(DataTableRow.class)).getResult()));
        return rowResults.getOverallResult();
    }

    private String normalizeTestStepDescription(String description, int index) {
        return StringUtils.replace((String)description, (String)"[1]", (String)("[" + index + "]"));
    }

    private TestOutcome createScenarioOutcome(TestOutcome parameterizedOutcome) {
        TestOutcome scenarioOutcome = parameterizedOutcome.withMethodName(this.normalizeMethodName(parameterizedOutcome.getMethodName()));
        scenarioOutcome.endGroup();
        return scenarioOutcome;
    }

    private String normalizeMethodName(String methodName) {
        return methodName.replaceAll("\\[\\d\\]", "");
    }

    public List<TestOutcome> getTestOutcomesForAllParameterSets() {
        ArrayList<TestOutcome> testOutcomes = new ArrayList<TestOutcome>();
        testOutcomes.addAll(((ThucydidesRunner)this.thucydidesParameterizedRunner.getRunners().get(0)).getTestOutcomes());
        for (Runner runner : this.thucydidesParameterizedRunner.getRunners()) {
            for (TestOutcome testOutcome : ((ThucydidesRunner)runner).getTestOutcomes()) {
                if (testOutcomes.contains(testOutcome)) continue;
                testOutcomes.add(testOutcome);
            }
        }
        return testOutcomes;
    }
}

