/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.junit.runners;

import java.util.List;
import net.thucydides.core.annotations.TestAnnotations;
import net.thucydides.core.model.DataTable;
import net.thucydides.core.model.DataTableRow;
import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepListener;
import net.thucydides.junit.listeners.JUnitStepListener;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;

public class ParameterizedJUnitStepListener
extends JUnitStepListener {
    final int parameterSetNumber;
    private final DataTable parametersTable;

    public ParameterizedJUnitStepListener(int parameterSetNumber, DataTable parametersTable, Class<?> testClass, BaseStepListener baseStepListener, StepListener ... listeners) {
        super(testClass, baseStepListener, listeners);
        this.parameterSetNumber = parameterSetNumber;
        this.parametersTable = parametersTable;
    }

    @Override
    public void testStarted(Description description) {
        if (this.testingThisDataSet(description)) {
            super.testStarted(description);
            StepEventBus.getEventBus().useExamplesFrom(this.dataTableRow());
            if (!this.ignoredOrPending(description)) {
                StepEventBus.getEventBus().exampleStarted(this.parametersTable.row(this.parameterSetNumber).toStringMap());
            }
        }
    }

    private boolean isPending(Description description) {
        return TestAnnotations.forClass((Class)description.getTestClass()).isPending(description.getMethodName());
    }

    private boolean isIgnored(Description description) {
        return TestAnnotations.forClass((Class)description.getTestClass()).isIgnored(description.getMethodName());
    }

    private boolean ignoredOrPending(Description description) {
        return this.isIgnored(description) || this.isPending(description);
    }

    private DataTable dataTableRow() {
        return DataTable.withHeaders((List)this.parametersTable.getHeaders()).andCopyRowDataFrom((DataTableRow)this.parametersTable.getRows().get(this.parameterSetNumber)).build();
    }

    private boolean testingThisDataSet(Description description) {
        return description.getTestClass().equals(this.getTestClass()) && description.getMethodName().endsWith("[" + this.parameterSetNumber + "]");
    }

    @Override
    public void testFinished(Description description) throws Exception {
        if (this.testingThisDataSet(description)) {
            super.testFinished(description);
            StepEventBus.getEventBus().exampleFinished();
        }
    }

    @Override
    public void testFailure(Failure failure) throws Exception {
        if (this.testingThisDataSet(failure.getDescription())) {
            super.testFailure(failure);
            StepEventBus.getEventBus().exampleFinished();
        }
    }

    @Override
    public void testIgnored(Description description) throws Exception {
        if (this.testingThisDataSet(description)) {
            super.testIgnored(description);
            if (!this.ignoredOrPending(description)) {
                StepEventBus.getEventBus().exampleFinished();
            }
        }
    }
}

