/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.junit.runners;

import com.google.inject.Injector;
import com.google.inject.Module;
import com.thoughtworks.selenium.SeleneseTestBase;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.thucydides.core.Thucydides;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.annotations.ManagedWebDriverAnnotatedField;
import net.thucydides.core.annotations.Pending;
import net.thucydides.core.annotations.TestCaseAnnotations;
import net.thucydides.core.batches.BatchManager;
import net.thucydides.core.batches.BatchManagerProvider;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.reports.AcceptanceTestReporter;
import net.thucydides.core.reports.ReportService;
import net.thucydides.core.statistics.TestCount;
import net.thucydides.core.steps.StepAnnotations;
import net.thucydides.core.steps.StepData;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepFactory;
import net.thucydides.core.steps.StepListener;
import net.thucydides.core.steps.StepPublisher;
import net.thucydides.core.tags.TagScanner;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.ThucydidesWebdriverManager;
import net.thucydides.core.webdriver.WebDriverFactory;
import net.thucydides.core.webdriver.WebdriverManager;
import net.thucydides.core.webdriver.WebdriverProxyFactory;
import net.thucydides.junit.listeners.JUnitStepListener;
import net.thucydides.junit.runners.FailureDetectingStepListener;
import net.thucydides.junit.runners.RetryFilteringRunNotifier;
import net.thucydides.junit.runners.TestMethodAnnotations;
import net.thucydides.junit.runners.ThucydidesStatement;
import org.apache.commons.lang3.StringUtils;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.support.ui.Select;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThucydidesRunner
extends BlockJUnit4ClassRunner {
    private StepFactory stepFactory;
    private Pages pages;
    private final WebdriverManager webdriverManager;
    private String requestedDriver;
    private ReportService reportService;
    private final TestCount testCount;
    private JUnitStepListener stepListener;
    private Configuration configuration;
    private TagScanner tagScanner;
    private BatchManager batchManager;
    private final Logger logger = LoggerFactory.getLogger(ThucydidesRunner.class);
    private WebDriver driver;
    private String baseUrl;
    private boolean acceptNextAlert = true;
    private StringBuffer verificationErrors = new StringBuffer();

    public Pages getPages() {
        return this.pages;
    }

    public ThucydidesRunner(Class<?> klass) throws InitializationError {
        this(klass, Injectors.getInjector());
    }

    public ThucydidesRunner(Class<?> klass, Module module) throws InitializationError {
        this(klass, Injectors.getInjector((Module)module));
    }

    public ThucydidesRunner(Class<?> klass, Injector injector) throws InitializationError {
        this(klass, (WebdriverManager)injector.getInstance(WebdriverManager.class), (Configuration)injector.getInstance(Configuration.class), (BatchManager)injector.getInstance(BatchManager.class));
    }

    public ThucydidesRunner(Class<?> klass, WebDriverFactory webDriverFactory) throws InitializationError {
        this(klass, webDriverFactory, (Configuration)Injectors.getInjector().getInstance(Configuration.class));
    }

    public ThucydidesRunner(Class<?> klass, WebDriverFactory webDriverFactory, Configuration configuration) throws InitializationError {
        this(klass, webDriverFactory, configuration, new BatchManagerProvider(configuration).get());
    }

    public ThucydidesRunner(Class<?> klass, WebDriverFactory webDriverFactory, Configuration configuration, BatchManager batchManager) throws InitializationError {
        this(klass, (WebdriverManager)new ThucydidesWebdriverManager(webDriverFactory, configuration), configuration, batchManager);
    }

    public ThucydidesRunner(Class<?> klass, BatchManager batchManager) throws InitializationError {
        this(klass, (WebdriverManager)Injectors.getInjector().getInstance(WebdriverManager.class), (Configuration)Injectors.getInjector().getInstance(Configuration.class), batchManager);
    }

    public ThucydidesRunner(Class<?> klass, WebdriverManager webDriverManager, Configuration configuration, BatchManager batchManager) throws InitializationError {
        super(klass);
        this.webdriverManager = webDriverManager;
        this.configuration = configuration;
        this.requestedDriver = this.getSpecifiedDriver(klass);
        this.tagScanner = new TagScanner(configuration.getEnvironmentVariables());
        this.testCount = (TestCount)Injectors.getInjector().getInstance(TestCount.class);
        if (TestCaseAnnotations.supportsWebTests(klass)) {
            this.checkRequestedDriverType();
        }
        this.batchManager = batchManager;
        batchManager.registerTestCase(klass);
    }

    private String getSpecifiedDriver(Class<?> klass) {
        if (ManagedWebDriverAnnotatedField.hasManagedWebdriverField(klass)) {
            return ManagedWebDriverAnnotatedField.findFirstAnnotatedField(klass).getDriver();
        }
        return null;
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    protected BatchManager getBatchManager() {
        return this.batchManager;
    }

    private void checkRequestedDriverType() {
        if (this.requestedDriverSpecified()) {
            SupportedWebDriver.getDriverTypeFor((String)this.requestedDriver);
        } else {
            this.getConfiguration().getDriverType();
        }
    }

    private boolean requestedDriverSpecified() {
        return !StringUtils.isEmpty((CharSequence)this.requestedDriver);
    }

    public File getOutputDirectory() {
        return this.getConfiguration().getOutputDirectory();
    }

    public void subscribeReporter(AcceptanceTestReporter reporter) {
        this.getReportService().subscribe(reporter);
    }

    public void useQualifier(String qualifier) {
        this.getReportService().useQualifier(qualifier);
    }

    public void run(RunNotifier notifier) {
        if (!this.skipThisTest()) {
            try {
                this.setupFixtureServices();
                RunNotifier newNotifier = this.initializeRunNotifier(notifier);
                super.run(newNotifier);
            }
            finally {
                this.notifyTestSuiteFinished();
                this.generateReports();
                this.dropListeners(notifier);
                this.closeDrivers();
                this.shutdownFixtureServices();
            }
        }
    }

    private void setupFixtureServices() {
    }

    private void shutdownFixtureServices() {
    }

    private void notifyTestSuiteFinished() {
        try {
            StepEventBus.getEventBus().testSuiteFinished();
        }
        catch (Throwable listenerException) {
            this.logger.error("Test event bus error: " + listenerException.getMessage(), listenerException);
        }
    }

    private void dropListeners(RunNotifier notifier) {
        JUnitStepListener listener = this.getStepListener();
        notifier.removeListener((RunListener)listener);
        this.getStepListener().dropListeners();
    }

    protected void generateReports() {
        this.generateReportsFor(this.getTestOutcomes());
    }

    private boolean skipThisTest() {
        return this.testNotInCurrentBatch();
    }

    private boolean testNotInCurrentBatch() {
        return this.batchManager != null && !this.batchManager.shouldExecuteThisTest(this.getDescription().testCount());
    }

    protected JUnitStepListener getStepListener() {
        if (this.stepListener == null) {
            this.buildAndConfigureListeners();
        }
        return this.stepListener;
    }

    protected void setStepListener(JUnitStepListener stepListener) {
        this.stepListener = stepListener;
    }

    private void buildAndConfigureListeners() {
        this.initStepEventBus();
        if (this.webtestsAreSupported()) {
            this.initPagesObjectUsing(this.webdriverManager.getWebdriver(this.requestedDriver));
            this.setStepListener(this.initListenersUsing(this.getPages()));
            this.initStepFactoryUsing(this.getPages());
        } else {
            this.setStepListener(this.initListeners());
            this.initStepFactory();
        }
    }

    private RunNotifier initializeRunNotifier(RunNotifier notifier) {
        RunNotifier notifierForSteps = new RunNotifier();
        notifierForSteps.addListener((RunListener)this.getStepListener());
        return new RetryFilteringRunNotifier(notifier, notifierForSteps);
    }

    protected void initStepEventBus() {
        StepEventBus.getEventBus().clear();
    }

    private void initPagesObjectUsing(WebDriver driver) {
        this.pages = new Pages(driver, this.getConfiguration());
    }

    protected JUnitStepListener initListenersUsing(Pages pageFactory) {
        return JUnitStepListener.withOutputDirectory(this.getConfiguration().getOutputDirectory()).and().withPageFactory(pageFactory).and().withTestClass(this.getTestClass().getJavaClass()).and().build();
    }

    protected JUnitStepListener initListeners() {
        return JUnitStepListener.withOutputDirectory(this.getConfiguration().getOutputDirectory()).and().withTestClass(this.getTestClass().getJavaClass()).and().build();
    }

    private boolean webtestsAreSupported() {
        return TestCaseAnnotations.supportsWebTests((Class)this.getTestClass().getJavaClass());
    }

    private void initStepFactoryUsing(Pages pagesObject) {
        this.stepFactory = new StepFactory(pagesObject);
    }

    private void initStepFactory() {
        this.stepFactory = new StepFactory();
    }

    private void closeDrivers() {
        this.getWebdriverManager().closeAllCurrentDrivers();
    }

    protected WebdriverManager getWebdriverManager() {
        return this.webdriverManager;
    }

    private ReportService getReportService() {
        if (this.reportService == null) {
            this.reportService = new ReportService(this.getOutputDirectory(), this.getDefaultReporters());
        }
        return this.reportService;
    }

    private void generateReportsFor(List<TestOutcome> testOutcomeResults) {
        this.getReportService().generateReportsFor(testOutcomeResults);
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        this.clearMetadataIfRequired();
        if (this.shouldSkipTest(method)) {
            return;
        }
        if (this.isPending(method)) {
            this.markAsPending(method);
            notifier.fireTestIgnored(this.describeChild(method));
            return;
        }
        this.processTestMethodAnnotationsFor(method);
        FailureDetectingStepListener failureDetectingStepListener = new FailureDetectingStepListener();
        StepEventBus.getEventBus().registerListener((StepListener)failureDetectingStepListener);
        int maxRetries = this.getConfiguration().maxRetries();
        int attemptCount = 0;
        while (attemptCount <= maxRetries) {
            if (notifier instanceof RetryFilteringRunNotifier) {
                ((RetryFilteringRunNotifier)notifier).reset();
            }
            if (attemptCount > 0) {
                this.logger.warn(String.valueOf(method.getName()) + " failed, making attempt " + (attemptCount + 1) + ". Max retries: " + maxRetries);
                StepEventBus.getEventBus().testRetried();
            }
            Thucydides.initializeTestSession();
            this.resetBroswerFromTimeToTime();
            this.additionalBrowserCleanup();
            failureDetectingStepListener.reset();
            super.runChild(method, notifier);
            if (!failureDetectingStepListener.lastTestFailed()) break;
            ++attemptCount;
        }
        if (notifier instanceof RetryFilteringRunNotifier) {
            ((RetryFilteringRunNotifier)notifier).flush();
        }
    }

    private void clearMetadataIfRequired() {
        if (!this.configuration.getEnvironmentVariables().getPropertyAsBoolean((Enum)ThucydidesSystemProperty.MAINTAIN_SESSION, false).booleanValue()) {
            Thucydides.getCurrentSession().clearMetaData();
        }
    }

    protected void additionalBrowserCleanup() {
    }

    private boolean shouldSkipTest(FrameworkMethod method) {
        return !this.tagScanner.shouldRunMethod(this.getTestClass().getJavaClass(), method.getName());
    }

    private void markAsPending(FrameworkMethod method) {
        this.stepListener.testStarted(Description.createTestDescription(method.getMethod().getDeclaringClass(), (String)this.testName(method)));
        StepEventBus.getEventBus().testPending();
        StepEventBus.getEventBus().testFinished();
    }

    private void processTestMethodAnnotationsFor(FrameworkMethod method) {
        if (this.isIgnored(method)) {
            this.stepListener.testStarted(Description.createTestDescription(method.getMethod().getDeclaringClass(), (String)this.testName(method)));
            StepEventBus.getEventBus().testIgnored();
        }
    }

    private boolean isPending(FrameworkMethod method) {
        return method.getAnnotation(Pending.class) != null;
    }

    private boolean isIgnored(FrameworkMethod method) {
        return method.getAnnotation(Ignore.class) != null;
    }

    protected boolean restartBrowserBeforeTest() {
        return this.notAUniqueSession() || this.dueForPeriodicBrowserReset();
    }

    private boolean dueForPeriodicBrowserReset() {
        return this.shouldRestartEveryNthTest() && this.currentTestNumber() % this.restartFrequency() == 0;
    }

    private boolean notAUniqueSession() {
        return !this.isUniqueSession();
    }

    protected int restartFrequency() {
        return this.getConfiguration().getRestartFrequency();
    }

    protected int currentTestNumber() {
        return this.testCount.getCurrentTestNumber();
    }

    protected boolean shouldRestartEveryNthTest() {
        return this.restartFrequency() > 0;
    }

    protected boolean isUniqueSession() {
        return TestCaseAnnotations.isUniqueSession((Class)this.getTestClass().getJavaClass());
    }

    protected void resetBroswerFromTimeToTime() {
        if (this.isAWebTest() && this.restartBrowserBeforeTest()) {
            WebdriverProxyFactory.resetDriver((WebDriver)this.getDriver());
        }
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        if (this.webtestsAreSupported()) {
            this.injectDriverInto(test, method);
            this.initPagesObjectUsing(this.driverFor(method));
            this.injectAnnotatedPagesObjectInto(test);
            this.initStepFactoryUsing(this.getPages());
        }
        this.injectScenarioStepsInto(test);
        this.useStepFactoryForDataDrivenSteps();
        Statement baseStatement = super.methodInvoker(method, test);
        return new ThucydidesStatement(baseStatement, (StepPublisher)this.stepListener.getBaseStepListener());
    }

    private void useStepFactoryForDataDrivenSteps() {
        StepData.setDefaultStepFactory((StepFactory)this.stepFactory);
    }

    protected void injectDriverInto(Object testCase, FrameworkMethod method) {
        TestCaseAnnotations.forTestCase((Object)testCase).injectDriver(this.driverFor(method));
    }

    protected WebDriver driverFor(FrameworkMethod method) {
        if (TestMethodAnnotations.forTest(method).isDriverSpecified()) {
            String testSpecificDriver = TestMethodAnnotations.forTest(method).specifiedDriver();
            return this.getDriver(testSpecificDriver);
        }
        return this.getDriver();
    }

    protected void injectScenarioStepsInto(Object testCase) {
        StepAnnotations.injectScenarioStepsInto((Object)testCase, (StepFactory)this.stepFactory);
    }

    protected void injectAnnotatedPagesObjectInto(Object testCase) {
        StepAnnotations.injectAnnotatedPagesObjectInto((Object)testCase, (Pages)this.pages);
    }

    protected WebDriver getDriver() {
        return this.getWebdriverManager().getWebdriver(this.requestedDriver);
    }

    protected WebDriver getDriver(String driver) {
        return this.getWebdriverManager().getWebdriver(driver);
    }

    public List<TestOutcome> getTestOutcomes() {
        return this.getStepListener().getTestOutcomes();
    }

    protected Collection<AcceptanceTestReporter> getDefaultReporters() {
        return ReportService.getDefaultReporters();
    }

    public boolean isAWebTest() {
        return TestCaseAnnotations.isWebTest((Class)this.getTestClass().getJavaClass());
    }

    @Before
    public void setUp() throws Exception {
        this.driver = new FirefoxDriver();
        this.baseUrl = "http://www.trademe.co.nz/";
        this.driver.manage().timeouts().implicitlyWait(30L, TimeUnit.SECONDS);
    }

    @Test
    public void testRegistration() throws Exception {
        this.driver.get("http://www.trademe.co.nz");
        this.driver.findElement(By.linkText((String)"Register")).click();
        this.driver.findElement(By.id((String)"LoginDetails_EmailAddressTextBox")).clear();
        this.driver.findElement(By.id((String)"LoginDetails_EmailAddressTextBox")).sendKeys(new CharSequence[]{"joe@bloggs.com"});
        this.driver.findElement(By.id((String)"LoginDetails_PasswordTextBox")).clear();
        this.driver.findElement(By.id((String)"LoginDetails_PasswordTextBox")).sendKeys(new CharSequence[]{"secret"});
        this.driver.findElement(By.id((String)"LoginDetails_ConfirmPasswordTextBox")).clear();
        this.driver.findElement(By.id((String)"LoginDetails_ConfirmPasswordTextBox")).sendKeys(new CharSequence[]{"secret"});
        this.driver.findElement(By.id((String)"LoginDetails_UserNameTextBox")).clear();
        this.driver.findElement(By.id((String)"LoginDetails_UserNameTextBox")).sendKeys(new CharSequence[]{"joebloggs"});
        this.driver.findElement(By.id((String)"ContactDetails_FirstNameTextBox")).clear();
        this.driver.findElement(By.id((String)"ContactDetails_FirstNameTextBox")).sendKeys(new CharSequence[]{"Joe"});
        this.driver.findElement(By.id((String)"ContactDetails_LastNameTextBox")).clear();
        this.driver.findElement(By.id((String)"ContactDetails_LastNameTextBox")).sendKeys(new CharSequence[]{"Bloggs"});
        this.driver.findElement(By.id((String)"ContactDetails_GenderMale")).click();
        new Select(this.driver.findElement(By.id((String)"ContactDetails_DobDay"))).selectByVisibleText("3");
        new Select(this.driver.findElement(By.id((String)"ContactDetails_DobMonth"))).selectByVisibleText("April");
        this.driver.findElement(By.id((String)"ContactDetails_DobYear")).clear();
        this.driver.findElement(By.id((String)"ContactDetails_DobYear")).sendKeys(new CharSequence[]{"1975"});
        new Select(this.driver.findElement(By.id((String)"ContactDetails_ContactPhoneAreaCodeDropDown"))).selectByVisibleText("04");
        this.driver.findElement(By.id((String)"ContactDetails_ContactPhoneTextBox")).clear();
        this.driver.findElement(By.id((String)"ContactDetails_ContactPhoneTextBox")).sendKeys(new CharSequence[]{"12345678"});
        this.driver.findElement(By.id((String)"ContactDetails_StreetAddress_Address1TextBox")).clear();
        this.driver.findElement(By.id((String)"ContactDetails_StreetAddress_Address1TextBox")).sendKeys(new CharSequence[]{"1 main street"});
        this.driver.findElement(By.id((String)"ContactDetails_StreetAddress_CityTextBox")).clear();
        this.driver.findElement(By.id((String)"ContactDetails_StreetAddress_CityTextBox")).sendKeys(new CharSequence[]{"Sydney"});
        this.driver.findElement(By.id((String)"ContactDetails_StreetAddress_PostcodeTextBox")).clear();
        this.driver.findElement(By.id((String)"ContactDetails_StreetAddress_PostcodeTextBox")).sendKeys(new CharSequence[]{"2000"});
        new Select(this.driver.findElement(By.id((String)"ContactDetails_ClosestSuburbDropDown"))).selectByVisibleText("Auckland - Auckland City");
        this.driver.findElement(By.id((String)"TnCCheckbox")).click();
        this.driver.findElement(By.id((String)"SubmitButton")).click();
        this.driver.findElement(By.id((String)"SubmitButton")).click();
        try {
            SeleneseTestBase.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)"BODY")).getText().matches("^[\\s\\S]*Thank you for registering![\\s\\S]*$"));
        }
        catch (Error e) {
            this.verificationErrors.append(e.toString());
        }
    }
}

