/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.junit.listeners;

import com.google.inject.Key;
import java.io.File;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.Listeners;
import net.thucydides.core.steps.StepListener;
import net.thucydides.junit.guice.JUnitInjectors;
import net.thucydides.junit.listeners.JUnitStepListener;
import net.thucydides.junit.listeners.TestCounter;
import net.thucydides.junit.runners.ParameterizedJUnitStepListener;

public class JUnitStepListenerBuilder {
    private final File outputDirectory;
    private final Pages pageFactory;
    private final int parameterSetNumber;

    public JUnitStepListenerBuilder(File outputDirectory) {
        this(outputDirectory, null, -1);
    }

    public JUnitStepListenerBuilder(File outputDirectory, Pages pageFactory) {
        this(outputDirectory, pageFactory, -1);
    }

    public JUnitStepListenerBuilder(File outputDirectory, Pages pageFactory, int parameterSetNumber) {
        this.outputDirectory = outputDirectory;
        this.pageFactory = pageFactory;
        this.parameterSetNumber = parameterSetNumber;
    }

    public JUnitStepListenerBuilder and() {
        return this;
    }

    public JUnitStepListenerBuilder withPageFactory(Pages pageFactory) {
        return new JUnitStepListenerBuilder(this.outputDirectory, pageFactory);
    }

    public JUnitStepListenerBuilder withParameterSetNumber(int parameterSetNumber) {
        return new JUnitStepListenerBuilder(this.outputDirectory, this.pageFactory, parameterSetNumber);
    }

    public JUnitStepListener build() {
        if (this.parameterSetNumber >= 0) {
            return this.newParameterizedJUnitStepListener();
        }
        return this.newStandardJunitStepListener();
    }

    private BaseStepListener buildBaseStepListener() {
        if (this.pageFactory != null) {
            return Listeners.getBaseStepListener().withPages(this.pageFactory).and().withOutputDirectory(this.outputDirectory);
        }
        return Listeners.getBaseStepListener().withOutputDirectory(this.outputDirectory);
    }

    private JUnitStepListener newParameterizedJUnitStepListener() {
        return new ParameterizedJUnitStepListener(this.parameterSetNumber, this.buildBaseStepListener(), Listeners.getLoggingListener(), this.newTestCountListener(), Listeners.getStatisticsListener());
    }

    private StepListener newTestCountListener() {
        return (StepListener)JUnitInjectors.getInjector().getInstance(Key.get(StepListener.class, TestCounter.class));
    }

    private JUnitStepListener newStandardJunitStepListener() {
        return new JUnitStepListener(this.buildBaseStepListener(), Listeners.getLoggingListener(), this.newTestCountListener(), Listeners.getStatisticsListener());
    }
}

