/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.junit.listeners;

import java.util.concurrent.atomic.AtomicInteger;
import net.thucydides.core.Thucydides;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.logging.LoggingLevel;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.StepFailure;
import net.thucydides.core.steps.StepListener;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.junit.finder.TestFinder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestCountListener
implements StepListener {
    private final Logger logger;
    private final EnvironmentVariables environmentVariables;
    private final AtomicInteger testCount = new AtomicInteger();

    protected TestCountListener(EnvironmentVariables environmentVariables, Logger logger) {
        this.logger = logger;
        this.environmentVariables = environmentVariables;
        this.logTotalTestCount();
    }

    public TestCountListener(EnvironmentVariables environmentVariables) {
        this(environmentVariables, LoggerFactory.getLogger(Thucydides.class));
    }

    private void logTotalTestCount() {
        String rootPackage = ThucydidesSystemProperty.THUCYDIDES_TEST_ROOT.from(this.environmentVariables);
        if (StringUtils.isNotEmpty((CharSequence)rootPackage)) {
            TestFinder finder = TestFinder.thatFinds().allTests().inPackage(rootPackage);
            int testMethodCount = finder.countTestMethods();
            if (this.loggingLevelIsAtLeast(LoggingLevel.NORMAL)) {
                this.getLogger().info("PREPARING TO EXECUTE {} TESTS", (Object)testMethodCount);
            }
        }
    }

    private boolean loggingLevelIsAtLeast(LoggingLevel minimumLoggingLevel) {
        return this.getLoggingLevel().compareTo((Enum)minimumLoggingLevel) >= 0;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    private LoggingLevel getLoggingLevel() {
        String logLevel = ThucydidesSystemProperty.LOGGING.from(this.environmentVariables, LoggingLevel.NORMAL.name());
        return LoggingLevel.valueOf((String)logLevel);
    }

    public void testSuiteStarted(Class<?> storyClass) {
    }

    public void testSuiteStarted(Story story) {
    }

    public void testSuiteFinished() {
    }

    public void testStarted(String description) {
        int currentTestCount = this.testCount.addAndGet(1);
        if (this.loggingLevelIsAtLeast(LoggingLevel.NORMAL)) {
            this.getLogger().info("TEST NUMBER: {}", (Object)currentTestCount);
        }
    }

    public void testFinished(TestOutcome result) {
    }

    public void stepStarted(ExecutedStepDescription description) {
    }

    public void skippedStepStarted(ExecutedStepDescription description) {
    }

    public void stepFailed(StepFailure failure) {
    }

    public void lastStepFailed(StepFailure failure) {
    }

    public void stepIgnored() {
    }

    public void stepIgnored(String message) {
    }

    public void stepPending() {
    }

    public void stepPending(String message) {
    }

    public void stepFinished() {
    }

    public void testFailed(TestOutcome testOutcome, Throwable cause) {
    }

    public void testIgnored() {
    }

    public void notifyScreenChange() {
    }
}

