/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.junit.runners;

import com.google.common.base.Splitter;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.regex.Pattern;
import net.thucydides.core.csv.CSVTestDataSource;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.steps.FilePathParser;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.junit.annotations.TestData;
import net.thucydides.junit.annotations.UseTestDataFrom;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataDrivenAnnotations {
    private final EnvironmentVariables environmentVariables;
    private final Pattern DATASOURCE_PATH_SEPARATORS = Pattern.compile("[:;,]");
    private final TestClass testClass;

    public static DataDrivenAnnotations forClass(Class testClass) {
        return new DataDrivenAnnotations(testClass);
    }

    public static DataDrivenAnnotations forClass(TestClass testClass) {
        return new DataDrivenAnnotations(testClass);
    }

    DataDrivenAnnotations(Class testClass) {
        this(new TestClass(testClass));
    }

    DataDrivenAnnotations(TestClass testClass) {
        this(testClass, (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class));
    }

    DataDrivenAnnotations(TestClass testClass, EnvironmentVariables environmentVariables) {
        this.testClass = testClass;
        this.environmentVariables = environmentVariables;
    }

    DataDrivenAnnotations usingEnvironmentVariables(EnvironmentVariables environmentVariables) {
        return new DataDrivenAnnotations(this.testClass, environmentVariables);
    }

    public List<Object[]> getParametersList() throws Throwable {
        return (List)this.getTestDataMethod().getMethod().invoke(null, new Object[0]);
    }

    public FrameworkMethod getTestDataMethod() throws Exception {
        FrameworkMethod method = this.findTestDataMethod();
        if (method == null) {
            throw new IllegalArgumentException("No public static @FilePathParser method on class " + this.testClass.getName());
        }
        return method;
    }

    private FrameworkMethod findTestDataMethod() {
        List methods = this.testClass.getAnnotatedMethods(TestData.class);
        for (FrameworkMethod each : methods) {
            int modifiers = each.getMethod().getModifiers();
            if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) continue;
            return each;
        }
        return null;
    }

    protected String findTestDataSource() {
        String paths = this.findTestDataSourcePaths();
        for (String path : Splitter.on((Pattern)this.DATASOURCE_PATH_SEPARATORS).split((CharSequence)paths)) {
            if (!CSVTestDataSource.validTestDataPath((String)path)) continue;
            return path;
        }
        throw new IllegalArgumentException("No test data file found for path: " + paths);
    }

    protected String findTestDataSourcePaths() {
        return new FilePathParser(this.environmentVariables).getInstanciatedPath(this.findUseTestDataFromAnnotation().value());
    }

    private UseTestDataFrom findUseTestDataFromAnnotation() {
        return this.testClass.getJavaClass().getAnnotation(UseTestDataFrom.class);
    }

    public boolean hasTestDataDefined() {
        return this.findTestDataMethod() != null;
    }

    public boolean hasTestDataSourceDefined() {
        return this.findUseTestDataFromAnnotation() != null && this.findTestDataSource() != null;
    }

    public <T> List<T> getDataAsInstancesOf(Class<T> clazz) throws IOException {
        CSVTestDataSource testdata = new CSVTestDataSource(this.findTestDataSource(), this.findTestDataSeparator());
        return testdata.getDataAsInstancesOf(clazz, new Object[0]);
    }

    public int countDataEntries() throws IOException {
        CSVTestDataSource testdata = new CSVTestDataSource(this.findTestDataSource(), this.findTestDataSeparator());
        return testdata.getData().size();
    }

    private char findTestDataSeparator() {
        return this.findUseTestDataFromAnnotation().separator();
    }
}

