/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ldap.commons;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import net.tirasa.connid.bundles.ldap.commons.StatusManagement;
import org.identityconnectors.common.logging.Log;

public class AttributeStatusManagement
extends StatusManagement {
    private static final Log LOG = Log.getLog(AttributeStatusManagement.class);

    protected String getStatusAttrName() {
        return "description";
    }

    protected String getStatusAttrActiveValue() {
        return "Active";
    }

    protected String getStatusAttrInactiveValue() {
        return "Inactive";
    }

    @Override
    public void setStatus(boolean status, Attributes attributes, List<String> posixGroups, List<String> ldapGroups) {
        LOG.ok("Calling setStatus {0}", new Object[]{status});
        Attribute statusAttrr = attributes.get(this.getStatusAttrName());
        if (statusAttrr == null) {
            statusAttrr = new BasicAttribute(this.getStatusAttrName());
            attributes.put(statusAttrr);
        }
        statusAttrr.add(status ? this.getStatusAttrActiveValue() : this.getStatusAttrInactiveValue());
    }

    @Override
    public Boolean getStatus(Attributes attributes, List<String> posixGroups, List<String> ldapGroups) {
        Boolean status = null;
        Attribute description = attributes.get(this.getStatusAttrName());
        if (description != null) {
            try {
                Object value = description.get();
                if (value != null) {
                    status = this.getStatusAttrActiveValue().equals(value.toString());
                }
            }
            catch (NamingException ignore) {
                status = null;
            }
        }
        return status;
    }

    @Override
    public Set<String> getOperationalAttributes() {
        return Collections.singleton(this.getStatusAttrName());
    }
}

