/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.test;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.api.APIConfiguration;
import org.identityconnectors.framework.api.ConnectorKey;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.ConnectorMessages;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationOptionsBuilder;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.SearchResult;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.identityconnectors.framework.impl.api.APIConfigurationImpl;
import org.identityconnectors.framework.impl.api.ConfigurationPropertiesImpl;
import org.identityconnectors.framework.impl.api.ConfigurationPropertyImpl;
import org.identityconnectors.framework.impl.api.ConnectorMessagesImpl;
import org.identityconnectors.framework.impl.api.local.JavaClassProperties;
import org.identityconnectors.framework.impl.api.local.LocalConnectorInfoImpl;
import org.identityconnectors.framework.impl.api.local.LocalConnectorInfoManagerImpl;
import org.identityconnectors.framework.impl.api.local.operations.SearchImpl;
import org.identityconnectors.framework.spi.Configuration;
import org.identityconnectors.framework.spi.Connector;
import org.identityconnectors.framework.spi.ConnectorClass;
import org.identityconnectors.framework.spi.SearchResultsHandler;
import org.identityconnectors.framework.spi.operations.SearchOp;
import org.identityconnectors.test.common.PropertyBag;
import org.identityconnectors.test.common.spi.TestHelpersSpi;

public class TestHelpersImpl
implements TestHelpersSpi {
    private static final Log LOG = Log.getLog(TestHelpersImpl.class);

    public APIConfiguration createTestConfiguration(Class<? extends Connector> clazz, Configuration config) {
        LocalConnectorInfoImpl info = new LocalConnectorInfoImpl();
        info.setConnectorConfigurationClass(config.getClass());
        info.setConnectorClass(clazz);
        info.setConnectorDisplayNameKey("DUMMY_DISPLAY_NAME");
        info.setConnectorKey(new ConnectorKey(clazz.getName() + ".bundle", "1.0", clazz.getName()));
        info.setMessages(this.createDummyMessages());
        try {
            APIConfigurationImpl rv = LocalConnectorInfoManagerImpl.createDefaultAPIConfiguration(info);
            rv.setConfigurationProperties(JavaClassProperties.createConfigurationProperties(config));
            info.setDefaultAPIConfiguration(rv);
            return rv;
        }
        catch (Exception e) {
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public APIConfiguration createTestConfiguration(Class<? extends Connector> clazz, Set<String> bundleContents, PropertyBag configData, String prefix) {
        assert (null != clazz);
        ConnectorClass options = clazz.getAnnotation(ConnectorClass.class);
        assert (null != options);
        LocalConnectorInfoImpl info = new LocalConnectorInfoImpl();
        info.setConnectorClass(clazz);
        info.setConnectorConfigurationClass(options.configurationClass());
        info.setConnectorDisplayNameKey(options.displayNameKey());
        info.setConnectorCategoryKey(options.categoryKey());
        info.setConnectorKey(new ConnectorKey(clazz.getName() + ".bundle", "1.0", clazz.getName()));
        if (null == bundleContents || bundleContents.isEmpty()) {
            info.setMessages(this.createDummyMessages());
        } else {
            ConnectorMessagesImpl messages = LocalConnectorInfoManagerImpl.loadMessageCatalog(bundleContents, clazz.getClassLoader(), info.getConnectorClass());
            info.setMessages(messages);
        }
        APIConfigurationImpl impl = LocalConnectorInfoManagerImpl.createDefaultAPIConfiguration(info);
        info.setDefaultAPIConfiguration(impl);
        ConfigurationPropertiesImpl configProps = impl.getConfigurationProperties();
        String fullPrefix = StringUtil.isBlank((String)prefix) ? null : prefix + ".";
        Iterator<ConfigurationPropertyImpl> iterator = configProps.getProperties().iterator();
        while (iterator.hasNext()) {
            ConfigurationPropertyImpl property;
            Object value = configData.getProperty(null == fullPrefix ? property.getName() : fullPrefix + property.getName(), (property = iterator.next()).getType(), property.getValue());
            if (value == null) continue;
            property.setValue(value);
        }
        return impl;
    }

    public void fillConfiguration(Configuration config, Map<String, ? extends Object> configData) {
        HashMap<String, ? extends Object> configDataCopy = new HashMap<String, Object>(configData);
        ConfigurationPropertiesImpl configProps = JavaClassProperties.createConfigurationProperties(config);
        for (String propName : configProps.getPropertyNames()) {
            Object value = configDataCopy.remove(propName);
            if (value == null) continue;
            configProps.setPropertyValue(propName, value);
        }
        for (String propName : configDataCopy.keySet()) {
            LOG.warn("Configuration property {0} does not exist!", new Object[]{propName});
        }
        JavaClassProperties.mergeIntoBean(configProps, config);
    }

    public SearchResult search(SearchOp<?> search, ObjectClass objectClass, Filter filter, final ResultsHandler handler, OperationOptions options) {
        if (options == null) {
            options = new OperationOptionsBuilder().build();
        }
        final AtomicReference<Object> result = new AtomicReference<Object>(null);
        SearchImpl.rawSearch(search, objectClass, filter, new SearchResultsHandler(){

            public void handleResult(SearchResult searchResult) {
                result.set(searchResult);
            }

            public boolean handle(ConnectorObject connectorObject) {
                return handler.handle(connectorObject);
            }
        }, options);
        return result.get();
    }

    public ConnectorMessages createDummyMessages() {
        return new DummyConnectorMessages();
    }

    private static class DummyConnectorMessages
    implements ConnectorMessages {
        private DummyConnectorMessages() {
        }

        public String format(String key, String dflt, Object ... args) {
            StringBuilder builder = new StringBuilder();
            builder.append(key);
            builder.append(": ");
            String sep = "";
            for (Object arg : args) {
                builder.append(sep);
                builder.append(arg);
                sep = ", ";
            }
            return builder.toString();
        }
    }
}

