/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.server.impl;

import java.net.ServerSocket;
import java.util.concurrent.CountDownLatch;
import javax.net.ServerSocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import org.identityconnectors.framework.api.ConnectorFacadeFactory;
import org.identityconnectors.framework.api.ConnectorInfoManagerFactory;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.impl.api.ConnectorInfoManagerFactoryImpl;
import org.identityconnectors.framework.server.ConnectorServer;
import org.identityconnectors.framework.server.impl.ConnectionListener;

public class ConnectorServerImpl
extends ConnectorServer {
    private ConnectionListener listener;
    private CountDownLatch stopLatch;
    private Long startDate = null;

    @Override
    public Long getStartTime() {
        return this.startDate;
    }

    @Override
    public boolean isStarted() {
        return this.listener != null;
    }

    @Override
    public void start() {
        if (this.isStarted()) {
            throw new IllegalStateException("Server is already running.");
        }
        if (this.getPort() == 0) {
            throw new IllegalStateException("Port must be set prior to starting server.");
        }
        if (this.getKeyHash() == null) {
            throw new IllegalStateException("Key hash must be set prior to starting server.");
        }
        ConnectorInfoManagerFactoryImpl factory = (ConnectorInfoManagerFactoryImpl)ConnectorInfoManagerFactory.getInstance();
        factory.getLocalManager(this.getBundleURLs(), this.getBundleParentClassLoader());
        ServerSocket socket = this.createServerSocket();
        ConnectionListener listener = new ConnectionListener(this, socket);
        listener.start();
        this.stopLatch = new CountDownLatch(1);
        this.startDate = System.currentTimeMillis();
        this.listener = listener;
    }

    private ServerSocket createServerSocket() {
        try {
            ServerSocketFactory factory = this.getUseSSL() ? this.createSSLServerSocketFactory() : ServerSocketFactory.getDefault();
            ServerSocket rv = this.getIfAddress() == null ? factory.createServerSocket(this.getPort(), this.getMaxConnections()) : factory.createServerSocket(this.getPort(), this.getMaxConnections(), this.getIfAddress());
            return rv;
        }
        catch (Exception e) {
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    private ServerSocketFactory createSSLServerSocketFactory() throws Exception {
        KeyManager[] keyManagers = null;
        if (this.getKeyManagers().size() > 0) {
            keyManagers = this.getKeyManagers().toArray(new KeyManager[this.getKeyManagers().size()]);
        }
        if (keyManagers == null) {
            return SSLServerSocketFactory.getDefault();
        }
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(keyManagers, null, null);
        return context.getServerSocketFactory();
    }

    @Override
    public void stop() {
        if (this.listener != null) {
            try {
                this.listener.shutdown();
            }
            finally {
                this.stopLatch.countDown();
            }
            this.stopLatch = null;
            this.startDate = null;
            this.listener = null;
        }
        ConnectorFacadeFactory.getManagedInstance().dispose();
    }

    @Override
    public void awaitStop() throws InterruptedException {
        this.stopLatch.await();
    }
}

