/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.maven.plugins;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.wasdev.wlp.ant.install.InstallLibertyTask;
import net.wasdev.wlp.maven.plugins.AbstractLibertySupport;
import net.wasdev.wlp.maven.plugins.Install;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.settings.Server;
import org.apache.tools.ant.taskdefs.Chmod;
import org.apache.tools.ant.taskdefs.Expand;
import org.codehaus.mojo.pluginsupport.util.ArtifactItem;
import org.codehaus.plexus.util.FileUtils;

public class BasicSupport
extends AbstractLibertySupport {
    protected static final String START_APP_MESSAGE_REGEXP = "CWWKZ0001I.*";
    protected static final ResourceBundle messages = ResourceBundle.getBundle("net.wasdev.wlp.maven.plugins.MvnMessages");
    protected boolean skip = false;
    protected boolean refresh = false;
    protected boolean isInstall = true;
    protected File assemblyInstallDirectory;
    protected File installDirectory;
    private File serverHome;
    protected String serverName = null;
    protected File userDirectory = null;
    protected File outputDirectory = null;
    protected File serverDirectory;
    protected InstallType installType;
    protected File assemblyArchive;
    protected ArtifactItem assemblyArtifact;
    protected Install install;

    @Override
    protected void init() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            return;
        }
        super.init();
        if (this.installDirectory == null) {
            this.installDirectory = this.serverHome;
        }
        try {
            if (this.installDirectory != null) {
                this.installDirectory = this.installDirectory.getCanonicalFile();
                File file = new File(this.installDirectory, "lib/ws-launch.jar");
                if (!file.exists()) {
                    throw new MojoExecutionException(MessageFormat.format(messages.getString("error.server.home.validate"), ""));
                }
                this.log.info((CharSequence)MessageFormat.format(messages.getString("info.variable.set"), "pre-installed assembly", this.installDirectory));
                this.installType = InstallType.ALREADY_EXISTS;
            } else if (this.assemblyArchive != null) {
                this.log.info((CharSequence)MessageFormat.format(messages.getString("info.variable.set"), "non-artifact based assembly archive", this.assemblyArchive));
                this.assemblyArchive = this.assemblyArchive.getCanonicalFile();
                this.installType = InstallType.FROM_FILE;
                this.installDirectory = this.checkServerHome(this.assemblyArchive);
                this.log.info((CharSequence)MessageFormat.format(messages.getString("info.variable.set"), "installDirectory", this.installDirectory));
            } else if (this.assemblyArtifact != null) {
                Artifact artifact = this.getArtifact(this.assemblyArtifact);
                this.assemblyArchive = artifact.getFile();
                if (this.assemblyArchive == null) {
                    throw new MojoExecutionException(MessageFormat.format(messages.getString("error.server.assembly.validate"), "artifact based assembly archive", ""));
                }
                this.log.info((CharSequence)MessageFormat.format(messages.getString("info.variable.set"), "artifact based assembly archive", this.assemblyArtifact));
                this.assemblyArchive = this.assemblyArchive.getCanonicalFile();
                this.installType = InstallType.FROM_FILE;
                this.installDirectory = this.checkServerHome(this.assemblyArchive);
                this.log.info((CharSequence)MessageFormat.format(messages.getString("info.variable.set"), "installDirectory", this.installDirectory));
            } else {
                if (this.install == null) {
                    this.install = new Install();
                }
                this.installType = InstallType.FROM_ARCHIVE;
                this.installDirectory = new File(this.assemblyInstallDirectory, "wlp");
                this.log.info((CharSequence)MessageFormat.format(messages.getString("info.variable.set"), "installDirectory", this.installDirectory));
            }
            if (this.serverName == null) {
                this.serverName = "defaultServer";
            }
            this.log.info((CharSequence)MessageFormat.format(messages.getString("info.variable.set"), "serverName", this.serverName));
            if (this.userDirectory == null) {
                this.userDirectory = new File(this.installDirectory, "usr");
            }
            File serversDirectory = new File(this.userDirectory, "servers");
            this.serverDirectory = new File(serversDirectory, this.serverName);
            this.log.info((CharSequence)MessageFormat.format(messages.getString("info.variable.set"), "serverDirectory", this.serverDirectory));
            if (this.outputDirectory == null) {
                this.outputDirectory = serversDirectory;
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    protected void checkServerHomeExists() throws MojoExecutionException {
        if (!this.installDirectory.exists()) {
            throw new MojoExecutionException(MessageFormat.format(messages.getString("error.server.home.noexist"), this.installDirectory));
        }
    }

    protected void checkServerDirectoryExists() throws MojoExecutionException {
        if (!this.serverDirectory.exists()) {
            throw new MojoExecutionException(MessageFormat.format(messages.getString("error.server.noexist"), this.serverName));
        }
    }

    private File checkServerHome(File archive) throws IOException, MojoExecutionException {
        this.log.debug((CharSequence)MessageFormat.format(messages.getString("debug.discover.server.home"), ""));
        File dir = null;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(archive);
            Enumeration<? extends ZipEntry> n = zipFile.entries();
            while (n.hasMoreElements()) {
                ZipEntry entry = n.nextElement();
                if (!entry.getName().endsWith("lib/ws-launch.jar")) continue;
                File file = new File(this.assemblyInstallDirectory, entry.getName());
                dir = file.getParentFile().getParentFile();
                break;
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(MessageFormat.format(messages.getString("error.discover.server.home.fail"), archive), (Exception)e);
        }
        finally {
            try {
                zipFile.close();
            }
            catch (Exception exception) {}
        }
        if (dir == null) {
            throw new MojoExecutionException(MessageFormat.format(messages.getString("error.archive.not.contain.server"), archive));
        }
        return dir.getCanonicalFile();
    }

    protected void installServerAssembly() throws Exception {
        if (this.installType == InstallType.ALREADY_EXISTS) {
            this.log.info((CharSequence)MessageFormat.format(messages.getString("info.install.type.preexisting"), ""));
        } else if (this.installType == InstallType.FROM_ARCHIVE) {
            this.installFromArchive();
        } else {
            this.installFromFile();
        }
    }

    protected void installFromFile() throws Exception {
        File installMarker = new File(this.installDirectory, ".installed");
        if (!this.refresh) {
            if (!installMarker.exists()) {
                this.refresh = true;
            } else if (this.assemblyArchive.lastModified() > installMarker.lastModified()) {
                this.log.debug((CharSequence)MessageFormat.format(messages.getString("debug.detect.assembly.archive"), ""));
                this.refresh = true;
            }
        } else {
            this.log.debug((CharSequence)MessageFormat.format(messages.getString("debug.request.refresh"), ""));
        }
        if (this.refresh && this.installDirectory.exists()) {
            this.log.info((CharSequence)MessageFormat.format(messages.getString("info.uninstalling.server.home"), this.installDirectory));
            FileUtils.forceDelete((File)this.installDirectory);
        }
        if (!installMarker.exists()) {
            this.log.info((CharSequence)"Installing assembly...");
            FileUtils.forceMkdir((File)this.installDirectory);
            Expand unzip = (Expand)this.ant.createTask("unzip");
            unzip.setSrc(this.assemblyArchive);
            unzip.setDest(this.assemblyInstallDirectory.getCanonicalFile());
            unzip.execute();
            Chmod chmod = (Chmod)this.ant.createTask("chmod");
            chmod.setPerm("ugo+rx");
            chmod.setDir(this.installDirectory);
            chmod.setIncludes("bin/*");
            chmod.setExcludes("bin/*.bat");
            chmod.execute();
            installMarker.delete();
            installMarker.createNewFile();
        } else {
            this.log.info((CharSequence)MessageFormat.format(messages.getString("info.reuse.installed.assembly"), ""));
        }
    }

    protected void installFromArchive() throws Exception {
        InstallLibertyTask installTask = (InstallLibertyTask)this.ant.createTask("antlib:net/wasdev/wlp/ant:install-liberty");
        if (installTask == null) {
            throw new NullPointerException("install-liberty task not found");
        }
        installTask.setBaseDir(this.assemblyInstallDirectory.getAbsolutePath());
        installTask.setLicenseCode(this.install.getLicenseCode());
        installTask.setVersion(this.install.getVersion());
        installTask.setRuntimeUrl(this.install.getRuntimeUrl());
        installTask.setVerbose(this.install.isVerbose());
        installTask.setMaxDownloadTime(this.install.getMaxDownloadTime());
        installTask.setType(this.install.getType());
        installTask.setOffline(this.settings.isOffline());
        String cacheDir = this.install.getCacheDirectory();
        if (cacheDir == null) {
            File dir = new File(this.artifactRepository.getBasedir(), "wlp-cache");
            installTask.setCacheDir(dir.getAbsolutePath());
        } else {
            installTask.setCacheDir(cacheDir);
        }
        String serverId = this.install.getServerId();
        if (serverId != null) {
            Server server = this.settings.getServer(serverId);
            if (server == null) {
                throw new MojoExecutionException("Server id not found: " + serverId);
            }
            installTask.setUsername(server.getUsername());
            installTask.setPassword(server.getPassword());
        } else {
            installTask.setUsername(this.install.getUsername());
            installTask.setPassword(this.install.getPassword());
        }
        installTask.execute();
    }

    protected static enum InstallType {
        FROM_FILE,
        ALREADY_EXISTS,
        FROM_ARCHIVE;

    }
}

