/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.analyze;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.UserAgentTreeWalkerBaseVisitor;
import nl.basjes.parse.useragent.UserAgentTreeWalkerLexer;
import nl.basjes.parse.useragent.UserAgentTreeWalkerParser;
import nl.basjes.parse.useragent.analyze.InvalidParserConfigurationException;
import nl.basjes.parse.useragent.analyze.Matcher;
import nl.basjes.parse.useragent.analyze.NumberRangeList;
import nl.basjes.parse.useragent.analyze.NumberRangeVisitor;
import nl.basjes.parse.useragent.analyze.treewalker.TreeExpressionEvaluator;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.tree.ParseTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MatcherAction {
    private String matchExpression;
    private UserAgentTreeWalkerParser.MatcherContext requiredPattern;
    private NumberRangeVisitor numberRangeVisitor = new NumberRangeVisitor();
    private TreeExpressionEvaluator evaluator;
    private static final Logger LOG = LoggerFactory.getLogger(MatcherAction.class);
    private Matcher matcher;
    protected List<Match> matches;
    private boolean isFixedString;
    boolean verbose = false;
    private boolean verbosePermanent = false;
    private boolean verboseTemporary = false;

    TreeExpressionEvaluator getEvaluatorForUnitTesting() {
        return this.evaluator;
    }

    private void setVerbose(boolean verbose) {
        this.setVerbose(verbose, false);
    }

    public void setVerbose(boolean verbose, boolean temporary) {
        this.verbose = verbose;
        if (!temporary) {
            this.verbosePermanent = verbose;
        }
        this.verboseTemporary = temporary;
    }

    public String getMatchExpression() {
        return this.matchExpression;
    }

    void init(String matchExpression, Matcher matcher) {
        this.matcher = matcher;
        this.matches = new ArrayList<Match>(16);
        this.isFixedString = false;
        this.matchExpression = matchExpression;
        this.setVerbose(matcher.getVerbose());
        InitErrorListener errorListener = new InitErrorListener();
        ANTLRInputStream input = new ANTLRInputStream(this.matchExpression);
        UserAgentTreeWalkerLexer lexer = new UserAgentTreeWalkerLexer((CharStream)input);
        lexer.addErrorListener(errorListener);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        UserAgentTreeWalkerParser parser = new UserAgentTreeWalkerParser((TokenStream)tokens);
        parser.addErrorListener(errorListener);
        this.requiredPattern = parser.matcher();
        new UnQuoteValues().visit((ParseTree)this.requiredPattern);
        this.evaluator = new TreeExpressionEvaluator(this.requiredPattern, matcher.lookups);
        this.evaluator.setVerbose(this.verbose);
        String fixedValue = this.evaluator.getFixedValue();
        if (fixedValue != null) {
            this.setFixedValue(fixedValue);
            this.isFixedString = true;
            return;
        }
        this.registerAllPossiblyInterestingPatterns(matcher);
    }

    protected abstract void setFixedValue(String var1);

    public void inform(String key, String value, ParseTree result) {
        this.matches.add(new Match(key, value, result));
        this.matcher.gotAStartingPoint();
    }

    protected abstract void inform(String var1, String var2);

    public boolean canPossiblyBeValid() {
        return this.evaluator.usesIsNull() || this.isFixedString || !this.matches.isEmpty();
    }

    public abstract boolean obtainResult(UserAgent var1);

    boolean isValidIsNull() {
        return this.matches.isEmpty() && this.evaluator.usesIsNull();
    }

    void processInformedMatches() {
        for (Match match : this.matches) {
            String matchedValue = this.evaluator.evaluate(match.result, match.key, match.value);
            if (matchedValue == null) continue;
            this.inform(match.key, matchedValue);
            break;
        }
    }

    private void registerAllPossiblyInterestingPatterns(Matcher matcher) {
        if (this.requiredPattern == null) {
            throw new InvalidParserConfigurationException("NO pattern ?!?!?");
        }
        this.calculateInformPath(matcher, "agent", this.requiredPattern);
    }

    private void calculateInformPath(Matcher matcher, String treeName, UserAgentTreeWalkerParser.MatcherContext tree) {
        if (tree instanceof UserAgentTreeWalkerParser.MatcherNextLookupContext) {
            this.calculateInformPath(matcher, treeName, ((UserAgentTreeWalkerParser.MatcherNextLookupContext)tree).matcherLookup());
        } else if (tree instanceof UserAgentTreeWalkerParser.MatcherCleanVersionContext) {
            this.calculateInformPath(matcher, treeName, ((UserAgentTreeWalkerParser.MatcherCleanVersionContext)tree).matcherLookup());
        } else if (tree instanceof UserAgentTreeWalkerParser.MatcherPathIsNullContext) {
            this.calculateInformPath(matcher, treeName, ((UserAgentTreeWalkerParser.MatcherPathIsNullContext)tree).matcherLookup());
        }
    }

    private void calculateInformPath(Matcher matcher, String treeName, UserAgentTreeWalkerParser.MatcherLookupContext tree) {
        if (tree instanceof UserAgentTreeWalkerParser.MatcherPathContext) {
            this.calculateInformPath(matcher, treeName, ((UserAgentTreeWalkerParser.MatcherPathContext)tree).basePath());
        } else if (tree instanceof UserAgentTreeWalkerParser.MatcherPathLookupContext) {
            this.calculateInformPath(matcher, treeName, ((UserAgentTreeWalkerParser.MatcherPathLookupContext)tree).matcherLookup());
        }
    }

    private void calculateInformPath(Matcher matcher, String treeName, UserAgentTreeWalkerParser.BasePathContext tree) {
        if (tree instanceof UserAgentTreeWalkerParser.PathNoWalkContext) {
            matcher.informMeAbout(this, treeName);
        } else if (tree instanceof UserAgentTreeWalkerParser.PathWalkContext) {
            this.calculateInformPath(matcher, treeName, ((UserAgentTreeWalkerParser.PathWalkContext)tree).nextStep);
        }
    }

    private void calculateInformPath(Matcher matcher, String treeName, UserAgentTreeWalkerParser.PathContext tree) {
        if (tree != null) {
            if (tree instanceof UserAgentTreeWalkerParser.StepDownContext) {
                this.calculateInformPath(matcher, treeName, (UserAgentTreeWalkerParser.StepDownContext)tree);
                return;
            }
            if (tree instanceof UserAgentTreeWalkerParser.StepEqualsValueContext) {
                this.calculateInformPath(matcher, treeName, (UserAgentTreeWalkerParser.StepEqualsValueContext)tree);
                return;
            }
            if (tree instanceof UserAgentTreeWalkerParser.StepFirstWordsContext) {
                this.calculateInformPath(matcher, treeName, (UserAgentTreeWalkerParser.StepFirstWordsContext)tree);
                return;
            }
            if (tree instanceof UserAgentTreeWalkerParser.StepSingleWordContext) {
                this.calculateInformPath(matcher, treeName, (UserAgentTreeWalkerParser.StepSingleWordContext)tree);
                return;
            }
        }
        matcher.informMeAbout(this, treeName);
    }

    private void calculateInformPath(Matcher matcher, String treeName, UserAgentTreeWalkerParser.StepDownContext tree) {
        if (treeName.length() == 0) {
            this.calculateInformPath(matcher, treeName + '.' + tree.name.getText(), tree.nextStep);
        } else {
            for (Integer number : (NumberRangeList)this.numberRangeVisitor.visit((ParseTree)tree.numberRange())) {
                this.calculateInformPath(matcher, treeName + '.' + "(" + number + ")" + tree.name.getText(), tree.nextStep);
            }
        }
    }

    private void calculateInformPath(Matcher matcher, String treeName, UserAgentTreeWalkerParser.StepEqualsValueContext tree) {
        matcher.informMeAbout(this, treeName + "=\"" + tree.value.getText() + "\"");
    }

    private void calculateInformPath(Matcher matcher, String treeName, UserAgentTreeWalkerParser.StepFirstWordsContext tree) {
        this.calculateInformPath(matcher, treeName + tree.FIRSTWORDS() + tree.NUMBER(), tree.nextStep);
    }

    private void calculateInformPath(Matcher matcher, String treeName, UserAgentTreeWalkerParser.StepSingleWordContext tree) {
        this.calculateInformPath(matcher, treeName + tree.SINGLEWORD() + tree.NUMBER(), tree.nextStep);
    }

    public void reset() {
        if (!this.matches.isEmpty()) {
            this.matches.clear();
        }
        if (this.verboseTemporary) {
            this.verbose = this.verbosePermanent;
        }
    }

    public List<Match> getMatches() {
        return this.matches;
    }

    private static class UnQuoteValues
    extends UserAgentTreeWalkerBaseVisitor<Void> {
        private UnQuoteValues() {
        }

        private void unQuoteToken(Token token) {
            if (token instanceof CommonToken) {
                CommonToken commonToken = (CommonToken)token;
                commonToken.setStartIndex(commonToken.getStartIndex() + 1);
                commonToken.setStopIndex(commonToken.getStopIndex() - 1);
            }
        }

        @Override
        public Void visitMatcherPathLookup(UserAgentTreeWalkerParser.MatcherPathLookupContext ctx) {
            this.unQuoteToken(ctx.defaultValue);
            return (Void)super.visitMatcherPathLookup(ctx);
        }

        @Override
        public Void visitPathFixedValue(UserAgentTreeWalkerParser.PathFixedValueContext ctx) {
            this.unQuoteToken(ctx.value);
            return (Void)super.visitPathFixedValue(ctx);
        }

        @Override
        public Void visitStepEqualsValue(UserAgentTreeWalkerParser.StepEqualsValueContext ctx) {
            this.unQuoteToken(ctx.value);
            return (Void)super.visitStepEqualsValue(ctx);
        }

        @Override
        public Void visitStepNotEqualsValue(UserAgentTreeWalkerParser.StepNotEqualsValueContext ctx) {
            this.unQuoteToken(ctx.value);
            return (Void)super.visitStepNotEqualsValue(ctx);
        }

        @Override
        public Void visitStepStartsWithValue(UserAgentTreeWalkerParser.StepStartsWithValueContext ctx) {
            this.unQuoteToken(ctx.value);
            return (Void)super.visitStepStartsWithValue(ctx);
        }

        @Override
        public Void visitStepEndsWithValue(UserAgentTreeWalkerParser.StepEndsWithValueContext ctx) {
            this.unQuoteToken(ctx.value);
            return (Void)super.visitStepEndsWithValue(ctx);
        }

        @Override
        public Void visitStepContainsValue(UserAgentTreeWalkerParser.StepContainsValueContext ctx) {
            this.unQuoteToken(ctx.value);
            return (Void)super.visitStepContainsValue(ctx);
        }
    }

    class InitErrorListener
    implements ANTLRErrorListener {
        boolean hasAmbiguity;

        InitErrorListener() {
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            LOG.error("Syntax error");
            LOG.error("Source : {}", (Object)MatcherAction.this.matchExpression);
            LOG.error("Message: {}", (Object)msg);
            System.exit(-1);
        }

        public void reportAmbiguity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, boolean exact, BitSet ambigAlts, ATNConfigSet configs) {
            this.hasAmbiguity = true;
        }

        public void reportAttemptingFullContext(Parser recognizer, DFA dfa, int startIndex, int stopIndex, BitSet conflictingAlts, ATNConfigSet configs) {
        }

        public void reportContextSensitivity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, int prediction, ATNConfigSet configs) {
        }
    }

    public class Match {
        String key;
        String value;
        ParseTree result;

        public Match(String key, String value, ParseTree result) {
            this.key = key;
            this.value = value;
            this.result = result;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public ParseTree getResult() {
            return this.result;
        }
    }
}

