/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.analyze;

import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.analyze.Matcher;
import nl.basjes.parse.useragent.analyze.MatcherAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatcherExtractAction
extends MatcherAction {
    private static final Logger LOG = LoggerFactory.getLogger(MatcherExtractAction.class);
    private String attribute;
    private long confidence;
    private String foundValue = null;
    private String fixedValue = null;
    private String expression;

    public MatcherExtractAction(String attribute, long confidence, String config, Matcher matcher) {
        this.attribute = attribute;
        this.confidence = confidence;
        this.expression = config;
        this.init(config, matcher);
    }

    public boolean isFixedValue() {
        return this.fixedValue != null;
    }

    @Override
    protected void setFixedValue(String fixedValue) {
        if (this.verbose) {
            LOG.info("-- set Fixed value({} , {} , {})", new Object[]{this.attribute, this.confidence, fixedValue});
        }
        this.fixedValue = fixedValue;
    }

    public String getAttribute() {
        return this.attribute;
    }

    @Override
    public void inform(String key, String foundValue) {
        if (this.verbose) {
            LOG.info("INFO  : EXTRACT ({}): {}", (Object)this.attribute, (Object)key);
            LOG.info("NEED  : EXTRACT ({}): {}", (Object)this.attribute, (Object)this.getMatchExpression());
        }
        if (this.foundValue == null) {
            this.foundValue = foundValue;
            if (this.verbose) {
                LOG.info("KEPT  : EXTRACT ({}): {}", (Object)this.attribute, (Object)key);
            }
        } else if (this.verbose) {
            LOG.info("IGNORE: EXTRACT ({}): {}", (Object)this.attribute, (Object)key);
        }
    }

    @Override
    public boolean obtainResult(UserAgent userAgent) {
        this.processInformedMatches();
        if (this.fixedValue != null) {
            if (this.verbose) {
                LOG.info("Set fixedvalue ({})[{}]: {}", new Object[]{this.attribute, this.confidence, this.fixedValue});
            }
            userAgent.set(this.attribute, this.fixedValue, this.confidence);
            return true;
        }
        if (this.foundValue != null) {
            if (this.verbose) {
                LOG.info("Set parsevalue ({})[{}]: {}", new Object[]{this.attribute, this.confidence, this.foundValue});
            }
            userAgent.set(this.attribute, this.foundValue, this.confidence);
            return true;
        }
        if (this.verbose) {
            LOG.info("Nothing found for {}", (Object)this.attribute);
        }
        return false;
    }

    @Override
    public void reset() {
        super.reset();
        this.foundValue = null;
    }

    public String toString() {
        if (this.isFixedValue()) {
            return "Extract (FIXED): (" + this.attribute + ", " + this.confidence + ") = " + this.fixedValue;
        }
        return "Extract (DYNAM): (" + this.attribute + ", " + this.confidence + "): " + this.expression;
    }
}

