/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.analyze;

import java.util.HashMap;
import java.util.Map;
import nl.basjes.parse.useragent.UserAgentTreeWalkerBaseVisitor;
import nl.basjes.parse.useragent.UserAgentTreeWalkerParser;
import nl.basjes.parse.useragent.analyze.NumberRangeList;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

public class NumberRangeVisitor
extends UserAgentTreeWalkerBaseVisitor<NumberRangeList> {
    private static final Integer DEFAULT_MIN = 1;
    private static final Integer DEFAULT_MAX = 10;
    private static Map<String, Integer> MAX_RANGE = new HashMap<String, Integer>();
    private static final NumberRangeVisitor singleton;

    private Integer getMaxRange(UserAgentTreeWalkerParser.NumberRangeContext ctx) {
        ParserRuleContext parent = ctx.getParent();
        if (!(parent instanceof UserAgentTreeWalkerParser.StepDownContext)) {
            return DEFAULT_MAX;
        }
        String name = ((UserAgentTreeWalkerParser.StepDownContext)parent).name.getText();
        if (name == null) {
            return DEFAULT_MAX;
        }
        Integer maxRange = MAX_RANGE.get(name);
        if (maxRange == null) {
            return DEFAULT_MAX;
        }
        return maxRange;
    }

    public static NumberRangeList getList(UserAgentTreeWalkerParser.NumberRangeContext ctx) {
        return (NumberRangeList)singleton.visit((ParseTree)ctx);
    }

    @Override
    public NumberRangeList visitNumberRangeStartToEnd(UserAgentTreeWalkerParser.NumberRangeStartToEndContext ctx) {
        return new NumberRangeList(Integer.parseInt(ctx.rangeStart.getText()), Integer.parseInt(ctx.rangeEnd.getText()));
    }

    @Override
    public NumberRangeList visitNumberRangeSingleValue(UserAgentTreeWalkerParser.NumberRangeSingleValueContext ctx) {
        int value = Integer.parseInt(ctx.count.getText());
        return new NumberRangeList(value, value);
    }

    @Override
    public NumberRangeList visitNumberRangeAll(UserAgentTreeWalkerParser.NumberRangeAllContext ctx) {
        return new NumberRangeList(DEFAULT_MIN, this.getMaxRange(ctx));
    }

    @Override
    public NumberRangeList visitNumberRangeEmpty(UserAgentTreeWalkerParser.NumberRangeEmptyContext ctx) {
        return new NumberRangeList(DEFAULT_MIN, this.getMaxRange(ctx));
    }

    static {
        MAX_RANGE.put("agent", 1);
        MAX_RANGE.put("name", 1);
        MAX_RANGE.put("key", 1);
        MAX_RANGE.put("value", 2);
        MAX_RANGE.put("version", 5);
        MAX_RANGE.put("comments", 2);
        MAX_RANGE.put("entry", 20);
        MAX_RANGE.put("product", 10);
        MAX_RANGE.put("email", 2);
        MAX_RANGE.put("keyvalue", 3);
        MAX_RANGE.put("text", 8);
        MAX_RANGE.put("url", 2);
        MAX_RANGE.put("uuid", 4);
        singleton = new NumberRangeVisitor();
    }
}

