/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.analyze.treewalker.steps;

import nl.basjes.parse.useragent.UserAgentParser;
import nl.basjes.parse.useragent.analyze.treewalker.steps.GetResultValueVisitor;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Step {
    protected static Logger LOG = LoggerFactory.getLogger(Step.class);
    private int stepNr;
    protected String logprefix = "";
    private Step nextStep;
    protected boolean verbose = false;

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public final void setNextStep(int stepNr, Step nextStep) {
        this.stepNr = stepNr;
        this.nextStep = nextStep;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < stepNr + 1; ++i) {
            sb.append("-->");
        }
        this.logprefix = sb.toString();
    }

    protected final String walkNextStep(ParseTree tree, String value) {
        if (this.nextStep == null) {
            String result = value;
            if (value == null) {
                result = GetResultValueVisitor.getResultValue(tree);
            }
            if (this.verbose) {
                LOG.info("{} Final (implicit) step: {}", (Object)this.logprefix, (Object)result);
            }
            return result;
        }
        if (this.verbose) {
            LOG.info("{} Tree: >>>{}<<<", (Object)this.logprefix, (Object)tree.getText());
            LOG.info("{} Enter step({}): {}", new Object[]{this.logprefix, this.stepNr, this.nextStep});
        }
        String result = this.nextStep.walk(tree, value);
        if (this.verbose) {
            LOG.info("{} Leave step ({}): {}", new Object[]{this.logprefix, result == null ? "-" : "+", this.nextStep});
        }
        return result;
    }

    protected final ParseTree up(ParseTree tree) {
        if (tree == null) {
            return null;
        }
        if (tree instanceof UserAgentParser.ProductNameBareContext || tree instanceof UserAgentParser.ProductNameEmailContext || tree instanceof UserAgentParser.ProductNameUuidContext || tree instanceof UserAgentParser.ProductNameKeyValueContext || tree instanceof UserAgentParser.ProductNameVersionContext) {
            return this.up(tree.getParent());
        }
        return tree.getParent();
    }

    protected final boolean treeIsSeparator(ParseTree tree) {
        return tree instanceof UserAgentParser.CommentSeparatorContext || tree instanceof TerminalNode;
    }

    protected String getActualValue(ParseTree tree, String value) {
        if (value == null) {
            return tree.getText();
        }
        return value;
    }

    protected Integer tokenToInteger(Token token) {
        if (token == null) {
            return null;
        }
        try {
            return Integer.parseInt(token.getText());
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public abstract String walk(ParseTree var1, String var2);

    public Step getNextStep() {
        return this.nextStep;
    }
}

