/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.analyze.treewalker.steps;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import nl.basjes.parse.useragent.UserAgentTreeWalkerBaseVisitor;
import nl.basjes.parse.useragent.UserAgentTreeWalkerParser;
import nl.basjes.parse.useragent.analyze.InvalidParserConfigurationException;
import nl.basjes.parse.useragent.analyze.treewalker.steps.Step;
import nl.basjes.parse.useragent.analyze.treewalker.steps.compare.StepCleanVersion;
import nl.basjes.parse.useragent.analyze.treewalker.steps.compare.StepContains;
import nl.basjes.parse.useragent.analyze.treewalker.steps.compare.StepEndsWith;
import nl.basjes.parse.useragent.analyze.treewalker.steps.compare.StepEquals;
import nl.basjes.parse.useragent.analyze.treewalker.steps.compare.StepIsNull;
import nl.basjes.parse.useragent.analyze.treewalker.steps.compare.StepNotEquals;
import nl.basjes.parse.useragent.analyze.treewalker.steps.compare.StepStartsWith;
import nl.basjes.parse.useragent.analyze.treewalker.steps.lookup.StepDefaultValue;
import nl.basjes.parse.useragent.analyze.treewalker.steps.lookup.StepLookup;
import nl.basjes.parse.useragent.analyze.treewalker.steps.value.StepBackToFull;
import nl.basjes.parse.useragent.analyze.treewalker.steps.value.StepFirstWords;
import nl.basjes.parse.useragent.analyze.treewalker.steps.value.StepFixedString;
import nl.basjes.parse.useragent.analyze.treewalker.steps.value.StepSingleWord;
import nl.basjes.parse.useragent.analyze.treewalker.steps.walk.StepDown;
import nl.basjes.parse.useragent.analyze.treewalker.steps.walk.StepNext;
import nl.basjes.parse.useragent.analyze.treewalker.steps.walk.StepPrev;
import nl.basjes.parse.useragent.analyze.treewalker.steps.walk.StepUp;
import org.antlr.v4.runtime.tree.ParseTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WalkList {
    private static final Logger LOG = LoggerFactory.getLogger(WalkList.class);
    private Map<String, Map<String, String>> lookups;
    private List<Step> steps = new ArrayList<Step>();
    private boolean verbose;

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
        for (Step step : this.steps) {
            step.setVerbose(verbose);
        }
    }

    public WalkList(UserAgentTreeWalkerParser.MatcherContext requiredPattern, Map<String, Map<String, String>> lookups) {
        this.lookups = lookups;
        new WalkListBuilder().visit((ParseTree)requiredPattern);
        this.linkSteps();
        int i = 1;
        if (this.verbose) {
            LOG.info("------------------------------------");
            LOG.info("Required: " + requiredPattern.getText());
            for (Step step : this.steps) {
                step.setVerbose(this.verbose);
                LOG.info("{}: {}", (Object)i++, (Object)step);
            }
        }
    }

    private void linkSteps() {
        if (this.steps.size() > 0) {
            int i;
            for (i = 0; i < this.steps.size() - 1; ++i) {
                this.steps.get(i).setNextStep(i, this.steps.get(i + 1));
            }
            this.steps.get(i).setNextStep(i, null);
        }
    }

    public String walk(ParseTree tree, String value) {
        if (this.steps.size() == 0) {
            return value;
        }
        Step firstStep = this.steps.get(0);
        if (this.verbose) {
            Step.LOG.info("Tree: >>>{}<<<", (Object)tree.getText());
            Step.LOG.info("Enter step: {}", (Object)firstStep);
        }
        String result = firstStep.walk(tree, value);
        if (this.verbose) {
            Step.LOG.info("Leave step ({}): {}", (Object)(result == null ? "-" : "+"), (Object)firstStep);
        }
        return result;
    }

    public Step getFirstStep() {
        if (this.steps == null || this.steps.size() == 0) {
            return null;
        }
        return this.steps.get(0);
    }

    public String toString() {
        if (this.steps.size() == 0) {
            return "Empty";
        }
        StringBuilder sb = new StringBuilder(128);
        for (Step step : this.steps) {
            sb.append(" --> ").append(step);
        }
        return sb.toString();
    }

    private class WalkListBuilder
    extends UserAgentTreeWalkerBaseVisitor<Void> {
        private static final boolean COMPARE_CASE_INSENSITIVE = false;
        boolean foundHashEntryPoint = false;

        private WalkListBuilder() {
        }

        private void add(Step step) {
            if (this.foundHashEntryPoint) {
                WalkList.this.steps.add(step);
            }
        }

        private void visitNext(UserAgentTreeWalkerParser.PathContext nextStep) {
            if (nextStep != null) {
                this.visit((ParseTree)nextStep);
            }
        }

        @Override
        public Void visitMatcherPath(UserAgentTreeWalkerParser.MatcherPathContext ctx) {
            this.visit((ParseTree)ctx.basePath());
            return null;
        }

        @Override
        public Void visitMatcherPathLookup(UserAgentTreeWalkerParser.MatcherPathLookupContext ctx) {
            if (ctx.defaultValue != null) {
                WalkList.this.steps.add(new StepDefaultValue(ctx.defaultValue.getText()));
            }
            this.visit((ParseTree)ctx.matcherLookup());
            String lookupName = ctx.lookup.getText();
            Map lookup = (Map)WalkList.this.lookups.get(lookupName);
            if (lookup == null) {
                throw new InvalidParserConfigurationException("Missing lookup \"" + ctx.lookup.getText() + "\" ");
            }
            WalkList.this.steps.add(new StepLookup(lookupName, lookup));
            return null;
        }

        @Override
        public Void visitMatcherCleanVersion(UserAgentTreeWalkerParser.MatcherCleanVersionContext ctx) {
            this.visit((ParseTree)ctx.matcherLookup());
            WalkList.this.steps.add(new StepCleanVersion());
            return null;
        }

        @Override
        public Void visitMatcherPathIsNull(UserAgentTreeWalkerParser.MatcherPathIsNullContext ctx) {
            WalkList.this.steps.add(new StepIsNull());
            this.visit((ParseTree)ctx.matcherLookup());
            return null;
        }

        @Override
        public Void visitPathFixedValue(UserAgentTreeWalkerParser.PathFixedValueContext ctx) {
            this.add(new StepFixedString(ctx.value.getText()));
            return null;
        }

        @Override
        public Void visitPathWalk(UserAgentTreeWalkerParser.PathWalkContext ctx) {
            this.visitNext(ctx.nextStep);
            return null;
        }

        @Override
        public Void visitStepDown(UserAgentTreeWalkerParser.StepDownContext ctx) {
            this.add(new StepDown(ctx.numberRange(), ctx.name.getText()));
            this.visitNext(ctx.nextStep);
            return null;
        }

        @Override
        public Void visitStepUp(UserAgentTreeWalkerParser.StepUpContext ctx) {
            this.foundHashEntryPoint = true;
            this.add(new StepUp());
            this.visitNext(ctx.nextStep);
            return null;
        }

        @Override
        public Void visitStepNext(UserAgentTreeWalkerParser.StepNextContext ctx) {
            this.foundHashEntryPoint = true;
            this.add(new StepNext());
            this.visitNext(ctx.nextStep);
            return null;
        }

        @Override
        public Void visitStepPrev(UserAgentTreeWalkerParser.StepPrevContext ctx) {
            this.foundHashEntryPoint = true;
            this.add(new StepPrev());
            this.visitNext(ctx.nextStep);
            return null;
        }

        @Override
        public Void visitStepEqualsValue(UserAgentTreeWalkerParser.StepEqualsValueContext ctx) {
            this.add(new StepEquals(ctx.value.getText()));
            this.foundHashEntryPoint = true;
            this.visitNext(ctx.nextStep);
            return null;
        }

        @Override
        public Void visitStepNotEqualsValue(UserAgentTreeWalkerParser.StepNotEqualsValueContext ctx) {
            this.foundHashEntryPoint = true;
            this.add(new StepNotEquals(ctx.value.getText()));
            this.visitNext(ctx.nextStep);
            return null;
        }

        @Override
        public Void visitStepStartsWithValue(UserAgentTreeWalkerParser.StepStartsWithValueContext ctx) {
            this.foundHashEntryPoint = true;
            this.add(new StepStartsWith(ctx.value.getText()));
            this.visitNext(ctx.nextStep);
            return null;
        }

        @Override
        public Void visitStepEndsWithValue(UserAgentTreeWalkerParser.StepEndsWithValueContext ctx) {
            this.foundHashEntryPoint = true;
            this.add(new StepEndsWith(ctx.value.getText()));
            this.visitNext(ctx.nextStep);
            return null;
        }

        @Override
        public Void visitStepContainsValue(UserAgentTreeWalkerParser.StepContainsValueContext ctx) {
            this.foundHashEntryPoint = true;
            this.add(new StepContains(ctx.value.getText()));
            this.visitNext(ctx.nextStep);
            return null;
        }

        @Override
        public Void visitStepFirstWords(UserAgentTreeWalkerParser.StepFirstWordsContext ctx) {
            this.add(new StepFirstWords(ctx.NUMBER().getSymbol()));
            this.visitNext(ctx.nextStep);
            return null;
        }

        @Override
        public Void visitStepSingleWord(UserAgentTreeWalkerParser.StepSingleWordContext ctx) {
            this.add(new StepSingleWord(ctx.NUMBER().getSymbol()));
            this.visitNext(ctx.nextStep);
            return null;
        }

        @Override
        public Void visitStepBackToFull(UserAgentTreeWalkerParser.StepBackToFullContext ctx) {
            this.add(new StepBackToFull());
            this.visitNext(ctx.nextStep);
            return null;
        }
    }
}

