/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.dissector;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.ParsedField;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import nl.basjes.parse.core.exceptions.InvalidDissectorException;

public class UserAgentVersionDissector
extends Dissector {
    private static final String INPUT_TYPE = "HTTP.USERAGENT.VERSION";

    public String getInputType() {
        return INPUT_TYPE;
    }

    public boolean initializeFromSettingsParameter(String s) {
        return true;
    }

    public void dissect(Parsable<?> parsable, String inputname) throws DissectionFailure {
        ParsedField versionField = parsable.getParsableField(INPUT_TYPE, inputname);
        String versionString = versionField.getValue().getString();
        if (versionString == null || versionString.length() <= 1) {
            return;
        }
        String full = versionString.replaceAll("_", ".");
        parsable.addDissection(inputname, "STRING", "full", full);
        int firstDot = full.indexOf(46);
        if (firstDot == -1) {
            parsable.addDissection(inputname, "STRING", "major", full);
        } else {
            String major = full.substring(0, firstDot);
            parsable.addDissection(inputname, "STRING", "major", major);
            int secondDot = full.indexOf(46, firstDot + 1);
            if (secondDot == -1) {
                parsable.addDissection(inputname, "STRING", "minor", full);
            } else {
                String minor = full.substring(0, secondDot);
                parsable.addDissection(inputname, "STRING", "minor", minor);
            }
        }
    }

    public List<String> getPossibleOutput() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("STRING:major");
        result.add("STRING:minor");
        result.add("STRING:full");
        return result;
    }

    public EnumSet<Casts> prepareForDissect(String s, String s1) {
        return Casts.STRING_ONLY;
    }

    public void prepareForRun() throws InvalidDissectorException {
    }

    protected void initializeNewInstance(Dissector dissector) {
    }
}

