/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.pig;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.UserAgentAnalyzer;
import org.apache.pig.EvalFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class ParseUserAgent
extends EvalFunc<Tuple> {
    private static final TupleFactory tupleFactory = TupleFactory.getInstance();
    private static final UserAgentAnalyzer userAgentAnalyzer = new UserAgentAnalyzer();
    private static List<String> allFieldNames = null;

    private static List<String> getAllFieldNamesSorted() {
        if (allFieldNames == null) {
            allFieldNames = userAgentAnalyzer.getAllPossibleFieldNamesSorted();
        }
        return allFieldNames;
    }

    public Tuple exec(Tuple tuple) throws IOException {
        String userAgentString = (String)tuple.get(0);
        UserAgent agent = userAgentAnalyzer.parse(userAgentString);
        Tuple result = tupleFactory.newTuple();
        for (String fieldName : ParseUserAgent.getAllFieldNamesSorted()) {
            result.append((Object)agent.getValue(fieldName));
        }
        return result;
    }

    public Schema outputSchema(Schema input) {
        try {
            Schema tupleSchema = new Schema();
            for (String fieldName : ParseUserAgent.getAllFieldNamesSorted()) {
                tupleSchema.add(new Schema.FieldSchema(fieldName, 55));
            }
            return new Schema(new Schema.FieldSchema("UserAgent", tupleSchema, 110));
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<FuncSpec> getArgToFuncMapping() throws FrontendException {
        ArrayList<FuncSpec> funcList = new ArrayList<FuncSpec>();
        Schema s = new Schema();
        s.add(new Schema.FieldSchema(null, 55));
        funcList.add(new FuncSpec(((Object)((Object)this)).getClass().getName(), s));
        return funcList;
    }
}

