/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.UserAgentAnalyzer;
import nl.basjes.parse.useragent.analyze.Analyzer;
import nl.basjes.parse.useragent.analyze.MatcherAction;
import nl.basjes.parse.useragent.parse.UserAgentTreeFlattener;
import org.antlr.v4.runtime.tree.ParseTree;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Main {
    private static final Logger LOG = LoggerFactory.getLogger(Main.class);

    private Main() {
    }

    public static void main(String[] args) throws IOException {
        int returnValue = 0;
        CommandOptions commandlineOptions = new CommandOptions();
        CmdLineParser parser = new CmdLineParser((Object)commandlineOptions);
        try {
            String strLine;
            parser.parseArgument(args);
            UserAgentAnalyzer uaa = new UserAgentAnalyzer();
            UserAgentTreeFlattener flattenPrinter = new UserAgentTreeFlattener(new FlattenPrinter());
            uaa.setVerbose(commandlineOptions.debug);
            FileInputStream fstream = new FileInputStream(commandlineOptions.inFile);
            BufferedReader br = new BufferedReader(new InputStreamReader(fstream));
            if (commandlineOptions.csvFormat) {
                for (String field : UserAgent.PRE_SORTED_FIELDS_LIST) {
                    System.out.print(field);
                    System.out.print("\t");
                }
                System.out.println("Useragent");
            }
            long ambiguities = 0L;
            long syntaxErrors = 0L;
            long linesTotal = 0L;
            long hitsTotal = 0L;
            long ipsTotal = 0L;
            long linesOk = 0L;
            long hitsOk = 0L;
            long ipsOk = 0L;
            long linesMatched = 0L;
            long hitsMatched = 0L;
            long ipsMatched = 0L;
            long start = System.nanoTime();
            LOG.info("Start @ {}", (Object)start);
            long segmentStartTime = start;
            long segmentStartLines = linesTotal;
            while ((strLine = br.readLine()) != null) {
                if (strLine.startsWith(" ") || strLine.startsWith("#") || strLine.isEmpty()) continue;
                long hits = 1L;
                long ips = 1L;
                Object agentStr = strLine;
                if (strLine.contains("\t")) {
                    String[] parts = strLine.split("\t", 3);
                    hits = Long.parseLong(parts[0]);
                    ips = Long.parseLong(parts[1]);
                    agentStr = parts[2];
                }
                if (commandlineOptions.fullFlatten) {
                    flattenPrinter.parse((String)agentStr);
                    continue;
                }
                if (commandlineOptions.matchedFlatten) {
                    for (MatcherAction.Match match : uaa.getUsedMatches(new UserAgent((String)agentStr))) {
                        System.out.println(match.getKey() + " " + match.getValue());
                    }
                    continue;
                }
                UserAgent agent = uaa.parse((String)agentStr);
                boolean hasBad = false;
                for (String field : UserAgent.STANDARD_FIELDS) {
                    if (agent.get((String)field).confidence >= 0L) continue;
                    hasBad = true;
                    break;
                }
                ++linesTotal;
                hitsTotal += hits;
                ipsTotal += ips;
                if (agent.hasSyntaxError()) {
                    if (commandlineOptions.yamlFormat) {
                        System.out.println("# Syntax error: " + (String)agentStr);
                    }
                } else {
                    ++linesOk;
                    hitsOk += hits;
                    ipsOk += ips;
                }
                if (!hasBad) {
                    ++linesMatched;
                    hitsMatched += hits;
                    ipsMatched += ips;
                }
                if (agent.hasAmbiguity()) {
                    ++ambiguities;
                }
                if (agent.hasSyntaxError()) {
                    ++syntaxErrors;
                }
                if (linesTotal % 1000L == 0L) {
                    long nowTime = System.nanoTime();
                    long speed = 1000000000L * (linesTotal - segmentStartLines) / (nowTime - segmentStartTime);
                    System.err.println("Lines = " + linesTotal + " (A=" + ambiguities + " S=" + syntaxErrors + ")  Speed = " + speed + "/sec.");
                    segmentStartTime = nowTime;
                    segmentStartLines = linesTotal;
                    ambiguities = 0L;
                    syntaxErrors = 0L;
                }
                if (commandlineOptions.outputOnlyBadResults && hasBad) continue;
                if (commandlineOptions.yamlFormat) {
                    System.out.print(agent.toYamlTestCase());
                }
                if (commandlineOptions.jsonFormat) {
                    System.out.print(agent.toJson());
                }
                if (!commandlineOptions.csvFormat) continue;
                for (String field : UserAgent.PRE_SORTED_FIELDS_LIST) {
                    String value = agent.getValue(field);
                    if (value != null) {
                        System.out.print(value);
                    }
                    System.out.print("\t");
                }
                System.out.println(agent.getUserAgentString());
            }
            br.close();
            long stop = System.nanoTime();
            LOG.info("Stop  @ {}", (Object)stop);
            LOG.info("-------------------------------------------------------------");
            LOG.info("Performance: {} in {} sec --> {}/sec", new Object[]{linesTotal, (stop - start) / 1000000000L, 1000000000L * linesTotal / (stop - start)});
            LOG.info("-------------------------------------------------------------");
            LOG.info("Parse results of {} lines", (Object)linesTotal);
            LOG.info("Parsed without error: {} (={}%)", (Object)linesOk, (Object)(100.0 * (double)linesOk / (double)linesTotal));
            LOG.info("Fully matched       : {} (={}%)", (Object)linesMatched, (Object)(100.0 * (double)linesMatched / (double)linesTotal));
            LOG.info("-------------------------------------------------------------");
            LOG.info("Parse results of {} hits", (Object)hitsTotal);
            LOG.info("Parsed without error: {} (={}%)", (Object)hitsOk, (Object)(100.0 * (double)hitsOk / (double)hitsTotal));
            LOG.info("Fully matched       : {} (={}%)", (Object)hitsMatched, (Object)(100.0 * (double)hitsMatched / (double)hitsTotal));
            LOG.info("-------------------------------------------------------------");
            LOG.info("Parse results of {} ips", (Object)ipsTotal);
            LOG.info("Parsed without error: {} (={}%)", (Object)ipsOk, (Object)(100.0 * (double)ipsOk / (double)ipsTotal));
            LOG.info("Fully matched       : {} (={}%)", (Object)ipsMatched, (Object)(100.0 * (double)ipsMatched / (double)ipsTotal));
            LOG.info("-------------------------------------------------------------");
        }
        catch (CmdLineException e) {
            LOG.error("Errors: " + e.getMessage());
            LOG.error("");
            System.err.println("Usage: java jar <jar containing this class> <options>");
            parser.printUsage((OutputStream)System.out);
            returnValue = 1;
        }
        catch (Exception e) {
            LOG.error("IOException:" + e);
            returnValue = 1;
        }
        System.exit(returnValue);
    }

    public static class FlattenPrinter
    extends Analyzer {
        @Override
        public void inform(String path, String value, ParseTree ctx) {
            System.out.println(path);
        }

        @Override
        public void informMeAbout(MatcherAction matcherAction, String keyPattern) {
        }
    }

    private static class CommandOptions {
        @Option(name="-in", usage="Location of input file", required=true)
        private String inFile;
        @Option(name="-yaml", usage="Output in yaml testcase format", required=false, forbids={"-csv", "-json"})
        private boolean yamlFormat = false;
        @Option(name="-csv", usage="Output in csv format", required=false, forbids={"-yaml", "-json"})
        private boolean csvFormat = false;
        @Option(name="-json", usage="Output in json format", required=false, forbids={"-yaml", "-csv"})
        private boolean jsonFormat = false;
        @Option(name="-bad", usage="Output only cases that have a problem", required=false)
        private boolean outputOnlyBadResults = false;
        @Option(name="-debug", usage="Set to enable debugging.", required=false)
        private boolean debug = false;
        @Option(name="-fullFlatten", usage="Set to flatten each parsed agent string.", required=false)
        private boolean fullFlatten = false;
        @Option(name="-matchedFlatten", usage="Set to get the flattened values that were relevant for the Matchers.", required=false)
        private boolean matchedFlatten = false;

        private CommandOptions() {
        }
    }
}

