/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.basjes.parse.useragent.UserAgentBaseListener;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.dfa.DFA;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAgent
extends UserAgentBaseListener
implements ANTLRErrorListener {
    private static final Logger LOG = LoggerFactory.getLogger(UserAgent.class);
    public static final String DEVICE_CLASS = "DeviceClass";
    public static final String DEVICE_BRAND = "DeviceBrand";
    public static final String DEVICE_NAME = "DeviceName";
    public static final String OPERATING_SYSTEM_CLASS = "OperatingSystemClass";
    public static final String OPERATING_SYSTEM_NAME = "OperatingSystemName";
    public static final String OPERATING_SYSTEM_VERSION = "OperatingSystemVersion";
    public static final String LAYOUT_ENGINE_CLASS = "LayoutEngineClass";
    public static final String LAYOUT_ENGINE_NAME = "LayoutEngineName";
    public static final String LAYOUT_ENGINE_VERSION = "LayoutEngineVersion";
    public static final String LAYOUT_ENGINE_VERSION_MAJOR = "LayoutEngineVersionMajor";
    public static final String AGENT_CLASS = "AgentClass";
    public static final String AGENT_NAME = "AgentName";
    public static final String AGENT_VERSION = "AgentVersion";
    public static final String AGENT_VERSION_MAJOR = "AgentVersionMajor";
    public static final String SYNTAX_ERROR = "__SyntaxError__";
    public static final String[] STANDARD_FIELDS = new String[]{"DeviceClass", "DeviceName", "OperatingSystemClass", "OperatingSystemName", "OperatingSystemVersion", "LayoutEngineClass", "LayoutEngineName", "LayoutEngineVersion", "LayoutEngineVersionMajor", "AgentClass", "AgentName", "AgentVersion", "AgentVersionMajor"};
    private boolean hasSyntaxError;
    private boolean hasAmbiguity;
    private int ambiguityCount;
    private String userAgentString = null;
    private boolean debug = false;
    private Map<String, AgentField> allFields = new HashMap<String, AgentField>(32);
    public static final List<String> PRE_SORTED_FIELDS_LIST = new ArrayList<String>(32);

    public boolean hasSyntaxError() {
        return this.hasSyntaxError;
    }

    public boolean hasAmbiguity() {
        return this.hasAmbiguity;
    }

    public int getAmbiguityCount() {
        return this.ambiguityCount;
    }

    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
        if (this.debug) {
            LOG.error("Syntax error");
            LOG.error("Source : {}", (Object)this.userAgentString);
            LOG.error("Message: {}", (Object)msg);
        }
        this.hasSyntaxError = true;
        AgentField syntaxError = new AgentField("false");
        syntaxError.setValue("true", 1L);
        this.allFields.put(SYNTAX_ERROR, syntaxError);
    }

    public void reportAmbiguity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, boolean exact, BitSet ambigAlts, ATNConfigSet configs) {
        this.hasAmbiguity = true;
        ++this.ambiguityCount;
    }

    public void reportAttemptingFullContext(Parser recognizer, DFA dfa, int startIndex, int stopIndex, BitSet conflictingAlts, ATNConfigSet configs) {
    }

    public void reportContextSensitivity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, int prediction, ATNConfigSet configs) {
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean newDebug) {
        this.debug = newDebug;
    }

    public UserAgent() {
        this.init();
    }

    public UserAgent(String userAgentString) {
        this.init();
        this.setUserAgentString(userAgentString);
    }

    public UserAgent(UserAgent userAgent) {
        this.clone(userAgent);
    }

    public void clone(UserAgent userAgent) {
        this.init();
        this.setUserAgentString(this.userAgentString);
        for (Map.Entry<String, AgentField> entry : userAgent.allFields.entrySet()) {
            this.set(entry.getKey(), entry.getValue().getValue(), entry.getValue().confidence);
        }
    }

    private void init() {
        this.allFields.put(DEVICE_CLASS, new AgentField("Unknown"));
        this.allFields.put(DEVICE_BRAND, new AgentField("Unknown"));
        this.allFields.put(DEVICE_NAME, new AgentField("Unknown"));
        this.allFields.put(OPERATING_SYSTEM_CLASS, new AgentField("Unknown"));
        this.allFields.put(OPERATING_SYSTEM_NAME, new AgentField("Unknown"));
        this.allFields.put(OPERATING_SYSTEM_VERSION, new AgentField("Unknown"));
        this.allFields.put(LAYOUT_ENGINE_CLASS, new AgentField("Unknown"));
        this.allFields.put(LAYOUT_ENGINE_NAME, new AgentField("Unknown"));
        this.allFields.put(LAYOUT_ENGINE_VERSION, new AgentField("Unknown"));
        this.allFields.put(LAYOUT_ENGINE_VERSION_MAJOR, new AgentField("Unknown"));
        this.allFields.put(AGENT_CLASS, new AgentField("Unknown"));
        this.allFields.put(AGENT_NAME, new AgentField("Unknown"));
        this.allFields.put(AGENT_VERSION, new AgentField("Unknown"));
        this.allFields.put(AGENT_VERSION_MAJOR, new AgentField("Unknown"));
    }

    public void setUserAgentString(String newUserAgentString) {
        this.userAgentString = newUserAgentString;
        this.reset();
    }

    public String getUserAgentString() {
        return this.userAgentString;
    }

    public void reset() {
        this.hasSyntaxError = false;
        this.hasAmbiguity = false;
        this.ambiguityCount = 0;
        for (AgentField field : this.allFields.values()) {
            field.reset();
        }
    }

    public void set(String attribute, String value, long confidence) {
        AgentField field = this.allFields.get(attribute);
        if (field == null) {
            field = new AgentField(null);
        }
        boolean wasEmpty = confidence == -1L;
        boolean updated = field.setValue(value, confidence);
        if (this.debug && !wasEmpty) {
            if (updated) {
                LOG.info("USE  {} ({}) = {}", new Object[]{attribute, confidence, value});
            } else {
                LOG.info("SKIP {} ({}) = {}", new Object[]{attribute, confidence, value});
            }
        }
        this.allFields.put(attribute, field);
    }

    public void set(UserAgent newValuesUserAgent) {
        for (String fieldName : newValuesUserAgent.allFields.keySet()) {
            this.set(fieldName, newValuesUserAgent.allFields.get(fieldName));
        }
    }

    private void set(String fieldName, AgentField agentField) {
        this.set(fieldName, agentField.value, agentField.confidence);
    }

    public AgentField get(String fieldName) {
        return this.allFields.get(fieldName);
    }

    public String getValue(String fieldName) {
        AgentField field = this.allFields.get(fieldName);
        if (field == null) {
            return null;
        }
        return field.getValue();
    }

    public String getConfidence(String fieldName) {
        AgentField field = this.allFields.get(fieldName);
        if (field == null) {
            return null;
        }
        return field.getValue();
    }

    public String toYamlTestCase() {
        StringBuilder sb = new StringBuilder(10240);
        sb.append("\n");
        sb.append("  - test:\n");
        sb.append("#      options:\n");
        sb.append("#        - 'verbose'\n");
        sb.append("#        - 'init'\n");
        sb.append("#        - 'only'\n");
        sb.append("      input:\n");
        sb.append("#        name: 'You can give the test case a name'\n");
        sb.append("        user_agent_string: '").append(this.userAgentString).append("'\n");
        sb.append("      expected:\n");
        List<String> fieldNames = this.getAvailableFieldNamesSorted();
        int maxNameLength = 0;
        int maxValueLength = 0;
        for (String fieldName : this.allFields.keySet()) {
            maxNameLength = Math.max(maxNameLength, fieldName.length());
        }
        for (String fieldName : fieldNames) {
            maxValueLength = Math.max(maxValueLength, this.get(fieldName).getValue().length());
        }
        for (String fieldName : fieldNames) {
            sb.append("        ").append(fieldName);
            for (int l = fieldName.length(); l < maxNameLength + 7; ++l) {
                sb.append(' ');
            }
            String value = this.get(fieldName).getValue();
            sb.append(": '").append(value).append('\'');
            for (int l = value.length(); l < maxValueLength + 5; ++l) {
                sb.append(' ');
            }
            sb.append("# ").append(this.get((String)fieldName).confidence);
            sb.append('\n');
        }
        sb.append("\n");
        sb.append("\n");
        return sb.toString();
    }

    public String toJson() {
        StringBuilder sb = new StringBuilder(10240);
        sb.append("{");
        List<String> fieldNames = this.getAvailableFieldNames();
        Collections.sort(fieldNames);
        for (String fieldName : STANDARD_FIELDS) {
            fieldNames.remove(fieldName);
            sb.append('\"').append(StringEscapeUtils.escapeJson((String)fieldName)).append('\"').append(':').append('\"').append(StringEscapeUtils.escapeJson((String)this.get(fieldName).getValue())).append('\"').append(',');
        }
        for (String fieldName : fieldNames) {
            sb.append('\"').append(StringEscapeUtils.escapeJson((String)fieldName)).append('\"').append(':').append('\"').append(StringEscapeUtils.escapeJson((String)this.get(fieldName).getValue())).append('\"').append(',');
        }
        sb.append("\"user_agent_string\":").append('\"').append(StringEscapeUtils.escapeJson((String)this.userAgentString)).append('\"').append("}\n");
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("  - user_agent_string: '\"" + this.userAgentString + "\"'\n");
        int maxLength = 0;
        for (String fieldName : this.allFields.keySet()) {
            maxLength = Math.max(maxLength, fieldName.length());
        }
        for (String fieldName : this.allFields.keySet()) {
            AgentField field = this.allFields.get(fieldName);
            if (field.getValue() == null) continue;
            sb.append("    ").append(fieldName);
            for (int l = fieldName.length(); l < maxLength + 2; ++l) {
                sb.append(' ');
            }
            sb.append(": '").append(field.getValue()).append('\'');
            sb.append("# ").append(field.confidence);
            sb.append('\n');
        }
        return sb.toString();
    }

    public List<String> getAvailableFieldNames() {
        ArrayList<String> resultSet = new ArrayList<String>(this.allFields.size());
        for (String fieldName : this.allFields.keySet()) {
            AgentField field = this.allFields.get(fieldName);
            if (field == null || field.confidence < 0L || field.getValue() == null) continue;
            resultSet.add(fieldName);
        }
        return resultSet;
    }

    public List<String> getAvailableFieldNamesSorted() {
        ArrayList<String> fieldNames = new ArrayList<String>(this.getAvailableFieldNames());
        ArrayList<String> result = new ArrayList<String>();
        for (String fieldName : PRE_SORTED_FIELDS_LIST) {
            if (!fieldNames.remove(fieldName)) continue;
            result.add(fieldName);
        }
        Collections.sort(fieldNames);
        for (String fieldName : fieldNames) {
            result.add(fieldName);
        }
        return result;
    }

    static {
        PRE_SORTED_FIELDS_LIST.add(DEVICE_CLASS);
        PRE_SORTED_FIELDS_LIST.add(DEVICE_NAME);
        PRE_SORTED_FIELDS_LIST.add(DEVICE_BRAND);
        PRE_SORTED_FIELDS_LIST.add("DeviceCpu");
        PRE_SORTED_FIELDS_LIST.add("DeviceFirmwareVersion");
        PRE_SORTED_FIELDS_LIST.add("DeviceVersion");
        PRE_SORTED_FIELDS_LIST.add(OPERATING_SYSTEM_CLASS);
        PRE_SORTED_FIELDS_LIST.add(OPERATING_SYSTEM_NAME);
        PRE_SORTED_FIELDS_LIST.add(OPERATING_SYSTEM_VERSION);
        PRE_SORTED_FIELDS_LIST.add("OperatingSystemNameVersion");
        PRE_SORTED_FIELDS_LIST.add("OperatingSystemVersionBuild");
        PRE_SORTED_FIELDS_LIST.add(LAYOUT_ENGINE_CLASS);
        PRE_SORTED_FIELDS_LIST.add(LAYOUT_ENGINE_NAME);
        PRE_SORTED_FIELDS_LIST.add(LAYOUT_ENGINE_VERSION);
        PRE_SORTED_FIELDS_LIST.add(LAYOUT_ENGINE_VERSION_MAJOR);
        PRE_SORTED_FIELDS_LIST.add("LayoutEngineNameVersion");
        PRE_SORTED_FIELDS_LIST.add("LayoutEngineNameVersionMajor");
        PRE_SORTED_FIELDS_LIST.add("LayoutEngineBuild");
        PRE_SORTED_FIELDS_LIST.add(AGENT_CLASS);
        PRE_SORTED_FIELDS_LIST.add(AGENT_NAME);
        PRE_SORTED_FIELDS_LIST.add(AGENT_VERSION);
        PRE_SORTED_FIELDS_LIST.add(AGENT_VERSION_MAJOR);
        PRE_SORTED_FIELDS_LIST.add("AgentNameVersion");
        PRE_SORTED_FIELDS_LIST.add("AgentNameVersionMajor");
        PRE_SORTED_FIELDS_LIST.add("AgentBuild");
        PRE_SORTED_FIELDS_LIST.add("AgentLanguage");
        PRE_SORTED_FIELDS_LIST.add("AgentLanguageCode");
        PRE_SORTED_FIELDS_LIST.add("AgentInformationEmail");
        PRE_SORTED_FIELDS_LIST.add("AgentInformationUrl");
        PRE_SORTED_FIELDS_LIST.add("AgentSecurity");
        PRE_SORTED_FIELDS_LIST.add("AgentUuid");
        PRE_SORTED_FIELDS_LIST.add("FacebookCarrier");
        PRE_SORTED_FIELDS_LIST.add("FacebookDeviceClass");
        PRE_SORTED_FIELDS_LIST.add("FacebookDeviceName");
        PRE_SORTED_FIELDS_LIST.add("FacebookDeviceVersion");
        PRE_SORTED_FIELDS_LIST.add("FacebookFBOP");
        PRE_SORTED_FIELDS_LIST.add("FacebookFBSS");
        PRE_SORTED_FIELDS_LIST.add("FacebookOperatingSystemName");
        PRE_SORTED_FIELDS_LIST.add("FacebookOperatingSystemVersion");
        PRE_SORTED_FIELDS_LIST.add("Anonymized");
        PRE_SORTED_FIELDS_LIST.add("HackerAttackVector");
        PRE_SORTED_FIELDS_LIST.add("HackerToolkit");
        PRE_SORTED_FIELDS_LIST.add("KoboAffiliate");
        PRE_SORTED_FIELDS_LIST.add("KoboPlatformId");
        PRE_SORTED_FIELDS_LIST.add(SYNTAX_ERROR);
    }

    class AgentField {
        String defaultValue;
        String value;
        long confidence;

        AgentField(String defaultValue) {
            this.defaultValue = defaultValue;
            this.reset();
        }

        public void reset() {
            this.value = this.defaultValue;
            this.confidence = -1L;
        }

        public String getValue() {
            return this.value;
        }

        public boolean setValue(AgentField field) {
            return this.setValue(field.value, field.confidence);
        }

        public boolean setValue(String newValue, long newConfidence) {
            if (newConfidence > this.confidence) {
                this.confidence = newConfidence;
                this.value = newValue;
                return true;
            }
            return false;
        }

        public String toString() {
            return ">" + this.value + "#" + this.confidence + "<";
        }
    }
}

