/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.analyze.Analyzer;
import nl.basjes.parse.useragent.analyze.InvalidParserConfigurationException;
import nl.basjes.parse.useragent.analyze.Matcher;
import nl.basjes.parse.useragent.analyze.MatcherAction;
import nl.basjes.parse.useragent.parse.UserAgentTreeFlattener;
import nl.basjes.parse.useragent.utils.VersionSplitter;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.collections4.map.LRUMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.yaml.snakeyaml.Yaml;

public class UserAgentAnalyzer
extends Analyzer {
    private static final int INFORM_ACTIONS_HASHMAP_SIZE = 1000000;
    private static final int PARSE_CACHE_SIZE = 10000;
    private static final Logger LOG = LoggerFactory.getLogger(UserAgentAnalyzer.class);
    private List<Matcher> allMatchers;
    private Map<String, Set<MatcherAction>> informMatcherActions;
    private Map<String, List<Map<String, List<String>>>> matcherConfigs = new HashMap<String, List<Map<String, List<String>>>>(64);
    private boolean doingOnlyASingleTest = false;
    private List<Map<String, Map<String, String>>> testCases = new ArrayList<Map<String, Map<String, String>>>(2048);
    private Map<String, Map<String, String>> lookups = new HashMap<String, Map<String, String>>(128);
    private UserAgentTreeFlattener flattener;
    private Yaml yaml;
    private LRUMap<String, UserAgent> parseCache = new LRUMap(10000);
    private boolean verbose = false;
    private boolean cachingEnabled = true;
    private static final List<String> HARD_CODED_GENERATED_FIELDS = new ArrayList<String>();

    public UserAgentAnalyzer() {
        this("classpath*:UserAgents/**/*.yaml");
    }

    public UserAgentAnalyzer(String resourceString) {
        Resource[] resources;
        LOG.info("Loading from: \"{}\"", (Object)resourceString);
        this.informMatcherActions = new HashMap<String, Set<MatcherAction>>(1000000);
        this.allMatchers = new ArrayList<Matcher>();
        this.flattener = new UserAgentTreeFlattener(this);
        this.yaml = new Yaml();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            resources = resolver.getResources(resourceString);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        this.doingOnlyASingleTest = false;
        int maxFilenameLength = 0;
        for (Resource resource : resources) {
            try {
                maxFilenameLength = Math.max(maxFilenameLength, resource.getFilename().length());
                this.loadResource(resource.getInputStream(), resource.getFilename());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        LOG.info("Loaded {} files", (Object)resources.length);
        if (this.lookups != null && !this.lookups.isEmpty()) {
            HashMap<String, Map<String, String>> cleanedLookups = new HashMap<String, Map<String, String>>(this.lookups.size());
            for (Map.Entry<String, Map<String, String>> lookupsEntry : this.lookups.entrySet()) {
                HashMap cleanedLookup = new HashMap(lookupsEntry.getValue().size());
                for (Map.Entry<String, String> entry : lookupsEntry.getValue().entrySet()) {
                    cleanedLookup.put(entry.getKey().toLowerCase(), entry.getValue());
                }
                cleanedLookups.put(lookupsEntry.getKey(), cleanedLookup);
            }
            this.lookups = cleanedLookups;
        }
        LOG.info("Building all matchers");
        int totalNumberOfMatchers = 0;
        if (this.matcherConfigs != null) {
            long fullStart = System.nanoTime();
            for (Map.Entry<String, List<Map<String, List<String>>>> matcherConfigSet : this.matcherConfigs.entrySet()) {
                long start = System.nanoTime();
                int startSize = this.informMatcherActions.size();
                for (Map<String, List<String>> map : matcherConfigSet.getValue()) {
                    this.allMatchers.add(new Matcher(this, this.lookups, map));
                    ++totalNumberOfMatchers;
                }
                long stop = System.nanoTime();
                int stopSize = this.informMatcherActions.size();
                Formatter msg = new Formatter(Locale.ENGLISH);
                msg.format("Building %4d matchers from %-" + maxFilenameLength + "s took %5d msec resulted in %8d extra hashmap entries", matcherConfigSet.getValue().size(), matcherConfigSet.getKey(), (stop - start) / 1000000L, stopSize - startSize);
                LOG.info(msg.toString());
            }
            long fullStop = System.nanoTime();
            Formatter msg = new Formatter(Locale.ENGLISH);
            msg.format("Building %4d matchers from %4d files took %5d msec resulted in %8d hashmap entries", totalNumberOfMatchers, this.matcherConfigs.size(), (fullStop - fullStart) / 1000000L, this.informMatcherActions.size());
            LOG.info(msg.toString());
        }
        LOG.info("Analyzer stats");
        LOG.info("Lookups      : {}", (Object)(this.lookups == null ? 0 : this.lookups.size()));
        LOG.info("Matchers     : {}", (Object)this.allMatchers.size());
        LOG.info("Hashmap size : {}", (Object)this.informMatcherActions.size());
        LOG.info("Testcases    : {}", (Object)this.testCases.size());
    }

    public Set<String> getAllPossibleFieldNames() {
        TreeSet<String> results = new TreeSet<String>();
        results.addAll(HARD_CODED_GENERATED_FIELDS);
        for (Matcher matcher : this.allMatchers) {
            results.addAll(matcher.getAllPossibleFieldNames());
        }
        return results;
    }

    public List<String> getAllPossibleFieldNamesSorted() {
        ArrayList<String> fieldNames = new ArrayList<String>(this.getAllPossibleFieldNames());
        Collections.sort(fieldNames);
        ArrayList<String> result = new ArrayList<String>();
        for (String fieldName : UserAgent.PRE_SORTED_FIELDS_LIST) {
            fieldNames.remove(fieldName);
            result.add(fieldName);
        }
        for (String fieldName : fieldNames) {
            result.add(fieldName);
        }
        return result;
    }

    private void loadResource(InputStream yamlStream, String filename) {
        Object loadedYaml = this.yaml.load(yamlStream);
        if (loadedYaml == null) {
            return;
        }
        if (!(loadedYaml instanceof Map)) {
            throw new InvalidParserConfigurationException("Yaml config  (" + filename + "): File must be a Map");
        }
        Object rawConfig = ((Map)loadedYaml).get("config");
        if (rawConfig == null) {
            throw new InvalidParserConfigurationException("Yaml config (" + filename + "): Missing 'config' top level entry");
        }
        if (!(rawConfig instanceof List)) {
            throw new InvalidParserConfigurationException("Yaml config (" + filename + "): Top level 'config' must be a Map");
        }
        List configList = (List)rawConfig;
        int entryCount = 0;
        block10: for (Object configEntry : configList) {
            ++entryCount;
            if (!(configEntry instanceof Map)) {
                throw new InvalidParserConfigurationException("Yaml config (" + filename + " [" + entryCount + "]): Entry must be a Map");
            }
            Map entry = (Map)configEntry;
            if (entry.size() != 1) {
                StringBuilder sb = new StringBuilder();
                for (String key : entry.keySet()) {
                    sb.append('\"').append(key).append("\" ");
                }
                throw new InvalidParserConfigurationException("Yaml config (" + filename + " [" + entryCount + "]): Entry has more than one child: " + sb.toString());
            }
            Map.Entry onlyEntry = entry.entrySet().iterator().next();
            String key = (String)onlyEntry.getKey();
            Object value = onlyEntry.getValue();
            switch (key) {
                case "lookup": {
                    if (!(value instanceof Map)) {
                        throw new InvalidParserConfigurationException("Yaml config (" + filename + " [" + entryCount + "]): Entry 'lookup' must be a Map");
                    }
                    Map newLookup = (Map)value;
                    Object rawName = newLookup.get("name");
                    if (rawName == null) {
                        throw new InvalidParserConfigurationException("Yaml config (" + filename + " [" + entryCount + "]): Lookup does not have 'name'");
                    }
                    if (!(rawName instanceof String)) {
                        throw new InvalidParserConfigurationException("Yaml config (" + filename + " [" + entryCount + "]): Lookup 'name' must be a String");
                    }
                    Object rawMap = newLookup.get("map");
                    if (rawMap == null) {
                        throw new InvalidParserConfigurationException("Yaml config (" + filename + " [" + entryCount + "]): Lookup does not have 'map'");
                    }
                    if (!(rawMap instanceof Map)) {
                        throw new InvalidParserConfigurationException("Yaml config (" + filename + " [" + entryCount + "]): Lookup 'map' must be a Map");
                    }
                    Map map = (Map)rawMap;
                    this.lookups.put((String)rawName, map);
                    continue block10;
                }
                case "matcher": {
                    if (!(value instanceof Map)) {
                        throw new InvalidParserConfigurationException("Yaml config (" + filename + "): Entry 'matcher' must be a Map");
                    }
                    Map matcherConfig = (Map)value;
                    List<Map<String, List<String>>> matcherConfigList = this.matcherConfigs.get(filename);
                    if (matcherConfigList == null) {
                        matcherConfigList = new ArrayList<Map<String, List<String>>>(32);
                        this.matcherConfigs.put(filename, matcherConfigList);
                    }
                    matcherConfigList.add(matcherConfig);
                    continue block10;
                }
                case "test": {
                    if (this.doingOnlyASingleTest) continue block10;
                    if (!(value instanceof Map)) {
                        throw new InvalidParserConfigurationException("Yaml config (" + filename + "): Entry 'testcase' must be a Map");
                    }
                    Map testCase = (Map)value;
                    HashMap<String, String> metaData = (HashMap<String, String>)testCase.get("metaData");
                    if (metaData == null) {
                        metaData = new HashMap<String, String>();
                        testCase.put("metaData", metaData);
                    }
                    metaData.put("filename", filename);
                    metaData.put("fileentry", String.valueOf(entryCount));
                    List options = (List)testCase.get("options");
                    if (options != null && options.contains("only")) {
                        this.doingOnlyASingleTest = true;
                        this.testCases.clear();
                    }
                    this.testCases.add(testCase);
                    continue block10;
                }
            }
            throw new InvalidParserConfigurationException("Yaml config (" + filename + "): Found unexpected config entry: " + key + ", allowed are 'lookup, 'matcher' and 'test'");
        }
    }

    @Override
    public void informMeAbout(MatcherAction matcherAction, String keyPattern) {
        String hashKey = keyPattern.toLowerCase();
        Set<MatcherAction> analyzerSet = this.informMatcherActions.get(hashKey);
        if (analyzerSet == null) {
            analyzerSet = new HashSet<MatcherAction>();
            this.informMatcherActions.put(hashKey, analyzerSet);
        }
        analyzerSet.add(matcherAction);
    }

    public void setVerbose(boolean newVerbose) {
        this.verbose = newVerbose;
        this.flattener.setVerbose(newVerbose);
    }

    public UserAgent parse(String userAgentString) {
        UserAgent userAgent = new UserAgent(userAgentString);
        return this.cachedParse(userAgent);
    }

    public UserAgent parse(UserAgent userAgent) {
        userAgent.reset();
        return this.cachedParse(userAgent);
    }

    public void disableCaching() {
        this.cachingEnabled = false;
    }

    private UserAgent cachedParse(UserAgent userAgent) {
        if (!this.cachingEnabled) {
            return this.nonCachedParse(userAgent);
        }
        String userAgentString = userAgent.getUserAgentString();
        UserAgent cachedValue = (UserAgent)this.parseCache.get((Object)userAgentString);
        if (cachedValue != null) {
            userAgent.clone(cachedValue);
        } else {
            cachedValue = new UserAgent(this.nonCachedParse(userAgent));
            this.parseCache.put((Object)userAgentString, (Object)cachedValue);
        }
        return userAgent;
    }

    private UserAgent nonCachedParse(UserAgent userAgent) {
        boolean setVerboseTemporarily = userAgent.isDebug();
        for (Matcher matcher : this.allMatchers) {
            matcher.reset(setVerboseTemporarily);
        }
        this.flattener.parse(userAgent);
        for (Matcher matcher : this.allMatchers) {
            matcher.analyze(userAgent);
        }
        return this.hardCodedPostProcessing(userAgent);
    }

    private UserAgent hardCodedPostProcessing(UserAgent userAgent) {
        if ("true".equals(userAgent.getValue("__SyntaxError__")) && userAgent.get((String)"DeviceClass").confidence == -1L && userAgent.get((String)"OperatingSystemClass").confidence == -1L && userAgent.get((String)"LayoutEngineClass").confidence == -1L) {
            userAgent.set("DeviceClass", "Hacker", 10L);
            userAgent.set("DeviceBrand", "Hacker", 10L);
            userAgent.set("DeviceName", "Hacker", 10L);
            userAgent.set("OperatingSystemClass", "Hacker", 10L);
            userAgent.set("OperatingSystemName", "Hacker", 10L);
            userAgent.set("OperatingSystemVersion", "Hacker", 10L);
            userAgent.set("LayoutEngineClass", "Hacker", 10L);
            userAgent.set("LayoutEngineName", "Hacker", 10L);
            userAgent.set("LayoutEngineVersion", "Hacker", 10L);
            userAgent.set("LayoutEngineVersionMajor", "Hacker", 10L);
            userAgent.set("AgentClass", "Hacker", 10L);
            userAgent.set("AgentName", "Hacker", 10L);
            userAgent.set("AgentVersion", "Hacker", 10L);
            userAgent.set("AgentVersionMajor", "Hacker", 10L);
            userAgent.set("HackerToolkit", "Unknown", 10L);
            userAgent.set("HackerAttackVector", "Unknown", 10L);
        }
        this.addMajorVersionField(userAgent, "AgentVersion", "AgentVersionMajor");
        this.addMajorVersionField(userAgent, "LayoutEngineVersion", "LayoutEngineVersionMajor");
        this.concatFieldValuesNONDuplicated(userAgent, "AgentNameVersion", "AgentName", "AgentVersion");
        this.concatFieldValuesNONDuplicated(userAgent, "AgentNameVersionMajor", "AgentName", "AgentVersionMajor");
        this.concatFieldValuesNONDuplicated(userAgent, "LayoutEngineNameVersion", "LayoutEngineName", "LayoutEngineVersion");
        this.concatFieldValuesNONDuplicated(userAgent, "LayoutEngineNameVersionMajor", "LayoutEngineName", "LayoutEngineVersionMajor");
        this.concatFieldValuesNONDuplicated(userAgent, "OperatingSystemNameVersion", "OperatingSystemName", "OperatingSystemVersion");
        return userAgent;
    }

    private void concatFieldValuesNONDuplicated(UserAgent userAgent, String targetName, String firstName, String secondName) {
        UserAgent.AgentField firstField = userAgent.get(firstName);
        UserAgent.AgentField secondField = userAgent.get(secondName);
        if (firstField.confidence < 0L || secondField.confidence < 0L) {
            if (firstField.confidence >= 0L) {
                userAgent.set(targetName, firstField.getValue(), firstField.confidence);
                return;
            }
            if (secondField.confidence >= 0L) {
                userAgent.set(targetName, secondField.getValue(), secondField.confidence);
                return;
            }
            return;
        }
        String first = userAgent.getValue(firstName);
        String second = userAgent.getValue(secondName);
        if (firstField.getValue().equals(second)) {
            userAgent.set(targetName, first, firstField.confidence);
        } else {
            userAgent.set(targetName, first + " " + second, Math.max(firstField.confidence, secondField.confidence));
        }
    }

    private void addMajorVersionField(UserAgent userAgent, String versionName, String majorVersionName) {
        UserAgent.AgentField agentVersionMajor = userAgent.get(majorVersionName);
        if (agentVersionMajor == null || agentVersionMajor.confidence == -1L) {
            UserAgent.AgentField agentVersion = userAgent.get(versionName);
            userAgent.set(majorVersionName, VersionSplitter.getSingleVersion(agentVersion.getValue(), 1), agentVersion.confidence);
        }
    }

    @Override
    public void inform(String key, String value, ParseTree ctx) {
        this.inform(key, key, value, ctx);
        this.inform(key + "=\"" + value + '\"', key, value, ctx);
    }

    private void inform(String match, String key, String value, ParseTree ctx) {
        Set<MatcherAction> relevantActions = this.informMatcherActions.get(match.toLowerCase());
        if (this.verbose) {
            if (relevantActions == null) {
                LOG.info("--- Have (0): {}", (Object)match);
            } else {
                LOG.info("+++ Have ({}): {}", (Object)relevantActions.size(), (Object)match);
                int count = 1;
                for (MatcherAction action : relevantActions) {
                    LOG.info("+++ -------> ({}): {}", (Object)count, (Object)action.toString());
                    ++count;
                }
            }
        }
        if (relevantActions != null) {
            for (MatcherAction matcherAction : relevantActions) {
                matcherAction.inform(key, value, ctx);
            }
        }
    }

    public List<MatcherAction.Match> getMatches() {
        ArrayList<MatcherAction.Match> allMatches = new ArrayList<MatcherAction.Match>(128);
        for (Matcher matcher : this.allMatchers) {
            allMatches.addAll(matcher.getMatches());
        }
        return allMatches;
    }

    public List<MatcherAction.Match> getUsedMatches(UserAgent userAgent) {
        for (Matcher matcher : this.allMatchers) {
            matcher.reset(false);
        }
        this.flattener.parse(userAgent);
        ArrayList<MatcherAction.Match> allMatches = new ArrayList<MatcherAction.Match>(128);
        for (Matcher matcher : this.allMatchers) {
            allMatches.addAll(matcher.getUsedMatches());
        }
        return allMatches;
    }

    public static List<String> getAllPaths(String agent) {
        return new GetAllPathsAnalyzer(agent).getValues();
    }

    public static GetAllPathsAnalyzer getAllPathsAnalyzer(String agent) {
        return new GetAllPathsAnalyzer(agent);
    }

    public boolean runTests() {
        return this.runTests(false, true);
    }

    public boolean runTests(boolean showAll, boolean failOnUnexpected) {
        return this.runTests(showAll, failOnUnexpected, false);
    }

    public boolean runTests(boolean showAll, boolean failOnUnexpected, boolean measureSpeed) {
        int filenameHeaderLength;
        boolean allPass = true;
        if (this.testCases == null) {
            return allPass;
        }
        UserAgent agent = new UserAgent();
        ArrayList<TestResult> results = new ArrayList<TestResult>(32);
        String filenameHeader = "Name of the testfile";
        int maxFilenameLength = filenameHeaderLength = filenameHeader.length();
        for (Map<String, Map<String, String>> test : this.testCases) {
            Map<String, String> metaData = test.get("metaData");
            String filename = metaData.get("filename");
            maxFilenameLength = Math.max(maxFilenameLength, filename.length());
        }
        ++maxFilenameLength;
        LOG.info("+===========================================================================================");
        StringBuilder sb = new StringBuilder(1024);
        sb.append("| ").append(filenameHeader);
        for (int i = filenameHeaderLength; i < maxFilenameLength; ++i) {
            sb.append(' ');
        }
        sb.append("|S|AA|  PPS| --> S=Syntax Error, AA=Number of ambiguities during parse, PPS=parses/sec");
        LOG.info(sb.toString());
        LOG.info("+-------------------------------------------------------------------------------------------");
        for (Map<String, Map<String, String>> test : this.testCases) {
            int i;
            int i2;
            Map<String, String> input = test.get("input");
            Map<String, String> expected = test.get("expected");
            List options = (List)((Object)test.get("options"));
            Map<String, String> metaData = test.get("metaData");
            String filename = metaData.get("filename");
            boolean init = false;
            if (options == null) {
                this.setVerbose(false);
                agent.setDebug(false);
            } else {
                boolean newVerbose = options.contains("verbose");
                this.setVerbose(newVerbose);
                agent.setDebug(newVerbose);
                init = options.contains("init");
            }
            if (expected == null || expected.size() == 0) {
                init = true;
            }
            String testName = input.get("name");
            String userAgentString = input.get("user_agent_string");
            if (testName == null) {
                testName = userAgentString;
            }
            sb.setLength(0);
            sb.append("| ").append(filename);
            for (int i3 = filename.length(); i3 < maxFilenameLength; ++i3) {
                sb.append(' ');
            }
            agent.setUserAgentString(userAgentString);
            long measuredSpeed = -1L;
            if (measureSpeed) {
                this.disableCaching();
                for (int i4 = 0; i4 < 100; ++i4) {
                    agent = this.parse(agent);
                }
                long startTime = System.nanoTime();
                for (int i5 = 0; i5 < 1000; ++i5) {
                    agent = this.parse(agent);
                }
                long stopTime = System.nanoTime();
                measuredSpeed = 1000000000000L / (stopTime - startTime);
            } else {
                agent = this.parse(agent);
            }
            sb.append('|');
            if (agent.hasSyntaxError()) {
                sb.append('S');
            } else {
                sb.append(' ');
            }
            if (agent.hasAmbiguity()) {
                sb.append(String.format("|%2d", agent.getAmbiguityCount()));
            } else {
                sb.append("|  ");
            }
            if (measureSpeed) {
                sb.append('|').append(String.format("%5d", measuredSpeed));
            } else {
                sb.append("|  ~  ");
            }
            sb.append("| ").append(testName);
            LOG.info(sb.toString());
            sb.setLength(0);
            boolean pass = true;
            results.clear();
            if (init) {
                sb.append(agent.toYamlTestCase());
                LOG.info(sb.toString());
            } else if (expected == null) {
                LOG.info("| - No expectations ... ");
                continue;
            }
            int maxNameLength = 6;
            int maxActualLength = 7;
            int maxExpectedLength = 9;
            if (expected != null) {
                List<String> fieldNames = agent.getAvailableFieldNamesSorted();
                Iterator<String> iterator = fieldNames.iterator();
                while (iterator.hasNext()) {
                    boolean expectedSomething;
                    String fieldName = iterator.next();
                    TestResult result = new TestResult();
                    result.field = fieldName;
                    String expectedValue = expected.get(fieldName);
                    if (expectedValue == null) {
                        expectedSomething = false;
                        result.expected = "<<absent>>";
                    } else {
                        expectedSomething = true;
                        result.expected = expectedValue;
                    }
                    UserAgent.AgentField agentField = agent.get(result.field);
                    if (agentField != null) {
                        result.actual = agentField.value;
                        result.confidence = agentField.confidence;
                    }
                    if (result.actual == null) {
                        result.actual = "<<<null>>>";
                    }
                    result.pass = result.actual.equals(result.expected);
                    if (!result.pass) {
                        result.warn = true;
                        if (expectedSomething) {
                            result.warn = false;
                            pass = false;
                            allPass = false;
                        } else if (failOnUnexpected) {
                            result.warn = false;
                            pass = false;
                            allPass = false;
                        }
                    }
                    results.add(result);
                    maxNameLength = Math.max(maxNameLength, result.field.length());
                    maxActualLength = Math.max(maxActualLength, result.actual.length());
                    maxExpectedLength = Math.max(maxExpectedLength, result.expected.length());
                }
            }
            if (!init && pass && !showAll) continue;
            if (!pass) {
                LOG.error("| TEST FAILED !");
            }
            if (agent.hasAmbiguity()) {
                LOG.info("| Parsing problem: Ambiguity {} times. ", (Object)agent.getAmbiguityCount());
            }
            if (agent.hasSyntaxError()) {
                LOG.info("| Parsing problem: Syntax Error");
            }
            if (init || !pass) {
                sb.setLength(0);
                sb.append("\n");
                sb.append("\n");
                sb.append("  - matcher:\n");
                sb.append("#      options:\n");
                sb.append("#        - 'verbose'\n");
                sb.append("      require:\n");
                for (String path : UserAgentAnalyzer.getAllPathsAnalyzer(userAgentString).getValues()) {
                    if (!path.contains("=\"")) continue;
                    sb.append("#        - '").append(path).append("'\n");
                }
                sb.append("      extract:\n");
                sb.append("#        - 'DeviceClass           :   1:' # Hacker / Cloud / Server / Desktop / Tablet / Phone / Watch \n");
                sb.append("#        - 'DeviceBrand           :   1:' # (Google/AWS/Asure) / Samsung / Apple / ... \n");
                sb.append("#        - 'DeviceName            :   1:' # (Google/AWS/Asure) / Samsung Galaxy SII / ... \n");
                sb.append("#        - 'OperatingSystemClass  :   1:' # Cloud, Desktop, Mobile, Embedded \n");
                sb.append("#        - 'OperatingSystemName   :   1:' # ( Linux / Android / Windows ...) \n");
                sb.append("#        - 'OperatingSystemVersion:   1:' # 1.2 / 43 / ...\n");
                sb.append("#        - 'LayoutEngineClass     :   1:' # None / Hacker / Robot / Browser / ... \n");
                sb.append("#        - 'LayoutEngineName      :   1:' # ( GoogleBot / Bing / Yahoo / ...) / (Trident /Gecko / Webkit / ...)\n");
                sb.append("#        - 'LayoutEngineVersion   :   1:' # 7.0 / 1.2 / ... \n");
                sb.append("#        - 'AgentClass            :   1:' # Hacker / Robot / Browser / ... \n");
                sb.append("#        - 'AgentName             :   1:' # ( GoogleBot / Bing / Yahoo / ...) / ( Firefox / Chrome / ... ) \n");
                sb.append("#        - 'AgentVersion          :   1:' # 4.0 / 43.1.2.3 / ...\n");
                sb.append("\n");
                sb.append("\n");
                LOG.info(sb.toString());
            }
            sb.setLength(0);
            sb.append("+--------+-");
            for (i2 = 0; i2 < maxNameLength; ++i2) {
                sb.append('-');
            }
            sb.append("-+-");
            for (i2 = 0; i2 < maxActualLength; ++i2) {
                sb.append('-');
            }
            sb.append("-+------------+-");
            for (i2 = 0; i2 < maxExpectedLength; ++i2) {
                sb.append('-');
            }
            sb.append("-+");
            String separator = sb.toString();
            LOG.info(separator);
            sb.setLength(0);
            sb.append("| Result | Field ");
            for (i = 6; i < maxNameLength; ++i) {
                sb.append(' ');
            }
            sb.append(" | Actual ");
            for (i = 7; i < maxActualLength; ++i) {
                sb.append(' ');
            }
            sb.append(" | Confidence | Expected ");
            for (i = 9; i < maxExpectedLength; ++i) {
                sb.append(' ');
            }
            sb.append(" |");
            LOG.info(sb.toString());
            LOG.info(separator);
            for (TestResult result : results) {
                int i6;
                sb.setLength(0);
                if (result.pass) {
                    sb.append("|        | ");
                } else if (result.warn) {
                    sb.append("| ~warn~ | ");
                } else {
                    sb.append("| -FAIL- | ");
                }
                sb.append(result.field);
                for (i6 = result.field.length(); i6 < maxNameLength; ++i6) {
                    sb.append(' ');
                }
                sb.append(" | ");
                sb.append(result.actual);
                for (i6 = result.actual.length(); i6 < maxActualLength; ++i6) {
                    sb.append(' ');
                }
                sb.append(" | ");
                sb.append(String.format("%10d", result.confidence));
                sb.append(" | ");
                if (result.pass) {
                    for (i6 = 0; i6 < maxExpectedLength; ++i6) {
                        sb.append(' ');
                    }
                    sb.append(" |");
                    LOG.info(sb.toString());
                    continue;
                }
                sb.append(result.expected);
                for (i6 = result.expected.length(); i6 < maxExpectedLength; ++i6) {
                    sb.append(' ');
                }
                sb.append(" |");
                if (result.warn) {
                    LOG.warn(sb.toString());
                    continue;
                }
                LOG.error(sb.toString());
            }
            LOG.info(separator);
            LOG.info("");
            LOG.info("\n\ntests:\n" + agent.toYamlTestCase());
            if (!pass && !showAll) {
                return false;
            }
            if (!init) continue;
            return allPass;
        }
        LOG.info("+===========================================================================================");
        return allPass;
    }

    static {
        HARD_CODED_GENERATED_FIELDS.add("__SyntaxError__");
        HARD_CODED_GENERATED_FIELDS.add("AgentVersionMajor");
        HARD_CODED_GENERATED_FIELDS.add("LayoutEngineVersionMajor");
        HARD_CODED_GENERATED_FIELDS.add("AgentNameVersion");
        HARD_CODED_GENERATED_FIELDS.add("AgentNameVersionMajor");
        HARD_CODED_GENERATED_FIELDS.add("LayoutEngineNameVersion");
        HARD_CODED_GENERATED_FIELDS.add("LayoutEngineNameVersionMajor");
        HARD_CODED_GENERATED_FIELDS.add("OperatingSystemNameVersion");
    }

    class TestResult {
        String field;
        String expected;
        String actual;
        boolean pass;
        boolean warn;
        long confidence;

        TestResult() {
        }
    }

    static class GetAllPathsAnalyzer
    extends Analyzer {
        List<String> values = new ArrayList<String>(128);
        UserAgentTreeFlattener flattener = new UserAgentTreeFlattener(this);
        private UserAgent result;

        GetAllPathsAnalyzer(String useragent) {
            this.result = this.flattener.parse(useragent);
        }

        public List<String> getValues() {
            return this.values;
        }

        public UserAgent getResult() {
            return this.result;
        }

        @Override
        public void inform(String path, String value, ParseTree ctx) {
            this.values.add(path);
            this.values.add(path + "=\"" + value + "\"");
        }

        @Override
        public void informMeAbout(MatcherAction matcherAction, String keyPattern) {
        }
    }
}

