/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.analyze;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.analyze.Analyzer;
import nl.basjes.parse.useragent.analyze.InvalidParserConfigurationException;
import nl.basjes.parse.useragent.analyze.MatcherAction;
import nl.basjes.parse.useragent.analyze.MatcherExtractAction;
import nl.basjes.parse.useragent.analyze.MatcherRequireAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Matcher {
    private static final Logger LOG = LoggerFactory.getLogger(Matcher.class);
    private Analyzer analyzer;
    private List<MatcherAction> dynamicActions;
    private List<MatcherAction> fixedStringActions;
    Map<String, Map<String, String>> lookups;
    private boolean verbose;
    private UserAgent newValuesUserAgent = new UserAgent("dummy");
    boolean possiblyValid = false;

    Matcher(Analyzer analyzer, Map<String, Map<String, String>> lookups) {
        this.lookups = lookups;
        this.analyzer = analyzer;
        this.fixedStringActions = new ArrayList<MatcherAction>();
        this.dynamicActions = new ArrayList<MatcherAction>();
    }

    public Matcher(Analyzer analyzer, Map<String, Map<String, String>> lookups, Map<String, List<String>> matcherConfig) {
        List<String> extractConfigs;
        List<String> requireConfigs;
        this.lookups = lookups;
        this.analyzer = analyzer;
        this.fixedStringActions = new ArrayList<MatcherAction>();
        this.dynamicActions = new ArrayList<MatcherAction>();
        if (matcherConfig == null) {
            throw new InvalidParserConfigurationException("Got a 'null' config setting");
        }
        this.verbose = false;
        List<String> options = matcherConfig.get("options");
        if (options != null) {
            this.verbose = options.contains("verbose");
        }
        if (this.verbose) {
            LOG.info("---------------------------");
            LOG.info("- MATCHER -");
        }
        if ((requireConfigs = matcherConfig.get("require")) != null) {
            for (String requireConfig : requireConfigs) {
                if (this.verbose) {
                    LOG.info("REQUIRE: {}", (Object)requireConfig);
                }
                this.dynamicActions.add(new MatcherRequireAction(requireConfig, this));
            }
        }
        if ((extractConfigs = matcherConfig.get("extract")) != null) {
            for (String extractConfig : extractConfigs) {
                if (this.verbose) {
                    LOG.info("EXTRACT: {}", (Object)extractConfig);
                }
                String[] configParts = extractConfig.split(":", 3);
                String attribute = configParts[0].trim();
                String confidence = configParts[1].trim();
                String config = configParts[2].trim();
                MatcherExtractAction action = new MatcherExtractAction(attribute, Long.parseLong(confidence), config, this);
                if (action.isFixedValue()) {
                    this.fixedStringActions.add(action);
                    continue;
                }
                this.dynamicActions.add(action);
            }
        }
        if (this.verbose) {
            LOG.info("---------------------------");
        }
    }

    public Set<String> getAllPossibleFieldNames() {
        TreeSet<String> results = new TreeSet<String>();
        results.addAll(this.getAllPossibleFieldNames(this.dynamicActions));
        results.addAll(this.getAllPossibleFieldNames(this.fixedStringActions));
        return results;
    }

    private Set<String> getAllPossibleFieldNames(List<MatcherAction> actions) {
        TreeSet<String> results = new TreeSet<String>();
        for (MatcherAction action : actions) {
            if (!(action instanceof MatcherExtractAction)) continue;
            MatcherExtractAction extractAction = (MatcherExtractAction)action;
            results.add(extractAction.getAttribute());
        }
        return results;
    }

    public void informMeAbout(MatcherAction matcherAction, String keyPattern) {
        if (this.verbose) {
            LOG.info("Requested: {}", (Object)keyPattern);
        }
        this.analyzer.informMeAbout(matcherAction, keyPattern);
    }

    public void analyze(UserAgent userAgent) {
        this.newValuesUserAgent.reset();
        if (this.verbose) {
            LOG.info("");
            LOG.info("--- Matcher ------------------------");
            LOG.info("ANALYSE ----------------------------");
            boolean good = true;
            for (MatcherAction action : this.dynamicActions) {
                if (action.canPossiblyBeValid()) continue;
                LOG.error("CANNOT BE VALID : {}", (Object)action.getMatchExpression());
            }
            for (MatcherAction action : this.dynamicActions) {
                if (action.obtainResult(this.newValuesUserAgent)) continue;
                LOG.error("FAILED : {}", (Object)action.getMatchExpression());
                good = false;
            }
            if (good) {
                for (MatcherAction action : this.fixedStringActions) {
                    if (action.obtainResult(this.newValuesUserAgent)) continue;
                    LOG.error("FAILED : {}", (Object)action.getMatchExpression());
                }
            } else {
                LOG.info("INCOMPLETE ----------------------------");
                return;
            }
            LOG.info("COMPLETE ----------------------------");
        } else {
            for (MatcherAction action : this.dynamicActions) {
                if (action.canPossiblyBeValid()) continue;
                return;
            }
            for (MatcherAction action : this.dynamicActions) {
                if (action.obtainResult(this.newValuesUserAgent)) continue;
                return;
            }
            for (MatcherAction action : this.fixedStringActions) {
                if (action.obtainResult(this.newValuesUserAgent)) continue;
                return;
            }
        }
        userAgent.set(this.newValuesUserAgent);
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void gotAStartingPoint() {
        this.possiblyValid = true;
    }

    public void reset(boolean setVerboseTemporarily) {
        this.possiblyValid = false;
        for (MatcherAction action : this.dynamicActions) {
            action.reset();
            if (setVerboseTemporarily) {
                this.verbose = true;
                action.setVerbose(true, true);
                continue;
            }
            this.verbose = false;
        }
    }

    public List<MatcherAction.Match> getMatches() {
        ArrayList<MatcherAction.Match> allMatches = new ArrayList<MatcherAction.Match>(128);
        for (MatcherAction action : this.dynamicActions) {
            allMatches.addAll(action.getMatches());
        }
        return allMatches;
    }

    public List<MatcherAction.Match> getUsedMatches() {
        ArrayList<MatcherAction.Match> allMatches = new ArrayList<MatcherAction.Match>(128);
        if (this.dynamicActions.size() > 0 && !this.possiblyValid) {
            return new ArrayList<MatcherAction.Match>();
        }
        for (MatcherAction action : this.dynamicActions) {
            if (action.canPossiblyBeValid()) continue;
            return new ArrayList<MatcherAction.Match>();
        }
        for (MatcherAction action : this.dynamicActions) {
            if (!action.obtainResult(this.newValuesUserAgent)) {
                return new ArrayList<MatcherAction.Match>();
            }
            allMatches.addAll(action.getMatches());
        }
        return allMatches;
    }
}

