/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.analyze.treewalker.steps.compare;

import nl.basjes.parse.useragent.analyze.treewalker.steps.Step;
import org.antlr.v4.runtime.tree.ParseTree;

public class StepEquals
extends Step {
    private String desiredValue;

    public StepEquals(String desiredValue) {
        this.desiredValue = desiredValue.toLowerCase();
    }

    @Override
    public String walk(ParseTree tree, String value) {
        String actualValue = this.getActualValue(tree, value);
        if (actualValue.toLowerCase().equals(this.desiredValue)) {
            if (this.verbose) {
                LOG.info("{} Equals: {} == {} --> TRUE", new Object[]{this.logprefix, actualValue, this.desiredValue});
            }
            return this.walkNextStep(tree, null);
        }
        if (this.verbose) {
            LOG.info("{} Equals: {} == {} --> FALSE", new Object[]{this.logprefix, actualValue, this.desiredValue});
        }
        return null;
    }

    public String toString() {
        return "Equals(" + this.desiredValue + ")";
    }
}

