/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.analyze.treewalker.steps.walk;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nl.basjes.parse.useragent.UserAgentBaseVisitor;
import nl.basjes.parse.useragent.UserAgentParser;
import nl.basjes.parse.useragent.UserAgentTreeWalkerParser;
import nl.basjes.parse.useragent.analyze.InvalidParserConfigurationException;
import nl.basjes.parse.useragent.analyze.NumberRangeList;
import nl.basjes.parse.useragent.analyze.NumberRangeVisitor;
import nl.basjes.parse.useragent.analyze.treewalker.steps.Step;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

public class StepDown
extends Step {
    private int start;
    private int end;
    private String name;
    private UserAgentGetChildrenVisitor userAgentGetChildrenVisitor = new UserAgentGetChildrenVisitor();

    public StepDown(UserAgentTreeWalkerParser.NumberRangeContext numberRange, String name) {
        this(NumberRangeVisitor.getList(numberRange), name);
    }

    private StepDown(NumberRangeList numberRange, String name) {
        this.name = name;
        this.start = numberRange.getStart();
        this.end = numberRange.getEnd();
    }

    public String toString() {
        return "Down([" + this.start + ":" + this.end + "]" + this.name + ")";
    }

    @Override
    public String walk(ParseTree tree, String value) {
        List children = (List)this.userAgentGetChildrenVisitor.visit(tree);
        if (children != null) {
            for (ParserRuleContext child : children) {
                String childResult = this.walkNextStep((ParseTree)child, null);
                if (childResult == null) continue;
                return childResult;
            }
        }
        return null;
    }

    @SafeVarargs
    private final List<ParserRuleContext> getChildren(ParseTree tree, Class<? extends ParserRuleContext> ... childClasses) {
        return this.getChildren(tree, false, childClasses);
    }

    @SafeVarargs
    private final List<ParserRuleContext> getChildren(ParseTree tree, boolean privateNumberRange, Class<? extends ParserRuleContext> ... childClasses) {
        if (!(tree instanceof ParserRuleContext)) {
            return Collections.emptyList();
        }
        if (childClasses.length == 0) {
            throw new InvalidParserConfigurationException("WTF");
        }
        ParserRuleContext treeContext = (ParserRuleContext)tree;
        if (treeContext.children == null) {
            return Collections.emptyList();
        }
        ArrayList contexts = null;
        int index = 0;
        for (ParseTree child : treeContext.children) {
            if (!ParserRuleContext.class.isInstance(child) || this.treeIsSeparator(child)) continue;
            if (contexts == null) {
                contexts = new ArrayList();
            }
            boolean matchesClass = false;
            for (Class<? extends ParserRuleContext> childClass : childClasses) {
                if (!childClass.isInstance(child)) continue;
                matchesClass = true;
                break;
            }
            if (!privateNumberRange) {
                ++index;
            }
            if (!matchesClass) continue;
            if (privateNumberRange) {
                ++index;
            }
            if (this.start > index || index > this.end) continue;
            contexts.add(ParserRuleContext.class.cast(child));
        }
        if (contexts == null) {
            return Collections.emptyList();
        }
        return contexts;
    }

    private class UserAgentGetChildrenVisitor
    extends UserAgentBaseVisitor<List<? extends ParserRuleContext>> {
        private UserAgentGetChildrenVisitor() {
        }

        @Override
        public List<? extends ParserRuleContext> visitUserAgent(UserAgentParser.UserAgentContext ctx) {
            switch (StepDown.this.name) {
                case "product": {
                    return StepDown.this.getChildren((ParseTree)ctx, new Class[]{UserAgentParser.ProductContext.class});
                }
                case "url": {
                    return StepDown.this.getChildren((ParseTree)ctx, new Class[]{UserAgentParser.SiteUrlContext.class});
                }
                case "email": {
                    return StepDown.this.getChildren((ParseTree)ctx, new Class[]{UserAgentParser.EmailAddressContext.class});
                }
                case "text": {
                    return StepDown.this.getChildren((ParseTree)ctx, new Class[]{UserAgentParser.RootTextPartContext.class});
                }
            }
            return Collections.emptyList();
        }

        private List<? extends ParserRuleContext> visitGenericProduct(ParserRuleContext ctx) {
            switch (StepDown.this.name) {
                case "name": {
                    return StepDown.this.getChildren((ParseTree)ctx, false, new Class[]{UserAgentParser.ProductNameContext.class, UserAgentParser.ProductNameNoVersionContext.class});
                }
                case "version": {
                    return StepDown.this.getChildren((ParseTree)ctx, true, new Class[]{UserAgentParser.ProductVersionContext.class, UserAgentParser.ProductVersionWithCommasContext.class, UserAgentParser.ProductVersionWordsContext.class, UserAgentParser.ProductVersionSingleWordContext.class});
                }
                case "comments": {
                    return StepDown.this.getChildren((ParseTree)ctx, true, new Class[]{UserAgentParser.CommentBlockContext.class});
                }
            }
            return Collections.emptyList();
        }

        @Override
        public List<? extends ParserRuleContext> visitProduct(UserAgentParser.ProductContext ctx) {
            return this.visitGenericProduct(ctx);
        }

        @Override
        public List<? extends ParserRuleContext> visitCommentProduct(UserAgentParser.CommentProductContext ctx) {
            return this.visitGenericProduct(ctx);
        }

        @Override
        public List<? extends ParserRuleContext> visitProductName(UserAgentParser.ProductNameContext ctx) {
            return Collections.emptyList();
        }

        @Override
        public List<? extends ParserRuleContext> visitProductNameNoVersion(UserAgentParser.ProductNameNoVersionContext ctx) {
            return Collections.emptyList();
        }

        @Override
        public List<? extends ParserRuleContext> visitProductNameWords(UserAgentParser.ProductNameWordsContext ctx) {
            return Collections.emptyList();
        }

        @Override
        public List<? extends ParserRuleContext> visitProductNameVersion(UserAgentParser.ProductNameVersionContext ctx) {
            return Collections.emptyList();
        }

        @Override
        public List<? extends ParserRuleContext> visitProductVersionWords(UserAgentParser.ProductVersionWordsContext ctx) {
            return Collections.emptyList();
        }

        @Override
        public List<? extends ParserRuleContext> visitProductVersionSingleWord(UserAgentParser.ProductVersionSingleWordContext ctx) {
            return Collections.emptyList();
        }

        @Override
        public List<? extends ParserRuleContext> visitProductNameKeyValue(UserAgentParser.ProductNameKeyValueContext ctx) {
            switch (StepDown.this.name) {
                case "key": {
                    return Collections.singletonList(ctx.key);
                }
                case "value": {
                    List<ParserRuleContext> children = ctx.multipleWords();
                    if (children.isEmpty() && (children = ctx.keyValueProductVersionName()).isEmpty() && (children = ctx.siteUrl()).isEmpty() && (children = ctx.emailAddress()).isEmpty()) {
                        children = ctx.uuId();
                    }
                    return children;
                }
                case "comments": {
                    return StepDown.this.getChildren((ParseTree)ctx, true, new Class[]{UserAgentParser.CommentBlockContext.class});
                }
            }
            return Collections.emptyList();
        }

        @Override
        public List<? extends ParserRuleContext> visitProductNameEmail(UserAgentParser.ProductNameEmailContext ctx) {
            return Collections.emptyList();
        }

        @Override
        public List<? extends ParserRuleContext> visitProductNameUrl(UserAgentParser.ProductNameUrlContext ctx) {
            return Collections.emptyList();
        }

        @Override
        public List<? extends ParserRuleContext> visitProductNameUuid(UserAgentParser.ProductNameUuidContext ctx) {
            return Collections.emptyList();
        }

        @Override
        public List<? extends ParserRuleContext> visitProductVersion(UserAgentParser.ProductVersionContext ctx) {
            return (List)this.visit((ParseTree)ctx);
        }

        @Override
        public List<? extends ParserRuleContext> visitProductVersionWithCommas(UserAgentParser.ProductVersionWithCommasContext ctx) {
            return (List)this.visit((ParseTree)ctx);
        }

        @Override
        public List<? extends ParserRuleContext> visitKeyName(UserAgentParser.KeyNameContext ctx) {
            return Collections.emptyList();
        }

        @Override
        public List<? extends ParserRuleContext> visitKeyValueVersionName(UserAgentParser.KeyValueVersionNameContext ctx) {
            return Collections.emptyList();
        }

        @Override
        public List<? extends ParserRuleContext> visitKeyValue(UserAgentParser.KeyValueContext ctx) {
            switch (StepDown.this.name) {
                case "key": {
                    return StepDown.this.getChildren((ParseTree)ctx, new Class[]{UserAgentParser.KeyNameContext.class});
                }
                case "uuid": {
                    return StepDown.this.getChildren((ParseTree)ctx, new Class[]{UserAgentParser.UuIdContext.class});
                }
                case "url": {
                    return StepDown.this.getChildren((ParseTree)ctx, new Class[]{UserAgentParser.SiteUrlContext.class});
                }
                case "email": {
                    return StepDown.this.getChildren((ParseTree)ctx, new Class[]{UserAgentParser.EmailAddressContext.class});
                }
                case "text": {
                    return StepDown.this.getChildren((ParseTree)ctx, new Class[]{UserAgentParser.MultipleWordsContext.class, UserAgentParser.KeyValueVersionNameContext.class});
                }
                case "value": {
                    return StepDown.this.getChildren((ParseTree)ctx, new Class[]{UserAgentParser.UuIdContext.class, UserAgentParser.MultipleWordsContext.class, UserAgentParser.SiteUrlContext.class, UserAgentParser.EmailAddressContext.class, UserAgentParser.KeyValueVersionNameContext.class});
                }
            }
            return Collections.emptyList();
        }

        @Override
        public List<? extends ParserRuleContext> visitKeyWithoutValue(UserAgentParser.KeyWithoutValueContext ctx) {
            switch (StepDown.this.name) {
                case "key": {
                    return StepDown.this.getChildren((ParseTree)ctx, new Class[]{UserAgentParser.KeyNameContext.class});
                }
            }
            return Collections.emptyList();
        }

        @Override
        public List<? extends ParserRuleContext> visitKeyValueProductVersionName(UserAgentParser.KeyValueProductVersionNameContext ctx) {
            return Collections.emptyList();
        }

        @Override
        public List<? extends ParserRuleContext> visitCommentBlock(UserAgentParser.CommentBlockContext ctx) {
            switch (StepDown.this.name) {
                case "entry": {
                    return StepDown.this.getChildren((ParseTree)ctx, new Class[]{UserAgentParser.CommentEntryContext.class});
                }
            }
            return Collections.emptyList();
        }

        @Override
        public List<? extends ParserRuleContext> visitCommentEntry(UserAgentParser.CommentEntryContext ctx) {
            switch (StepDown.this.name) {
                case "comments": {
                    return StepDown.this.getChildren((ParseTree)ctx, new Class[]{UserAgentParser.CommentBlockContext.class});
                }
                case "keyvalue": {
                    return StepDown.this.getChildren((ParseTree)ctx, new Class[]{UserAgentParser.KeyValueContext.class, UserAgentParser.KeyWithoutValueContext.class});
                }
                case "product": {
                    return StepDown.this.getChildren((ParseTree)ctx, new Class[]{UserAgentParser.CommentProductContext.class});
                }
                case "uuid": {
                    return StepDown.this.getChildren((ParseTree)ctx, new Class[]{UserAgentParser.UuIdContext.class});
                }
                case "url": {
                    return StepDown.this.getChildren((ParseTree)ctx, new Class[]{UserAgentParser.SiteUrlContext.class});
                }
                case "email": {
                    return StepDown.this.getChildren((ParseTree)ctx, new Class[]{UserAgentParser.EmailAddressContext.class});
                }
                case "text": {
                    return StepDown.this.getChildren((ParseTree)ctx, new Class[]{UserAgentParser.MultipleWordsContext.class, UserAgentParser.VersionWordsContext.class, UserAgentParser.EmptyWordContext.class});
                }
            }
            return Collections.emptyList();
        }

        @Override
        public List<? extends ParserRuleContext> visitSiteUrl(UserAgentParser.SiteUrlContext ctx) {
            return Collections.emptyList();
        }

        @Override
        public List<? extends ParserRuleContext> visitEmailAddress(UserAgentParser.EmailAddressContext ctx) {
            return Collections.emptyList();
        }

        @Override
        public List<? extends ParserRuleContext> visitUuId(UserAgentParser.UuIdContext ctx) {
            return Collections.emptyList();
        }

        @Override
        public List<? extends ParserRuleContext> visitVersionWords(UserAgentParser.VersionWordsContext ctx) {
            return Collections.emptyList();
        }

        @Override
        public List<? extends ParserRuleContext> visitMultipleWords(UserAgentParser.MultipleWordsContext ctx) {
            return Collections.emptyList();
        }

        @Override
        public List<? extends ParserRuleContext> visitCommentSeparator(UserAgentParser.CommentSeparatorContext ctx) {
            return Collections.emptyList();
        }

        @Override
        public List<? extends ParserRuleContext> visitEmptyWord(UserAgentParser.EmptyWordContext ctx) {
            return Collections.emptyList();
        }

        @Override
        public List<? extends ParserRuleContext> visitRootTextPart(UserAgentParser.RootTextPartContext ctx) {
            return Collections.emptyList();
        }
    }
}

