/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.dissector;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.ParsedField;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import nl.basjes.parse.core.exceptions.InvalidDissectorException;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.UserAgentAnalyzer;

public class UserAgentDissector
extends Dissector {
    private static UserAgentAnalyzer userAgentAnalyzer = null;
    private static final String INPUT_TYPE = "HTTP.USERAGENT";
    private static final Map<String, String> FIELD_NAME_MAPPING_CACHE = new HashMap<String, String>(64);

    public String getInputType() {
        return INPUT_TYPE;
    }

    public boolean initializeFromSettingsParameter(String s) {
        if (userAgentAnalyzer == null) {
            userAgentAnalyzer = new UserAgentAnalyzer();
        }
        return true;
    }

    public void dissect(Parsable<?> parsable, String inputname) throws DissectionFailure {
        ParsedField agentField;
        String userAgentString;
        if (userAgentAnalyzer == null) {
            userAgentAnalyzer = new UserAgentAnalyzer();
        }
        if ((userAgentString = (agentField = parsable.getParsableField(INPUT_TYPE, inputname)).getValue().getString()) == null) {
            return;
        }
        UserAgent agent = userAgentAnalyzer.parse(userAgentString);
        for (String fieldName : agent.getAvailableFieldNames()) {
            parsable.addDissection(inputname, "STRING", UserAgentDissector.fieldNameToDissectionName(fieldName), agent.getValue(fieldName));
        }
    }

    public List<String> getPossibleOutput() {
        if (userAgentAnalyzer == null) {
            userAgentAnalyzer = new UserAgentAnalyzer();
        }
        ArrayList<String> result = new ArrayList<String>();
        List<String> fieldNames = userAgentAnalyzer.getAllPossibleFieldNamesSorted();
        for (String fieldName : fieldNames) {
            result.add("STRING:" + UserAgentDissector.fieldNameToDissectionName(fieldName));
        }
        return result;
    }

    public EnumSet<Casts> prepareForDissect(String s, String s1) {
        return Casts.STRING_ONLY;
    }

    public void prepareForRun() throws InvalidDissectorException {
    }

    protected void initializeNewInstance(Dissector dissector) {
    }

    static String fieldNameToDissectionName(String fieldName) {
        String dissectionName = FIELD_NAME_MAPPING_CACHE.get(fieldName);
        if (dissectionName == null) {
            dissectionName = fieldName.replaceAll("([A-Z])", "_$1").toLowerCase(Locale.ENGLISH).replaceFirst("_", "");
            FIELD_NAME_MAPPING_CACHE.put(fieldName, dissectionName);
        }
        return dissectionName;
    }
}

