/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.platfora;

import java.util.List;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.platfora.AbstractAnalyzeUserAgent;

public class AnalyzeUserAgent
extends AbstractAnalyzeUserAgent {
    public String getFunctionName() {
        return "ANALYZE_USERAGENT";
    }

    @Override
    public String getReturnType() {
        return "STRING";
    }

    public String[] getArgumentTypes() {
        return new String[]{"STRING", "STRING"};
    }

    public String getDescription() {
        List<String> fieldNames = this.getAllPossibleFieldNamesSorted();
        StringBuilder sb = new StringBuilder(1024);
        for (String fieldName : fieldNames) {
            sb.append('\"').append(fieldName).append("\" ");
        }
        return "The ANALYZE_USERAGENT function returns the value of a single field from the analysis of the specified useragent string. Available field names are: " + sb;
    }

    public String getReturnValueDescription() {
        return this.getDescription();
    }

    public String getExampleUsage() {
        return "ANALYZE_USERAGENT( useragent , \"AgentName\" )";
    }

    public String compute(List arguments) {
        try {
            String useragent = (String)arguments.get(0);
            String attribute = (String)arguments.get(1);
            if (!this.getAllPossibleFieldNamesSorted().contains(attribute)) {
                return "[[ERROR: The fieldname \"" + attribute + "\" does not exist]]";
            }
            UserAgent parsedUserAgent = this.parseUserAgent(useragent);
            if (parsedUserAgent == null) {
                return null;
            }
            return parsedUserAgent.getValue(attribute);
        }
        catch (Exception e) {
            return "[[ERROR: Exception: " + e.getMessage() + "]]";
        }
    }
}

