/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.utils;

public final class VersionSplitter {
    private VersionSplitter() {
    }

    public static boolean isVersionSeparator(char c) {
        switch (c) {
            case '.': 
            case '_': {
                return true;
            }
        }
        return false;
    }

    public static int findNextVersionStart(char[] chars, int offset) {
        for (int charNr = offset; charNr < chars.length; ++charNr) {
            char theChar = chars[charNr];
            if (VersionSplitter.isVersionSeparator(theChar)) continue;
            return charNr;
        }
        return -1;
    }

    public static int findVersionStart(char[] chars, int version) {
        int charNr = 0;
        boolean inVersion = false;
        int currentVersion = 0;
        for (char theChar : chars) {
            if (VersionSplitter.isVersionSeparator(theChar)) {
                if (inVersion) {
                    inVersion = false;
                }
            } else if (!inVersion) {
                inVersion = true;
                if (++currentVersion == version) {
                    return charNr;
                }
            }
            ++charNr;
        }
        return -1;
    }

    public static int findVersionEnd(char[] chars, int start) {
        for (int i = start; i < chars.length; ++i) {
            if (!VersionSplitter.isVersionSeparator(chars[i])) continue;
            return i;
        }
        return chars.length;
    }

    public static String getSingleVersion(String value, int word) {
        char[] characters = value.toCharArray();
        int start = VersionSplitter.findVersionStart(characters, word);
        if (start == -1) {
            return null;
        }
        int end = VersionSplitter.findVersionEnd(characters, start);
        return value.substring(start, end);
    }

    public static String getFirstVersions(String value, int word) {
        char[] characters = value.toCharArray();
        int start = VersionSplitter.findVersionStart(characters, word);
        if (start == -1) {
            return null;
        }
        int end = VersionSplitter.findVersionEnd(characters, start);
        return value.substring(0, end);
    }
}

