#!/bin/bash
# Yet Another UserAgent Analyzer
# Copyright (C) 2013-2016 Niels Basjes
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

(
echo "# ============================================="
echo "# THIS FILE WAS GENERATED; DO NOT EDIT MANUALLY"
echo "# ============================================="
echo "config:"

#echo "  - lookup:"
#echo "      name: 'OperatingSystemNames'"
#echo "      map:"
#cat "OperatingSystemNames.csv" | grep . | fgrep -v '#' | while read line ; \
#do
#    osname=$(   echo ${line} | cut -d'|' -f1)
#    devclass=$( echo ${line} | cut -d'|' -f2)
#    devname=$(  echo ${line} | cut -d'|' -f3)
#    echo "       \"${osname}\" : \"${osname}\""
#done

#echo "  - lookup:"
#echo "      name: 'DeviceClassess'"
#echo "      map:"
#cat "OperatingSystemNames.csv" | grep . | fgrep -v '#' | while read line ; \
#do
#    osname=$(   echo ${line} | cut -d'|' -f1)
#    devclass=$( echo ${line} | cut -d'|' -f2)
#    devname=$(  echo ${line} | cut -d'|' -f3)
#    echo "       \"${osname}\" : \"${devclass}\""
#done

#echo "  - lookup:"
#echo "      name: 'DeviceNames'"
#echo "      map:"
#cat "OperatingSystemNames.csv" | grep . | fgrep -v '#' | while read line ; \
#do
#    osname=$(   echo ${line} | cut -d'|' -f1)
#    devclass=$( echo ${line} | cut -d'|' -f2)
#    devname=$(  echo ${line} | cut -d'|' -f3)
#    echo "       \"${osname}\" : \"${devname}\""
#done

cat "OperatingSystemNames.csv" | grep . | fgrep -v '#' | while read line ; \
do
    osname=$(   echo ${line} | cut -d'|' -f1)
    devclass=$( echo ${line} | cut -d'|' -f2)
    devname=$(  echo ${line} | cut -d'|' -f3)
echo "
  - matcher:
      require:
        - 'agent.(1)product.(1)comments.entry.text=\"${osname}\"'
      extract:
        - 'DeviceClass           :   10:\"${devclass}\"'
        - 'DeviceName            :   10:\"${devname}\"'
        - 'OperatingSystemClass  :   50:\"Desktop\"'
        - 'OperatingSystemName   :   50:\"${osname}\"'
        - 'OperatingSystemVersion:   50:\"??\"'

  - matcher:
      extract:
        - 'DeviceClass           :   10:\"${devclass}\"'
        - 'DeviceName            :   10:\"${devname}\"'
        - 'OperatingSystemClass  :   50:\"Desktop\"'
        - 'OperatingSystemName   :   50:\"${osname}\"'
        - 'OperatingSystemVersion:   50:agent.(1)product.(1)comments.entry.product.name=\"${osname}\"^.version'

  - matcher:
      extract:
        - 'DeviceClass           :   10:\"${devclass}\"'
        - 'DeviceName            :   10:\"${devname}\"'
        - 'OperatingSystemClass  :   50:\"Desktop\"'
        - 'OperatingSystemName   :   50:agent.product.(1)comments.entry.text=\"${osname}\"'
        - 'OperatingSystemVersion:   50:\"??\"'

  - matcher:
      extract:
        - 'DeviceClass           :   10:\"${devclass}\"'
        - 'DeviceName            :   10:\"${devname}\"'
        - 'OperatingSystemClass  :   50:\"Desktop\"'
        - 'OperatingSystemName   :   50:\"${osname}\"'
        - 'OperatingSystemVersion:   50:agent.product.name=\"${osname}\"^.version'


  - matcher:
      require:
        - 'agent.product.name#1=\"${osname}\"'
      extract:
        - 'DeviceClass           :   10:\"${devclass}\"'
        - 'DeviceName            :   10:\"${devname}\"'
        - 'OperatingSystemClass  :   50:\"Desktop\"'
        - 'OperatingSystemName   :   50:\"${osname}\"'
        - 'OperatingSystemVersion:   50:\"??\"'

  - matcher:
      require:
        - 'agent.product.name#2=\"${osname}\"'
      extract:
        - 'DeviceClass           :   10:\"${devclass}\"'
        - 'DeviceName            :   10:\"${devname}\"'
        - 'OperatingSystemClass  :   50:\"Desktop\"'
        - 'OperatingSystemName   :   50:\"${osname}\"'
        - 'OperatingSystemVersion:   50:\"??\"'

"
done

) > ../OperatingSystemNames.yaml
