/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import nl.basjes.parse.useragent.analyze.Matcher;
import nl.basjes.parse.useragent.parser.UserAgentBaseListener;
import nl.basjes.parse.useragent.utils.DefaultANTLRErrorListener;
import nl.basjes.shaded.org.antlr.v4.runtime.Parser;
import nl.basjes.shaded.org.antlr.v4.runtime.RecognitionException;
import nl.basjes.shaded.org.antlr.v4.runtime.Recognizer;
import nl.basjes.shaded.org.antlr.v4.runtime.atn.ATNConfigSet;
import nl.basjes.shaded.org.antlr.v4.runtime.dfa.DFA;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAgent
extends UserAgentBaseListener
implements Serializable,
DefaultANTLRErrorListener {
    private static final Logger LOG = LoggerFactory.getLogger(UserAgent.class);
    public static final String DEVICE_CLASS = "DeviceClass";
    public static final String DEVICE_NAME = "DeviceName";
    public static final String DEVICE_BRAND = "DeviceBrand";
    public static final String DEVICE_CPU = "DeviceCpu";
    public static final String DEVICE_CPU_BITS = "DeviceCpuBits";
    public static final String DEVICE_FIRMWARE_VERSION = "DeviceFirmwareVersion";
    public static final String DEVICE_VERSION = "DeviceVersion";
    public static final String OPERATING_SYSTEM_CLASS = "OperatingSystemClass";
    public static final String OPERATING_SYSTEM_NAME = "OperatingSystemName";
    public static final String OPERATING_SYSTEM_VERSION = "OperatingSystemVersion";
    public static final String OPERATING_SYSTEM_VERSION_MAJOR = "OperatingSystemVersionMajor";
    public static final String OPERATING_SYSTEM_NAME_VERSION = "OperatingSystemNameVersion";
    public static final String OPERATING_SYSTEM_NAME_VERSION_MAJOR = "OperatingSystemNameVersionMajor";
    public static final String OPERATING_SYSTEM_VERSION_BUILD = "OperatingSystemVersionBuild";
    public static final String LAYOUT_ENGINE_CLASS = "LayoutEngineClass";
    public static final String LAYOUT_ENGINE_NAME = "LayoutEngineName";
    public static final String LAYOUT_ENGINE_VERSION = "LayoutEngineVersion";
    public static final String LAYOUT_ENGINE_VERSION_MAJOR = "LayoutEngineVersionMajor";
    public static final String LAYOUT_ENGINE_NAME_VERSION = "LayoutEngineNameVersion";
    public static final String LAYOUT_ENGINE_NAME_VERSION_MAJOR = "LayoutEngineNameVersionMajor";
    public static final String LAYOUT_ENGINE_BUILD = "LayoutEngineBuild";
    public static final String AGENT_CLASS = "AgentClass";
    public static final String AGENT_NAME = "AgentName";
    public static final String AGENT_VERSION = "AgentVersion";
    public static final String AGENT_VERSION_MAJOR = "AgentVersionMajor";
    public static final String AGENT_NAME_VERSION = "AgentNameVersion";
    public static final String AGENT_NAME_VERSION_MAJOR = "AgentNameVersionMajor";
    public static final String AGENT_BUILD = "AgentBuild";
    public static final String AGENT_LANGUAGE = "AgentLanguage";
    public static final String AGENT_LANGUAGE_CODE = "AgentLanguageCode";
    public static final String AGENT_INFORMATION_EMAIL = "AgentInformationEmail";
    public static final String AGENT_INFORMATION_URL = "AgentInformationUrl";
    public static final String AGENT_SECURITY = "AgentSecurity";
    public static final String AGENT_UUID = "AgentUuid";
    public static final String WEBVIEW_APP_NAME = "WebviewAppName";
    public static final String WEBVIEW_APP_VERSION = "WebviewAppVersion";
    public static final String WEBVIEW_APP_VERSION_MAJOR = "WebviewAppVersionMajor";
    public static final String WEBVIEW_APP_NAME_VERSION_MAJOR = "WebviewAppNameVersionMajor";
    public static final String FACEBOOK_CARRIER = "FacebookCarrier";
    public static final String FACEBOOK_DEVICE_CLASS = "FacebookDeviceClass";
    public static final String FACEBOOK_DEVICE_NAME = "FacebookDeviceName";
    public static final String FACEBOOK_DEVICE_VERSION = "FacebookDeviceVersion";
    public static final String FACEBOOK_F_B_O_P = "FacebookFBOP";
    public static final String FACEBOOK_F_B_S_S = "FacebookFBSS";
    public static final String FACEBOOK_OPERATING_SYSTEM_NAME = "FacebookOperatingSystemName";
    public static final String FACEBOOK_OPERATING_SYSTEM_VERSION = "FacebookOperatingSystemVersion";
    public static final String ANONYMIZED = "Anonymized";
    public static final String HACKER_ATTACK_VECTOR = "HackerAttackVector";
    public static final String HACKER_TOOLKIT = "HackerToolkit";
    public static final String KOBO_AFFILIATE = "KoboAffiliate";
    public static final String KOBO_PLATFORM_ID = "KoboPlatformId";
    public static final String IE_COMPATIBILITY_VERSION = "IECompatibilityVersion";
    public static final String IE_COMPATIBILITY_VERSION_MAJOR = "IECompatibilityVersionMajor";
    public static final String IE_COMPATIBILITY_NAME_VERSION = "IECompatibilityNameVersion";
    public static final String IE_COMPATIBILITY_NAME_VERSION_MAJOR = "IECompatibilityNameVersionMajor";
    public static final String SYNTAX_ERROR = "__SyntaxError__";
    public static final String USERAGENT_FIELDNAME = "Useragent";
    public static final String NETWORK_TYPE = "NetworkType";
    public static final String SET_ALL_FIELDS = "__Set_ALL_Fields__";
    public static final String NULL_VALUE = "<<<null>>>";
    public static final String UNKNOWN_VALUE = "Unknown";
    public static final String UNKNOWN_VERSION = "??";
    public static final String UNKNOWN_NAME_VERSION = "Unknown ??";
    public static final List<String> STANDARD_FIELDS = Collections.unmodifiableList(Arrays.asList("DeviceClass", "DeviceBrand", "DeviceName", "OperatingSystemClass", "OperatingSystemName", "OperatingSystemVersion", "OperatingSystemVersionMajor", "OperatingSystemNameVersion", "OperatingSystemNameVersionMajor", "LayoutEngineClass", "LayoutEngineName", "LayoutEngineVersion", "LayoutEngineVersionMajor", "LayoutEngineNameVersion", "LayoutEngineNameVersionMajor", "AgentClass", "AgentName", "AgentVersion", "AgentVersionMajor", "AgentNameVersion", "AgentNameVersionMajor"));
    private static final Map<String, AgentField> DEFAULTS_FOR_KNOWN_FIELDS = new TreeMap<String, AgentField>();
    private Set<String> wantedFieldNames = null;
    private boolean hasSyntaxError;
    private boolean hasAmbiguity;
    private int ambiguityCount;
    private String userAgentString = null;
    private boolean debug = false;
    private final Map<String, AgentField> allFields = new HashMap<String, AgentField>();
    protected static final List<String> PRE_SORTED_FIELDS_LIST;

    public boolean hasSyntaxError() {
        return this.hasSyntaxError;
    }

    public boolean hasAmbiguity() {
        return this.hasAmbiguity;
    }

    public int getAmbiguityCount() {
        return this.ambiguityCount;
    }

    @Override
    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
        if (this.debug) {
            LOG.error("Syntax error");
            LOG.error("Source : {}", (Object)this.userAgentString);
            LOG.error("Message: {}", (Object)msg);
        }
        this.hasSyntaxError = true;
        AgentField syntaxError = new AgentField("false");
        syntaxError.setValue("true", 1L);
        this.allFields.put(SYNTAX_ERROR, syntaxError);
    }

    @Override
    public void reportAmbiguity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, boolean exact, BitSet ambigAlts, ATNConfigSet configs) {
        this.hasAmbiguity = true;
        ++this.ambiguityCount;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean newDebug) {
        this.debug = newDebug;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserAgent)) {
            return false;
        }
        UserAgent agent = (UserAgent)o;
        return Objects.equals(this.userAgentString, agent.userAgentString) && Objects.equals(this.allFields, agent.allFields);
    }

    public int hashCode() {
        return Objects.hash(this.userAgentString, this.allFields);
    }

    private void setWantedFieldNames(Collection<String> newWantedFieldNames) {
        if (newWantedFieldNames != null && !newWantedFieldNames.isEmpty()) {
            this.wantedFieldNames = new LinkedHashSet<String>(newWantedFieldNames);
        }
    }

    public UserAgent() {
        this.init();
    }

    public UserAgent(Collection<String> wantedFieldNames) {
        this.setWantedFieldNames(wantedFieldNames);
        this.init();
    }

    public UserAgent(String userAgentString) {
        this.init();
        this.setUserAgentString(userAgentString);
    }

    public UserAgent(String userAgentString, Collection<String> wantedFieldNames) {
        this.setWantedFieldNames(wantedFieldNames);
        this.init();
        this.setUserAgentString(userAgentString);
    }

    public UserAgent(UserAgent userAgent) {
        this.clone(userAgent);
    }

    public void clone(UserAgent userAgent) {
        this.userAgentString = userAgent.userAgentString;
        this.wantedFieldNames = userAgent.wantedFieldNames;
        this.debug = userAgent.debug;
        this.hasSyntaxError = userAgent.hasSyntaxError;
        this.hasAmbiguity = userAgent.hasAmbiguity;
        this.ambiguityCount = userAgent.ambiguityCount;
        this.init();
        for (Map.Entry<String, AgentField> entry : userAgent.allFields.entrySet()) {
            this.set(entry.getKey(), entry.getValue().getValue(), entry.getValue().confidence);
        }
    }

    private void init() {
        if (this.wantedFieldNames == null) {
            DEFAULTS_FOR_KNOWN_FIELDS.forEach((k, v) -> this.allFields.put((String)k, new AgentField(((AgentField)v).defaultValue)));
        } else {
            for (String wantedFieldName : this.wantedFieldNames) {
                AgentField agentField = DEFAULTS_FOR_KNOWN_FIELDS.get(wantedFieldName);
                if (agentField == null) continue;
                this.allFields.put(wantedFieldName, new AgentField(agentField.defaultValue));
            }
        }
    }

    public void setUserAgentString(String newUserAgentString) {
        this.userAgentString = newUserAgentString;
        this.reset();
    }

    public String getUserAgentString() {
        return this.userAgentString;
    }

    public void reset() {
        this.hasSyntaxError = false;
        this.hasAmbiguity = false;
        this.ambiguityCount = 0;
        for (AgentField field : this.allFields.values()) {
            field.reset();
        }
    }

    public static boolean isSystemField(String fieldname) {
        return SET_ALL_FIELDS.equals(fieldname) || SYNTAX_ERROR.equals(fieldname) || USERAGENT_FIELDNAME.equals(fieldname);
    }

    public void processSetAll() {
        AgentField setAllField = this.allFields.get(SET_ALL_FIELDS);
        if (setAllField == null) {
            return;
        }
        String value = setAllField.getValue();
        long confidence = setAllField.confidence;
        for (Map.Entry<String, AgentField> fieldEntry : this.allFields.entrySet()) {
            if (UserAgent.isSystemField(fieldEntry.getKey())) continue;
            fieldEntry.getValue().setValue(value, confidence);
        }
    }

    public void set(String attribute, String value, long confidence) {
        AgentField field = this.allFields.get(attribute);
        if (field == null) {
            field = new AgentField(null);
        }
        boolean wasEmpty = confidence == -1L;
        boolean updated = field.setValue(value, confidence);
        if (this.debug && !wasEmpty) {
            if (updated) {
                LOG.info("USE  {} ({}) = {}", new Object[]{attribute, confidence, value});
            } else {
                LOG.info("SKIP {} ({}) = {}", new Object[]{attribute, confidence, value});
            }
        }
        this.allFields.put(attribute, field);
    }

    public void setForced(String attribute, String value, long confidence) {
        AgentField field = this.allFields.get(attribute);
        if (field == null) {
            field = new AgentField(null);
        }
        boolean wasEmpty = confidence == -1L;
        field.setValueForced(value, confidence);
        if (this.debug && !wasEmpty) {
            LOG.info("USE  {} ({}) = {}", new Object[]{attribute, confidence, value});
        }
        this.allFields.put(attribute, field);
    }

    public void set(UserAgent newValuesUserAgent, Matcher appliedMatcher) {
        for (String fieldName : newValuesUserAgent.allFields.keySet()) {
            AgentField field = newValuesUserAgent.allFields.get(fieldName);
            this.set(fieldName, field.value, field.confidence);
        }
    }

    void setImmediateForTesting(String fieldName, AgentField agentField) {
        this.allFields.put(fieldName, agentField);
    }

    public AgentField get(String fieldName) {
        if (USERAGENT_FIELDNAME.equals(fieldName)) {
            AgentField agentField = new AgentField(this.userAgentString);
            agentField.setValue(this.userAgentString, 0L);
            return agentField;
        }
        return this.allFields.get(fieldName);
    }

    public String getValue(String fieldName) {
        if (USERAGENT_FIELDNAME.equals(fieldName)) {
            return this.userAgentString;
        }
        AgentField field = this.allFields.get(fieldName);
        if (field == null) {
            return UNKNOWN_VALUE;
        }
        return field.getValue();
    }

    public Long getConfidence(String fieldName) {
        if (USERAGENT_FIELDNAME.equals(fieldName)) {
            return 0L;
        }
        AgentField field = this.allFields.get(fieldName);
        if (field == null) {
            return -1L;
        }
        return field.getConfidence();
    }

    public String escapeYaml(String input) {
        return input.replace("'", "''");
    }

    public String toYamlTestCase() {
        return this.toYamlTestCase(false, null);
    }

    public String toYamlTestCase(boolean showConfidence) {
        return this.toYamlTestCase(showConfidence, null);
    }

    public String toYamlTestCase(boolean showConfidence, Map<String, String> comments) {
        String value;
        StringBuilder sb = new StringBuilder(10240);
        sb.append("\n");
        sb.append("- test:\n");
        sb.append("    input:\n");
        sb.append("      user_agent_string: '").append(this.escapeYaml(this.userAgentString)).append("'\n");
        sb.append("    expected:\n");
        List<String> fieldNames = this.getAvailableFieldNamesSorted();
        int maxNameLength = 30;
        int maxValueLength = 0;
        for (String fieldName : this.allFields.keySet()) {
            maxNameLength = Math.max(maxNameLength, fieldName.length());
        }
        for (String fieldName : fieldNames) {
            value = this.getValue(fieldName);
            if (value == null) continue;
            maxValueLength = Math.max(maxValueLength, value.length());
        }
        for (String fieldName : fieldNames) {
            String comment;
            sb.append("      ").append(fieldName);
            for (int l = fieldName.length(); l < maxNameLength + 7; ++l) {
                sb.append(' ');
            }
            value = this.getValue(fieldName);
            sb.append(": '").append(value).append('\'');
            if (showConfidence) {
                int l;
                int n = l = value == null ? 0 : value.length();
                while (l < maxValueLength + 5) {
                    sb.append(' ');
                    ++l;
                }
                sb.append("# ").append(String.format("%8d", this.getConfidence(fieldName)));
            }
            if (comments != null && (comment = comments.get(fieldName)) != null) {
                sb.append(" | ").append(comment);
            }
            sb.append('\n');
        }
        sb.append("\n\n");
        return sb.toString();
    }

    public Map<String, String> toMap() {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add(USERAGENT_FIELDNAME);
        fields.addAll(this.getAvailableFieldNamesSorted());
        return this.toMap(fields);
    }

    public Map<String, String> toMap(String ... fieldNames) {
        return this.toMap(Arrays.asList(fieldNames));
    }

    public Map<String, String> toMap(List<String> fieldNames) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (String fieldName : fieldNames) {
            if (USERAGENT_FIELDNAME.equals(fieldName)) {
                result.put(USERAGENT_FIELDNAME, this.getUserAgentString());
                continue;
            }
            result.put(fieldName, this.getValue(fieldName));
        }
        return result;
    }

    public String toJson() {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add(USERAGENT_FIELDNAME);
        fields.addAll(this.getAvailableFieldNamesSorted());
        return this.toJson(fields);
    }

    public String toJson(String ... fieldNames) {
        return this.toJson(Arrays.asList(fieldNames));
    }

    public String toJson(List<String> fieldNames) {
        StringBuilder sb = new StringBuilder(10240);
        sb.append("{");
        boolean addSeparator = false;
        for (String fieldName : fieldNames) {
            if (addSeparator) {
                sb.append(',');
            } else {
                addSeparator = true;
            }
            if (USERAGENT_FIELDNAME.equals(fieldName)) {
                sb.append("\"Useragent\"").append(':').append('\"').append(StringEscapeUtils.escapeJson((String)this.getUserAgentString())).append('\"');
                continue;
            }
            sb.append('\"').append(StringEscapeUtils.escapeJson((String)fieldName)).append('\"').append(':').append('\"').append(StringEscapeUtils.escapeJson((String)this.getValue(fieldName))).append('\"');
        }
        sb.append("}");
        return sb.toString();
    }

    public String toXML() {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add(USERAGENT_FIELDNAME);
        fields.addAll(this.getAvailableFieldNamesSorted());
        return this.toXML(fields);
    }

    public String toXML(String ... fieldNames) {
        return this.toXML(Arrays.asList(fieldNames));
    }

    public String toXML(List<String> fieldNames) {
        StringBuilder sb = new StringBuilder(10240).append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append("<Yauaa>");
        for (String fieldName : fieldNames) {
            if (USERAGENT_FIELDNAME.equals(fieldName)) {
                sb.append("<Useragent>").append(StringEscapeUtils.escapeXml10((String)this.getUserAgentString())).append("</Useragent>");
                continue;
            }
            sb.append('<').append(StringEscapeUtils.escapeXml10((String)fieldName)).append('>').append(StringEscapeUtils.escapeXml10((String)this.getValue(fieldName))).append("</").append(StringEscapeUtils.escapeXml10((String)fieldName)).append('>');
        }
        sb.append("</Yauaa>");
        return sb.toString();
    }

    public String toString() {
        return this.toString(this.getAvailableFieldNamesSorted());
    }

    public String toString(String ... fieldNames) {
        return this.toString(Arrays.asList(fieldNames));
    }

    public String toString(List<String> fieldNames) {
        StringBuilder sb = new StringBuilder("  - user_agent_string: '" + this.escapeYaml(this.userAgentString) + "'\n");
        int maxLength = 0;
        for (String fieldName : fieldNames) {
            maxLength = Math.max(maxLength, fieldName.length());
        }
        for (String fieldName : fieldNames) {
            AgentField field;
            if (USERAGENT_FIELDNAME.equals(fieldName) || (field = this.allFields.get(fieldName)) == null || field.getValue() == null) continue;
            sb.append("    ").append(fieldName);
            for (int l = fieldName.length(); l < maxLength + 2; ++l) {
                sb.append(' ');
            }
            sb.append(": '").append(field.getValue()).append('\'');
            sb.append('\n');
        }
        return sb.toString();
    }

    public List<String> getAvailableFieldNames() {
        ArrayList<String> resultSet = new ArrayList<String>(this.allFields.size() + 10);
        this.allFields.forEach((fieldName, value) -> {
            AgentField field;
            if (!resultSet.contains(fieldName) && (field = this.allFields.get(fieldName)) != null && field.getValue() != null) {
                if (this.wantedFieldNames == null || this.wantedFieldNames.contains(fieldName)) {
                    resultSet.add((String)fieldName);
                } else if (field.confidence >= 0L) {
                    resultSet.add((String)fieldName);
                }
            }
        });
        resultSet.remove(SET_ALL_FIELDS);
        return resultSet;
    }

    public List<String> getAvailableFieldNamesSorted() {
        ArrayList<String> fieldNames = new ArrayList<String>(this.getAvailableFieldNames());
        ArrayList<String> result = new ArrayList<String>();
        for (String fieldName : PRE_SORTED_FIELDS_LIST) {
            if (!fieldNames.remove(fieldName)) continue;
            result.add(fieldName);
        }
        Collections.sort(fieldNames);
        result.addAll(fieldNames);
        return result;
    }

    static {
        DEFAULTS_FOR_KNOWN_FIELDS.put(DEVICE_CLASS, new AgentField(UNKNOWN_VALUE));
        DEFAULTS_FOR_KNOWN_FIELDS.put(DEVICE_BRAND, new AgentField(UNKNOWN_VALUE));
        DEFAULTS_FOR_KNOWN_FIELDS.put(DEVICE_NAME, new AgentField(UNKNOWN_VALUE));
        DEFAULTS_FOR_KNOWN_FIELDS.put(OPERATING_SYSTEM_CLASS, new AgentField(UNKNOWN_VALUE));
        DEFAULTS_FOR_KNOWN_FIELDS.put(OPERATING_SYSTEM_NAME, new AgentField(UNKNOWN_VALUE));
        DEFAULTS_FOR_KNOWN_FIELDS.put(OPERATING_SYSTEM_VERSION, new AgentField(UNKNOWN_VERSION));
        DEFAULTS_FOR_KNOWN_FIELDS.put(OPERATING_SYSTEM_VERSION_MAJOR, new AgentField(UNKNOWN_VERSION));
        DEFAULTS_FOR_KNOWN_FIELDS.put(OPERATING_SYSTEM_NAME_VERSION, new AgentField(UNKNOWN_NAME_VERSION));
        DEFAULTS_FOR_KNOWN_FIELDS.put(OPERATING_SYSTEM_NAME_VERSION_MAJOR, new AgentField(UNKNOWN_NAME_VERSION));
        DEFAULTS_FOR_KNOWN_FIELDS.put(LAYOUT_ENGINE_CLASS, new AgentField(UNKNOWN_VALUE));
        DEFAULTS_FOR_KNOWN_FIELDS.put(LAYOUT_ENGINE_NAME, new AgentField(UNKNOWN_VALUE));
        DEFAULTS_FOR_KNOWN_FIELDS.put(LAYOUT_ENGINE_VERSION, new AgentField(UNKNOWN_VERSION));
        DEFAULTS_FOR_KNOWN_FIELDS.put(LAYOUT_ENGINE_VERSION_MAJOR, new AgentField(UNKNOWN_VERSION));
        DEFAULTS_FOR_KNOWN_FIELDS.put(LAYOUT_ENGINE_NAME_VERSION, new AgentField(UNKNOWN_NAME_VERSION));
        DEFAULTS_FOR_KNOWN_FIELDS.put(LAYOUT_ENGINE_NAME_VERSION_MAJOR, new AgentField(UNKNOWN_NAME_VERSION));
        DEFAULTS_FOR_KNOWN_FIELDS.put(AGENT_CLASS, new AgentField(UNKNOWN_VALUE));
        DEFAULTS_FOR_KNOWN_FIELDS.put(AGENT_NAME, new AgentField(UNKNOWN_VALUE));
        DEFAULTS_FOR_KNOWN_FIELDS.put(AGENT_VERSION, new AgentField(UNKNOWN_VERSION));
        DEFAULTS_FOR_KNOWN_FIELDS.put(AGENT_VERSION_MAJOR, new AgentField(UNKNOWN_VERSION));
        DEFAULTS_FOR_KNOWN_FIELDS.put(AGENT_NAME_VERSION, new AgentField(UNKNOWN_NAME_VERSION));
        DEFAULTS_FOR_KNOWN_FIELDS.put(AGENT_NAME_VERSION_MAJOR, new AgentField(UNKNOWN_NAME_VERSION));
        ArrayList<String> mutablePreSortedFields = new ArrayList<String>(32);
        mutablePreSortedFields.add(DEVICE_CLASS);
        mutablePreSortedFields.add(DEVICE_NAME);
        mutablePreSortedFields.add(DEVICE_BRAND);
        mutablePreSortedFields.add(DEVICE_CPU);
        mutablePreSortedFields.add(DEVICE_CPU_BITS);
        mutablePreSortedFields.add(DEVICE_FIRMWARE_VERSION);
        mutablePreSortedFields.add(DEVICE_VERSION);
        mutablePreSortedFields.add(OPERATING_SYSTEM_CLASS);
        mutablePreSortedFields.add(OPERATING_SYSTEM_NAME);
        mutablePreSortedFields.add(OPERATING_SYSTEM_VERSION);
        mutablePreSortedFields.add(OPERATING_SYSTEM_VERSION_MAJOR);
        mutablePreSortedFields.add(OPERATING_SYSTEM_NAME_VERSION);
        mutablePreSortedFields.add(OPERATING_SYSTEM_NAME_VERSION_MAJOR);
        mutablePreSortedFields.add(OPERATING_SYSTEM_VERSION_BUILD);
        mutablePreSortedFields.add(LAYOUT_ENGINE_CLASS);
        mutablePreSortedFields.add(LAYOUT_ENGINE_NAME);
        mutablePreSortedFields.add(LAYOUT_ENGINE_VERSION);
        mutablePreSortedFields.add(LAYOUT_ENGINE_VERSION_MAJOR);
        mutablePreSortedFields.add(LAYOUT_ENGINE_NAME_VERSION);
        mutablePreSortedFields.add(LAYOUT_ENGINE_NAME_VERSION_MAJOR);
        mutablePreSortedFields.add(LAYOUT_ENGINE_BUILD);
        mutablePreSortedFields.add(AGENT_CLASS);
        mutablePreSortedFields.add(AGENT_NAME);
        mutablePreSortedFields.add(AGENT_VERSION);
        mutablePreSortedFields.add(AGENT_VERSION_MAJOR);
        mutablePreSortedFields.add(AGENT_NAME_VERSION);
        mutablePreSortedFields.add(AGENT_NAME_VERSION_MAJOR);
        mutablePreSortedFields.add(AGENT_BUILD);
        mutablePreSortedFields.add(AGENT_LANGUAGE);
        mutablePreSortedFields.add(AGENT_LANGUAGE_CODE);
        mutablePreSortedFields.add(AGENT_INFORMATION_EMAIL);
        mutablePreSortedFields.add(AGENT_INFORMATION_URL);
        mutablePreSortedFields.add(AGENT_SECURITY);
        mutablePreSortedFields.add(AGENT_UUID);
        mutablePreSortedFields.add(WEBVIEW_APP_NAME);
        mutablePreSortedFields.add(WEBVIEW_APP_VERSION);
        mutablePreSortedFields.add(WEBVIEW_APP_VERSION_MAJOR);
        mutablePreSortedFields.add(WEBVIEW_APP_NAME_VERSION_MAJOR);
        mutablePreSortedFields.add(FACEBOOK_CARRIER);
        mutablePreSortedFields.add(FACEBOOK_DEVICE_CLASS);
        mutablePreSortedFields.add(FACEBOOK_DEVICE_NAME);
        mutablePreSortedFields.add(FACEBOOK_DEVICE_VERSION);
        mutablePreSortedFields.add(FACEBOOK_F_B_O_P);
        mutablePreSortedFields.add(FACEBOOK_F_B_S_S);
        mutablePreSortedFields.add(FACEBOOK_OPERATING_SYSTEM_NAME);
        mutablePreSortedFields.add(FACEBOOK_OPERATING_SYSTEM_VERSION);
        mutablePreSortedFields.add(ANONYMIZED);
        mutablePreSortedFields.add(HACKER_ATTACK_VECTOR);
        mutablePreSortedFields.add(HACKER_TOOLKIT);
        mutablePreSortedFields.add(KOBO_AFFILIATE);
        mutablePreSortedFields.add(KOBO_PLATFORM_ID);
        mutablePreSortedFields.add(IE_COMPATIBILITY_VERSION);
        mutablePreSortedFields.add(IE_COMPATIBILITY_VERSION_MAJOR);
        mutablePreSortedFields.add(IE_COMPATIBILITY_NAME_VERSION);
        mutablePreSortedFields.add(IE_COMPATIBILITY_NAME_VERSION_MAJOR);
        mutablePreSortedFields.add(SYNTAX_ERROR);
        PRE_SORTED_FIELDS_LIST = Collections.unmodifiableList(mutablePreSortedFields);
    }

    public static class AgentField
    implements Serializable {
        private final String defaultValue;
        private String value;
        private long confidence;

        private AgentField() {
            this.defaultValue = null;
        }

        AgentField(String defaultValue) {
            this.defaultValue = defaultValue;
            this.reset();
        }

        public void reset() {
            this.value = null;
            this.confidence = -1L;
        }

        public String getValue() {
            if (this.value == null) {
                return this.defaultValue;
            }
            return this.value;
        }

        public boolean isDefaultValue() {
            return this.confidence < 0L || this.value == null;
        }

        public long getConfidence() {
            if (this.value == null) {
                return -1L;
            }
            return this.confidence;
        }

        public boolean setValue(AgentField field) {
            return this.setValue(field.value, field.confidence);
        }

        public boolean setValue(String newValue, long newConfidence) {
            if (newConfidence > this.confidence) {
                this.confidence = newConfidence;
                this.value = UserAgent.NULL_VALUE.equals(newValue) ? null : newValue;
                return true;
            }
            return false;
        }

        public void setValueForced(String newValue, long newConfidence) {
            this.confidence = newConfidence;
            this.value = UserAgent.NULL_VALUE.equals(newValue) ? null : newValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AgentField)) {
                return false;
            }
            AgentField that = (AgentField)o;
            return this.confidence == that.confidence && Objects.equals(this.defaultValue, that.defaultValue) && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.defaultValue, this.value, this.confidence);
        }

        public String toString() {
            if (this.defaultValue == null) {
                return "{ value:'" + this.value + "', confidence:'" + this.confidence + "', default:null }";
            }
            return "{ value:'" + this.value + "', confidence:'" + this.confidence + "', default:'" + this.defaultValue + "' }";
        }
    }
}

