/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.calculate;

import java.util.regex.Pattern;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.calculate.FieldCalculator;
import nl.basjes.parse.useragent.utils.Normalize;

public class CalculateDeviceName
implements FieldCalculator {
    private static final Pattern CLEAN_1_PATTERN = Pattern.compile("AppleWebKit", 18);

    private String removeBadSubStrings(String input) {
        input = CLEAN_1_PATTERN.matcher(input).replaceAll("");
        return input;
    }

    @Override
    public void calculate(UserAgent userAgent) {
        UserAgent.AgentField deviceName = userAgent.get("DeviceName");
        if (deviceName.getConfidence() >= 0L) {
            UserAgent.AgentField deviceBrand = userAgent.get("DeviceBrand");
            String deviceNameValue = this.removeBadSubStrings(deviceName.getValue());
            String deviceBrandValue = deviceBrand.getValue();
            deviceNameValue = deviceName.getConfidence() >= 0L && deviceBrand.getConfidence() >= 0L && !deviceBrandValue.equals("Unknown") ? Normalize.cleanupDeviceBrandName(deviceBrandValue, deviceNameValue) : Normalize.brand(deviceNameValue);
            userAgent.setForced("DeviceName", deviceNameValue, deviceName.getConfidence());
        }
    }

    public String toString() {
        return "Calculate DeviceName";
    }
}

