/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.calculate;

import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.calculate.FieldCalculator;
import nl.basjes.parse.useragent.utils.VersionSplitter;

public class MajorVersionCalculator
implements FieldCalculator {
    private String versionName;
    private String majorVersionName;

    public MajorVersionCalculator(String majorVersionName, String versionName) {
        this.majorVersionName = majorVersionName;
        this.versionName = versionName;
    }

    private MajorVersionCalculator() {
    }

    @Override
    public void calculate(UserAgent userAgent) {
        UserAgent.AgentField agentVersion;
        UserAgent.AgentField agentVersionMajor = userAgent.get(this.majorVersionName);
        if ((agentVersionMajor == null || agentVersionMajor.getConfidence() == -1L) && (agentVersion = userAgent.get(this.versionName)) != null) {
            String version = agentVersion.getValue();
            version = version != null ? VersionSplitter.getInstance().getSingleSplit(agentVersion.getValue(), 1) : "??";
            userAgent.setForced(this.majorVersionName, version, agentVersion.getConfidence());
        }
    }

    public String toString() {
        return "Calculate " + this.versionName + " --> " + this.majorVersionName;
    }
}

