/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.debug;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nl.basjes.parse.useragent.AbstractUserAgentAnalyzer;
import nl.basjes.parse.useragent.AbstractUserAgentAnalyzerDirect;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.analyze.Matcher;
import nl.basjes.parse.useragent.analyze.MatchesList;
import nl.basjes.parse.useragent.debug.DebugUserAgent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DefaultSerializer(value=KryoSerializer.class)
public class AbstractUserAgentAnalyzerTester
extends AbstractUserAgentAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractUserAgentAnalyzerTester.class);

    public boolean runTests() {
        return this.runTests(false, true);
    }

    public boolean runTests(boolean showAll, boolean failOnUnexpected) {
        return this.runTests(showAll, failOnUnexpected, null, false, false);
    }

    public boolean runTests(boolean showAll, boolean failOnUnexpected, Collection<String> onlyValidateFieldNames, boolean measureSpeed, boolean showPassedTests) {
        int filenameHeaderLength;
        this.initializeMatchers();
        if (this.getTestCases() == null) {
            return true;
        }
        DebugUserAgent agent = new DebugUserAgent(this.wantedFieldNames);
        ArrayList<TestResult> results = new ArrayList<TestResult>(32);
        String filenameHeader = "Test number and source";
        int maxFilenameLength = filenameHeaderLength = filenameHeader.length();
        for (Map<String, Map<String, String>> test : this.getTestCases()) {
            Map<String, String> metaData = test.get("metaData");
            String filename = metaData.get("filename");
            maxFilenameLength = Math.max(maxFilenameLength, filename.length());
        }
        maxFilenameLength += 11;
        StringBuilder sb = new StringBuilder(1024);
        sb.append("| ").append(filenameHeader);
        for (int i = filenameHeaderLength; i < maxFilenameLength; ++i) {
            sb.append(' ');
        }
        sb.append(" |S|AA|MF|");
        if (measureSpeed) {
            sb.append("  PPS| msPP|");
        }
        sb.append("--> S=Syntax Error, AA=Number of ambiguities during parse, MF=Matches Found");
        if (measureSpeed) {
            sb.append(", PPS=parses/sec, msPP=milliseconds per parse");
        }
        long fullStart = System.nanoTime();
        if (showPassedTests) {
            LOG.info("+===========================================================================================");
            LOG.info(sb.toString());
            LOG.info("+-------------------------------------------------------------------------------------------");
        }
        boolean allPass = true;
        int testcount = 0;
        for (Map<String, Map<String, String>> test : this.getTestCases()) {
            int i;
            int i2;
            ++testcount;
            Map<String, String> input = test.get("input");
            Map<String, String> expected = test.get("expected");
            ArrayList<String> options = null;
            if (test.containsKey("options")) {
                options = new ArrayList<String>(test.get("options").keySet());
            }
            Map<String, String> metaData = test.get("metaData");
            String filename = metaData.get("filename");
            String linenumber = metaData.get("fileline");
            boolean init = false;
            if (options == null) {
                this.setVerbose(false);
                agent.setDebug(false);
            } else {
                boolean newVerbose = options.contains("verbose");
                this.setVerbose(newVerbose);
                agent.setDebug(newVerbose);
                init = options.contains("init");
            }
            if (expected == null || expected.size() == 0) {
                init = true;
            }
            String testName = input.get("name");
            String userAgentString = input.get("user_agent_string");
            if (testName == null) {
                testName = userAgentString.length() > 300 ? userAgentString.substring(0, 290) + " ... ( " + userAgentString.length() + " chars)" : userAgentString;
            }
            sb.setLength(0);
            sb.append("|").append(String.format("%5d", testcount)).append(".(").append(filename).append(':').append(linenumber).append(')');
            for (int i3 = filename.length() + linenumber.length() + 7; i3 < maxFilenameLength; ++i3) {
                sb.append(' ');
            }
            agent.setUserAgentString(userAgentString);
            long measuredSpeed = -1L;
            if (measureSpeed) {
                this.disableCaching();
                for (int i4 = 0; i4 < 100; ++i4) {
                    this.parse(agent);
                }
                long startTime = System.nanoTime();
                for (int i5 = 0; i5 < 1000; ++i5) {
                    this.parse(agent);
                }
                long stopTime = System.nanoTime();
                measuredSpeed = 1000000000000L / (stopTime - startTime);
            } else {
                this.parse(agent);
            }
            sb.append('|');
            if (agent.hasSyntaxError()) {
                sb.append('S');
            } else {
                sb.append(' ');
            }
            if (agent.hasAmbiguity()) {
                sb.append(String.format("|%2d", agent.getAmbiguityCount()));
            } else {
                sb.append("|  ");
            }
            sb.append(String.format("|%2d", agent.getNumberOfAppliedMatches()));
            if (measureSpeed) {
                sb.append('|').append(String.format("%5d", measuredSpeed));
                sb.append('|').append(String.format("%5.2f", 1000.0 / (double)measuredSpeed));
            }
            sb.append("| ").append(testName);
            String testLogLine = sb.toString();
            sb.setLength(0);
            boolean pass = true;
            results.clear();
            if (init) {
                LOG.info(testLogLine);
                sb.append(agent.toYamlTestCase());
                LOG.info(sb.toString());
            } else if (expected == null) {
                LOG.info(testLogLine);
                LOG.warn("| - No expectations ... ");
                continue;
            }
            int maxNameLength = 6;
            int maxActualLength = 7;
            int maxExpectedLength = 9;
            if (expected != null) {
                List<String> fieldNames = agent.getAvailableFieldNamesSorted();
                if (onlyValidateFieldNames != null && onlyValidateFieldNames.isEmpty()) {
                    onlyValidateFieldNames = null;
                } else if (onlyValidateFieldNames != null) {
                    fieldNames.clear();
                    fieldNames.addAll(onlyValidateFieldNames);
                }
                for (String newFieldName : expected.keySet()) {
                    if (fieldNames.contains(newFieldName)) continue;
                    fieldNames.add(newFieldName);
                }
                Iterator<String> iterator = fieldNames.iterator();
                while (iterator.hasNext()) {
                    boolean expectedSomething;
                    String expectedValue;
                    String fieldName = iterator.next();
                    if (onlyValidateFieldNames != null && !onlyValidateFieldNames.contains(fieldName)) continue;
                    TestResult result = new TestResult();
                    result.field = fieldName;
                    result.actual = agent.getValue(result.field);
                    result.confidence = agent.getConfidence(result.field);
                    if (result.actual == null) {
                        result.actual = "<<<null>>>";
                    }
                    if ((expectedValue = expected.get(fieldName)) == null) {
                        expectedSomething = false;
                        if (result.confidence < 0L) continue;
                        result.expected = "<<absent>>";
                    } else {
                        expectedSomething = true;
                        result.expected = expectedValue;
                    }
                    result.pass = result.actual.equals(result.expected);
                    if (!result.pass) {
                        result.warn = true;
                        if (expectedSomething) {
                            result.warn = false;
                            pass = false;
                            allPass = false;
                        } else if (failOnUnexpected && !"__SyntaxError__".equals(result.field)) {
                            result.warn = false;
                            pass = false;
                            allPass = false;
                        }
                    }
                    results.add(result);
                    maxNameLength = Math.max(maxNameLength, result.field.length());
                    maxActualLength = Math.max(maxActualLength, result.actual.length());
                    maxExpectedLength = Math.max(maxExpectedLength, result.expected.length());
                }
                if (!agent.analyzeMatchersResult()) {
                    pass = false;
                    allPass = false;
                }
            }
            if (!init && pass && !showAll) {
                if (!showPassedTests) continue;
                LOG.info(testLogLine);
                continue;
            }
            if (!pass) {
                LOG.info(testLogLine);
                LOG.error("| TEST FAILED !");
            }
            if (agent.hasAmbiguity()) {
                LOG.info("| Parsing problem: Ambiguity {} times. ", (Object)agent.getAmbiguityCount());
            }
            if (agent.hasSyntaxError()) {
                LOG.info("| Parsing problem: Syntax Error");
            }
            if (init || !pass) {
                sb.setLength(0);
                sb.append('\n');
                sb.append('\n');
                sb.append("- matcher:\n");
                sb.append("#    options:\n");
                sb.append("#    - 'verbose'\n");
                sb.append("    require:\n");
                for (String path : AbstractUserAgentAnalyzerTester.getAllPaths(userAgentString)) {
                    if (!path.contains("=\"")) continue;
                    sb.append("#    - '").append(path).append("'\n");
                }
                sb.append("    extract:\n");
                sb.append("#    - 'DeviceClass                         :      1 :' \n");
                sb.append("#    - 'DeviceBrand                         :      1 :' \n");
                sb.append("#    - 'DeviceName                          :      1 :' \n");
                sb.append("#    - 'OperatingSystemClass                :      1 :' \n");
                sb.append("#    - 'OperatingSystemName                 :      1 :' \n");
                sb.append("#    - 'OperatingSystemVersion              :      1 :' \n");
                sb.append("#    - 'LayoutEngineClass                   :      1 :' \n");
                sb.append("#    - 'LayoutEngineName                    :      1 :' \n");
                sb.append("#    - 'LayoutEngineVersion                 :      1 :' \n");
                sb.append("#    - 'AgentClass                          :      1 :' \n");
                sb.append("#    - 'AgentName                           :      1 :' \n");
                sb.append("#    - 'AgentVersion                        :      1 :' \n");
                sb.append('\n');
                sb.append('\n');
                LOG.info(sb.toString());
            }
            sb.setLength(0);
            sb.append("+--------+-");
            for (i2 = 0; i2 < maxNameLength; ++i2) {
                sb.append('-');
            }
            sb.append("-+-");
            for (i2 = 0; i2 < maxActualLength; ++i2) {
                sb.append('-');
            }
            sb.append("-+------------+-");
            for (i2 = 0; i2 < maxExpectedLength; ++i2) {
                sb.append('-');
            }
            sb.append("-+");
            String separator = sb.toString();
            LOG.info(separator);
            sb.setLength(0);
            sb.append("| Result | Field ");
            for (i = 6; i < maxNameLength; ++i) {
                sb.append(' ');
            }
            sb.append(" | Actual ");
            for (i = 7; i < maxActualLength; ++i) {
                sb.append(' ');
            }
            sb.append(" | Confidence | Expected ");
            for (i = 9; i < maxExpectedLength; ++i) {
                sb.append(' ');
            }
            sb.append(" |");
            LOG.info(sb.toString());
            LOG.info(separator);
            HashMap<String, String> failComments = new HashMap<String, String>();
            ArrayList<String> failedFieldNames = new ArrayList<String>();
            for (TestResult result : results) {
                int i6;
                sb.setLength(0);
                if (result.pass) {
                    sb.append("|        | ");
                } else if (result.warn) {
                    sb.append("| ~warn~ | ");
                    failComments.put(result.field, "~~ Unexpected result ~~");
                } else {
                    sb.append("| -FAIL- | ");
                    failComments.put(result.field, "FAILED; Should be '" + result.expected + "'");
                    failedFieldNames.add(result.field);
                }
                sb.append(result.field);
                for (i6 = result.field.length(); i6 < maxNameLength; ++i6) {
                    sb.append(' ');
                }
                sb.append(" | ");
                sb.append(result.actual);
                for (i6 = result.actual.length(); i6 < maxActualLength; ++i6) {
                    sb.append(' ');
                }
                sb.append(" | ");
                sb.append(String.format("%10d", result.confidence));
                sb.append(" | ");
                if (result.pass) {
                    for (i6 = 0; i6 < maxExpectedLength; ++i6) {
                        sb.append(' ');
                    }
                    sb.append(" |");
                    LOG.info(sb.toString());
                    continue;
                }
                sb.append(result.expected);
                for (i6 = result.expected.length(); i6 < maxExpectedLength; ++i6) {
                    sb.append(' ');
                }
                sb.append(" |");
                if (result.warn) {
                    LOG.warn(sb.toString());
                    continue;
                }
                LOG.error(sb.toString());
            }
            LOG.info(separator);
            LOG.info("");
            LOG.info(agent.toMatchTrace(failedFieldNames));
            LOG.info("\n\nconfig:\n{}", (Object)agent.toYamlTestCase(!init, failComments));
            LOG.info("Location of failed test.({}:{})", (Object)filename, (Object)linenumber);
            if (!pass && !showAll) {
                return false;
            }
            if (!init) continue;
            return allPass;
        }
        if (showPassedTests) {
            LOG.info("+===========================================================================================");
        } else {
            LOG.info("All {} tests passed", (Object)testcount);
        }
        long fullStop = System.nanoTime();
        LOG.info("This took {} ms for {} tests : averaging to {} msec/test (This includes test validation and logging!!)", new Object[]{(fullStop - fullStart) / 1000000L, testcount, (double)(fullStop - fullStart) / (double)((long)testcount * 1000000L)});
        if (testcount == 0) {
            LOG.error("NO tests were run at all!!!");
            allPass = false;
        }
        return allPass;
    }

    public List<MatchesList.Match> getMatches() {
        ArrayList<MatchesList.Match> allMatches = new ArrayList<MatchesList.Match>(128);
        for (Matcher matcher : this.getAllMatchers()) {
            allMatches.addAll(matcher.getMatches());
        }
        return allMatches;
    }

    public List<MatchesList.Match> getUsedMatches(UserAgent userAgent) {
        for (Matcher matcher : this.getAllMatchers()) {
            matcher.reset();
            matcher.setVerboseTemporarily(false);
        }
        this.flattener.parse(userAgent);
        ArrayList<MatchesList.Match> allMatches = new ArrayList<MatchesList.Match>(128);
        for (Matcher matcher : this.getAllMatchers()) {
            allMatches.addAll(matcher.getUsedMatches());
        }
        return allMatches;
    }

    @Override
    public String toString() {
        return "UserAgentAnalyzerTester{" + super.toString() + "} ";
    }

    public static abstract class AbstractUserAgentAnalyzerTesterBuilder<UAA extends AbstractUserAgentAnalyzerTester, B extends AbstractUserAgentAnalyzer.AbstractUserAgentAnalyzerBuilder<UAA, B>>
    extends AbstractUserAgentAnalyzer.AbstractUserAgentAnalyzerBuilder<UAA, B> {
        AbstractUserAgentAnalyzerTesterBuilder(UAA newUaa) {
            super(newUaa);
        }

        @Override
        public UAA build() {
            return (UAA)((AbstractUserAgentAnalyzerTester)super.build());
        }
    }

    static class TestResult {
        String field;
        String expected;
        String actual;
        boolean pass;
        boolean warn;
        long confidence;

        TestResult() {
        }
    }

    public static class KryoSerializer
    extends AbstractUserAgentAnalyzerDirect.KryoSerializer {
        public KryoSerializer(Kryo kryo, Class<?> type) {
            super(kryo, type);
        }
    }
}

