/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.calculate;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nl.basjes.parse.useragent.AgentField;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.calculate.FieldCalculator;
import nl.basjes.parse.useragent.utils.HostnameExtracter;
import nl.basjes.parse.useragent.utils.Normalize;
import org.apache.hc.client5.http.psl.DomainType;
import org.apache.hc.client5.http.psl.PublicSuffixMatcherLoader;

public class CalculateDeviceBrand
extends FieldCalculator {
    private final Set<String> unwantedUrlBrands = new HashSet<String>();
    private final Set<String> unwantedEmailBrands;
    private static final List<SitePathExtract> SITE_PATH_EXTRACTS = Arrays.asList(new SitePathExtract("https://github.com/", 0), new SitePathExtract("https://gitlab.com/", 0), new SitePathExtract("https://sourceforge.net/projects/", 0));

    public CalculateDeviceBrand() {
        this.unwantedUrlBrands.add("localhost");
        this.unwantedUrlBrands.add("github.com");
        this.unwantedUrlBrands.add("gitlab.com");
        this.unwantedUrlBrands.add("bit.ly");
        this.unwantedEmailBrands = new HashSet<String>();
        this.unwantedEmailBrands.add("localhost");
        this.unwantedEmailBrands.add("gmail.com");
        this.unwantedEmailBrands.add("outlook.com");
    }

    @Override
    public void calculate(UserAgent.MutableUserAgent userAgent) {
        AgentField deviceBrand = userAgent.get("DeviceBrand");
        if (deviceBrand.isDefaultValue()) {
            String newDeviceBrand = this.determineDeviceBrand(userAgent);
            if (newDeviceBrand != null) {
                userAgent.setForced("DeviceBrand", newDeviceBrand, 0L);
            } else {
                userAgent.setForced("DeviceBrand", "<<<null>>>", 0L);
            }
        } else {
            userAgent.setForced("DeviceBrand", Normalize.brand(deviceBrand.getValue()), deviceBrand.getConfidence());
        }
    }

    private String determineDeviceBrand(UserAgent userAgent) {
        String hostname;
        String deviceBrand = null;
        AgentField informationUrl = userAgent.get("AgentInformationUrl");
        if (!informationUrl.isDefaultValue() && (deviceBrand = this.extractCompanyFromHostName(hostname = HostnameExtracter.extractHostname(informationUrl.getValue()), this.unwantedUrlBrands)) == null) {
            deviceBrand = this.extractCompanyFromSoftwareRepositoryUrl(informationUrl.getValue());
        }
        if (deviceBrand != null) {
            return deviceBrand;
        }
        AgentField informationEmail = userAgent.get("AgentInformationEmail");
        if (!informationEmail.isDefaultValue()) {
            String hostname2 = informationEmail.getValue();
            int atOffset = hostname2.indexOf(64);
            if (atOffset >= 0) {
                hostname2 = hostname2.substring(atOffset + 1);
            }
            deviceBrand = this.extractCompanyFromHostName(hostname2, this.unwantedEmailBrands);
        }
        return deviceBrand;
    }

    private String extractCompanyFromSoftwareRepositoryUrl(String url) {
        for (SitePathExtract sitePathExtract : SITE_PATH_EXTRACTS) {
            if (!url.startsWith(sitePathExtract.prefix)) continue;
            String path = url.substring(sitePathExtract.prefixLength);
            String[] splits = path.split("/");
            if (splits.length == 0 || splits.length < sitePathExtract.brandSegment) {
                return null;
            }
            String brand = splits[sitePathExtract.brandSegment];
            if (brand.isEmpty()) {
                return null;
            }
            return Normalize.brand(brand);
        }
        return null;
    }

    private String extractCompanyFromHostName(String hostname, Set<String> blackList) {
        if (blackList.contains(hostname)) {
            return null;
        }
        String root = PublicSuffixMatcherLoader.getDefault().getDomainRoot(hostname, DomainType.ICANN);
        if (root == null) {
            return null;
        }
        return Normalize.brand(root.split("\\.", 2)[0]);
    }

    @Override
    public String getCalculatedFieldName() {
        return "DeviceBrand";
    }

    @Override
    public Set<String> getDependencies() {
        return new HashSet<String>(Arrays.asList("AgentInformationUrl", "AgentInformationEmail"));
    }

    private static final class SitePathExtract {
        final String prefix;
        final int prefixLength;
        final int brandSegment;

        SitePathExtract(String prefix, int brandSegment) {
            this.prefix = prefix;
            this.prefixLength = prefix.length();
            this.brandSegment = brandSegment;
        }
    }
}

