/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.analyze.Analyzer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestCase
implements Serializable {
    private final String userAgent;
    private final String testName;
    private final List<String> options;
    private final Map<String, String> metadata;
    private final Map<String, String> expected;
    private static final Logger LOG = LogManager.getLogger(TestCase.class);
    private static final String SPACE_FILLER = "                                                                    ";
    private static final String MIN_FILLER = "--------------------------------------------------------------------";

    private TestCase() {
        this.userAgent = "<<Should never appear after deserialization>>";
        this.testName = "<<Should never appear after deserialization>>";
        this.options = Collections.emptyList();
        this.metadata = Collections.emptyMap();
        this.expected = Collections.emptyMap();
    }

    public TestCase(String userAgent, String testName) {
        this.userAgent = userAgent;
        this.testName = testName;
        this.options = new ArrayList<String>();
        this.metadata = new LinkedHashMap<String, String>();
        this.expected = new LinkedHashMap<String, String>();
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getTestName() {
        return this.testName;
    }

    public List<String> getOptions() {
        return this.options;
    }

    public void addOption(String option) {
        this.options.add(option);
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void addMetadata(String key, String value) {
        this.metadata.put(key, value);
    }

    public Map<String, String> getExpected() {
        return this.expected;
    }

    public void expect(String key, String value) {
        this.expected.put(key, value);
    }

    public boolean verify(Analyzer analyzer) {
        return this.verify(analyzer, false);
    }

    private String logLine(String field, int maxFieldLength, String exp, int maxExpectedLength, String actual, int maxActualLength) {
        if (field == null) {
            field = "<<<null>>>";
        }
        if (exp == null) {
            exp = "<<<null>>>";
        }
        if (actual == null) {
            actual = "<<<null>>>";
        }
        return " | " + field + SPACE_FILLER.substring(0, maxFieldLength - field.length()) + " | " + exp + SPACE_FILLER.substring(0, maxExpectedLength - exp.length()) + " | " + actual + SPACE_FILLER.substring(0, maxActualLength - actual.length()) + " |";
    }

    private String logSeparator(int maxFieldLength, int maxExpectedLength, int maxActualLength) {
        return " |-" + MIN_FILLER.substring(0, maxFieldLength) + "-+-" + MIN_FILLER.substring(0, maxExpectedLength) + "-+-" + MIN_FILLER.substring(0, maxActualLength) + "-|";
    }

    public boolean verify(Analyzer analyzer, boolean verbose) {
        UserAgent.ImmutableUserAgent result = analyzer.parse(this.userAgent);
        TreeSet<String> combinedKeys = new TreeSet<String>();
        combinedKeys.addAll(this.expected.keySet());
        combinedKeys.addAll(result.toMap().keySet());
        combinedKeys.remove("Useragent");
        combinedKeys.remove("__SyntaxError__");
        boolean passed = true;
        StringBuilder sb = new StringBuilder();
        int maxFieldLength = 20;
        int maxExpectLength = 20;
        int maxActualLength = 20;
        if (verbose) {
            maxFieldLength = combinedKeys.stream().map(String::length).max(Integer::compareTo).orElse(0);
            maxExpectLength = this.expected.values().stream().map(String::length).max(Integer::compareTo).orElse(0);
            maxActualLength = this.expected.values().stream().map(String::length).max(Integer::compareTo).orElse(0);
            sb.append(this.logSeparator(maxFieldLength, maxExpectLength, maxActualLength)).append('\n');
            sb.append(this.logLine("Field", maxFieldLength, "Expected", maxExpectLength, "Actual", maxActualLength)).append('\n');
            sb.append(this.logSeparator(maxFieldLength, maxExpectLength, maxActualLength)).append('\n');
        }
        for (String key : combinedKeys) {
            String expectedValue = this.expected.get(key);
            String actualValue = result.getValue(key);
            if (verbose) {
                sb.append(this.logLine(key, maxFieldLength, expectedValue, maxExpectLength, actualValue, maxActualLength));
            }
            if (expectedValue == null) {
                if (!result.get(key).isDefaultValue()) {
                    passed = false;
                    sb.append(" --> UNEXPECTED");
                }
            } else if (!expectedValue.equals(actualValue)) {
                passed = false;
                sb.append(" --> !!! FAIL !!!");
            }
            sb.append('\n');
        }
        if (verbose) {
            sb.append(this.logSeparator(maxFieldLength, maxExpectLength, maxActualLength)).append('\n');
            LOG.info("\n{}", (Object)sb);
        }
        return passed;
    }

    public String toString() {
        return "TestCase{userAgent='" + this.userAgent + '\'' + ", testName='" + this.testName + '\'' + ", options=" + this.options + ", metadata=" + this.metadata + ", expected=" + this.expected + '}';
    }
}

