/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.utils;

import java.io.Serializable;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import nl.basjes.parse.useragent.utils.Normalize;
import org.apache.hc.client5.http.psl.DomainType;
import org.apache.hc.client5.http.psl.PublicSuffixMatcherLoader;

public final class HostnameExtracter
implements Serializable {
    private static final Set<String> UNWANTED_URL_BRANDS = new HashSet<String>();
    private static final Set<String> UNWANTED_EMAIL_BRANDS;
    private static final List<SitePathExtract> SITE_PATH_EXTRACTS;

    private HostnameExtracter() {
    }

    public static String extractHostname(String uriString) {
        URI uri;
        block11: {
            if (uriString == null || uriString.isEmpty()) {
                return null;
            }
            int firstQuestionMark = uriString.indexOf(63);
            int firstAmpersand = uriString.indexOf(38);
            int cutIndex = -1;
            if (firstAmpersand != -1) {
                cutIndex = firstQuestionMark != -1 ? firstQuestionMark : firstAmpersand;
            } else if (firstQuestionMark != -1) {
                cutIndex = firstQuestionMark;
            }
            if (cutIndex != -1) {
                uriString = uriString.substring(0, cutIndex);
            }
            try {
                if (uriString.charAt(0) == '/') {
                    if (uriString.charAt(1) == '/') {
                        uri = URI.create(uriString);
                        break block11;
                    }
                    return null;
                }
                if (uriString.contains(":")) {
                    uri = URI.create(uriString);
                    break block11;
                }
                if (uriString.contains("/")) {
                    return uriString.split("/", 2)[0];
                }
                return uriString;
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return uri.getHost();
    }

    public static String extractBrandFromUrl(String url) {
        String hostname = HostnameExtracter.extractHostname(url);
        String brand = HostnameExtracter.extractCompanyFromHostName(hostname, UNWANTED_URL_BRANDS);
        if (brand == null) {
            brand = HostnameExtracter.extractCompanyFromSoftwareRepositoryUrl(url);
        }
        return brand;
    }

    public static String extractBrandFromEmail(String email) {
        String hostname = email;
        int atOffset = hostname.indexOf(64);
        if (atOffset >= 0) {
            hostname = hostname.substring(atOffset + 1);
        }
        return HostnameExtracter.extractCompanyFromHostName(hostname, UNWANTED_EMAIL_BRANDS);
    }

    private static String extractCompanyFromSoftwareRepositoryUrl(String url) {
        for (SitePathExtract sitePathExtract : SITE_PATH_EXTRACTS) {
            if (!url.startsWith(sitePathExtract.prefix)) continue;
            String path = url.substring(sitePathExtract.prefixLength);
            String[] splits = path.split("/");
            if (splits.length == 0 || splits.length < sitePathExtract.brandSegment) {
                return null;
            }
            String brand = splits[sitePathExtract.brandSegment];
            if (brand.isEmpty()) {
                return null;
            }
            return Normalize.brand(brand);
        }
        return null;
    }

    private static String extractCompanyFromHostName(String hostname, Set<String> blackList) {
        if (hostname == null) {
            return null;
        }
        if (blackList.contains(hostname = hostname.toLowerCase(Locale.ROOT))) {
            return null;
        }
        String root = PublicSuffixMatcherLoader.getDefault().getDomainRoot(hostname, DomainType.ICANN);
        if (root == null) {
            return null;
        }
        return Normalize.brand(root.split("\\.", 2)[0]);
    }

    static {
        UNWANTED_URL_BRANDS.add("localhost");
        UNWANTED_URL_BRANDS.add("github.com");
        UNWANTED_URL_BRANDS.add("gitlab.com");
        UNWANTED_URL_BRANDS.add("bit.ly");
        UNWANTED_URL_BRANDS.add("wordpress.com");
        UNWANTED_EMAIL_BRANDS = new HashSet<String>();
        UNWANTED_EMAIL_BRANDS.add("localhost");
        UNWANTED_EMAIL_BRANDS.add("gmail.com");
        UNWANTED_EMAIL_BRANDS.add("outlook.com");
        SITE_PATH_EXTRACTS = Arrays.asList(new SitePathExtract("https://github.com/", 0), new SitePathExtract("https://gitlab.com/", 0), new SitePathExtract("https://sourceforge.net/projects/", 0));
    }

    private static final class SitePathExtract {
        final String prefix;
        final int prefixLength;
        final int brandSegment;

        SitePathExtract(String prefix, int brandSegment) {
            this.prefix = prefix;
            this.prefixLength = prefix.length();
            this.brandSegment = brandSegment;
        }
    }
}

