/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import nl.basjes.parse.useragent.Analyzer;
import nl.basjes.parse.useragent.AnalyzerPreHeater;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.analyze.Matcher;
import nl.basjes.parse.useragent.analyze.MatcherList;
import nl.basjes.parse.useragent.analyze.MatchesList;
import nl.basjes.parse.useragent.analyze.UserAgentStringMatchMaker;
import nl.basjes.parse.useragent.clienthints.ClientHints;
import nl.basjes.parse.useragent.clienthints.ClientHintsAnalyzer;
import nl.basjes.parse.useragent.clienthints.parsers.ParseSecChUa;
import nl.basjes.parse.useragent.clienthints.parsers.ParseSecChUaArch;
import nl.basjes.parse.useragent.clienthints.parsers.ParseSecChUaBitness;
import nl.basjes.parse.useragent.clienthints.parsers.ParseSecChUaFullVersion;
import nl.basjes.parse.useragent.clienthints.parsers.ParseSecChUaFullVersionList;
import nl.basjes.parse.useragent.clienthints.parsers.ParseSecChUaMobile;
import nl.basjes.parse.useragent.clienthints.parsers.ParseSecChUaModel;
import nl.basjes.parse.useragent.clienthints.parsers.ParseSecChUaPlatform;
import nl.basjes.parse.useragent.clienthints.parsers.ParseSecChUaPlatformVersion;
import nl.basjes.parse.useragent.clienthints.parsers.ParseSecChUaWoW64;
import nl.basjes.parse.useragent.config.AnalyzerConfig;
import nl.basjes.parse.useragent.config.AnalyzerConfigHolder;
import nl.basjes.parse.useragent.config.ConfigLoader;
import nl.basjes.parse.useragent.utils.KryoConfig;
import nl.basjes.parse.useragent.utils.YauaaVersion;
import nl.basjes.parse.useragent.utils.springframework.util.LinkedCaseInsensitiveMap;

@DefaultSerializer(value=KryoSerializer.class)
public abstract class AbstractUserAgentAnalyzerDirect
implements Analyzer,
AnalyzerConfigHolder,
AnalyzerPreHeater,
Serializable {
    protected ClientHintsAnalyzer clientHintsAnalyzer = new ClientHintsAnalyzer();
    private UserAgentStringMatchMaker matchMaker;
    private AnalyzerConfig analyzerConfig;
    private static final Map<String, HeaderSpecification> HEADER_SPECIFICATIONS = new LinkedCaseInsensitiveMap<HeaderSpecification>();

    @Override
    @Nonnull
    public AnalyzerConfig getConfig() {
        return this.analyzerConfig;
    }

    protected UserAgentStringMatchMaker getMatchMaker() {
        return this.matchMaker;
    }

    public static void configureKryo(Object kryo) {
        KryoConfig.configureKryo((Kryo)kryo);
    }

    protected AbstractUserAgentAnalyzerDirect() {
    }

    public synchronized void destroy() {
        this.matchMaker.destroy();
    }

    public void loadResources(String resourceString) {
        this.matchMaker.loadResources(resourceString);
    }

    public void loadResources(String resourceString, boolean showLoadMessages, boolean optionalResources) {
        this.matchMaker.loadResources(resourceString, showLoadMessages, optionalResources);
    }

    public void initializeMatchers() {
        this.matchMaker.initializeMatchers();
    }

    public Set<String> getAllPossibleFieldNames() {
        return this.matchMaker.getAllPossibleFieldNames();
    }

    public List<String> getAllPossibleFieldNamesSorted() {
        return this.matchMaker.getAllPossibleFieldNamesSorted();
    }

    public synchronized void setVerbose(boolean newVerbose) {
        this.matchMaker.setVerbose(newVerbose);
    }

    public synchronized void reset() {
        this.matchMaker.reset();
    }

    @Override
    @Nonnull
    public UserAgent.ImmutableUserAgent parse(String userAgentString) {
        return this.parse(Collections.singletonMap("User-Agent", userAgentString));
    }

    @Override
    @Nonnull
    public UserAgent.ImmutableUserAgent parse(Map<String, String> requestHeaders) {
        UserAgent.MutableUserAgent userAgent = new UserAgent.MutableUserAgent(this.getWantedFieldNames());
        userAgent.addHeader(requestHeaders);
        return this.parse(userAgent);
    }

    @Nonnull
    public UserAgent.ImmutableUserAgent parse(UserAgent.MutableUserAgent inputUserAgent) {
        if (inputUserAgent == null) {
            return new UserAgent.ImmutableUserAgent(this.matchMaker.parse(new UserAgent.MutableUserAgent((String)null)));
        }
        UserAgent.MutableUserAgent userAgent = this.matchMaker.parse(inputUserAgent);
        Map<String, String> requestHeaders = inputUserAgent.getHeaders();
        if (requestHeaders.size() > 1) {
            ClientHints clientHints = this.clientHintsAnalyzer.parse(requestHeaders);
            userAgent = this.clientHintsAnalyzer.merge(userAgent, clientHints);
        }
        return new UserAgent.ImmutableUserAgent(userAgent);
    }

    public List<String> supportedClientHintHeaders() {
        return this.clientHintsAnalyzer.supportedClientHintHeaders();
    }

    public boolean isSupportedClientHintHeader(String header) {
        return this.clientHintsAnalyzer.isSupportedClientHintHeader(header);
    }

    private static void addHeaderSpecification(HeaderSpecification headerSpecification) {
        HEADER_SPECIFICATIONS.put(headerSpecification.getHeaderName(), headerSpecification);
    }

    public Map<String, HeaderSpecification> getAllSupportedHeaders() {
        return HEADER_SPECIFICATIONS;
    }

    public boolean isWantedField(String fieldName) {
        return this.matchMaker.isWantedField(fieldName);
    }

    public Set<String> getWantedFieldNames() {
        return this.matchMaker.getWantedFieldNames();
    }

    protected void configure(AnalyzerConfig pAnalyzerConfig, boolean pShowMatcherStats, boolean pDelayInitialization) {
        this.analyzerConfig = pAnalyzerConfig;
        this.matchMaker = new UserAgentStringMatchMaker(pAnalyzerConfig, pShowMatcherStats, pDelayInitialization);
    }

    public List<MatchesList.Match> getMatches() {
        return this.matchMaker.getMatches();
    }

    public synchronized List<MatchesList.Match> getUsedMatches(UserAgent.MutableUserAgent userAgent) {
        return this.matchMaker.getUsedMatches(userAgent);
    }

    public List<Matcher> getAllMatchers() {
        return this.matchMaker.getAllMatchers();
    }

    public MatcherList getTouchedMatchers() {
        return this.matchMaker.getTouchedMatchers();
    }

    public String toString() {
        return "AbstractUserAgentAnalyzerDirect{clientHintsAnalyzer=" + this.clientHintsAnalyzer + ", matchMaker=" + this.matchMaker + ", analyzerConfig=" + this.analyzerConfig + '}';
    }

    static {
        AbstractUserAgentAnalyzerDirect.addHeaderSpecification(new HeaderSpecification("User-Agent", "https://datatracker.ietf.org/doc/html/rfc7231#section-5.5.3", "The \"User-Agent\" header field contains information about the user agent originating the request,", "userAgent"));
        AbstractUserAgentAnalyzerDirect.addHeaderSpecification(ParseSecChUa.getHeaderSpecification());
        AbstractUserAgentAnalyzerDirect.addHeaderSpecification(ParseSecChUaArch.getHeaderSpecification());
        AbstractUserAgentAnalyzerDirect.addHeaderSpecification(ParseSecChUaBitness.getHeaderSpecification());
        AbstractUserAgentAnalyzerDirect.addHeaderSpecification(ParseSecChUaFullVersion.getHeaderSpecification());
        AbstractUserAgentAnalyzerDirect.addHeaderSpecification(ParseSecChUaFullVersionList.getHeaderSpecification());
        AbstractUserAgentAnalyzerDirect.addHeaderSpecification(ParseSecChUaMobile.getHeaderSpecification());
        AbstractUserAgentAnalyzerDirect.addHeaderSpecification(ParseSecChUaModel.getHeaderSpecification());
        AbstractUserAgentAnalyzerDirect.addHeaderSpecification(ParseSecChUaPlatform.getHeaderSpecification());
        AbstractUserAgentAnalyzerDirect.addHeaderSpecification(ParseSecChUaPlatformVersion.getHeaderSpecification());
        AbstractUserAgentAnalyzerDirect.addHeaderSpecification(ParseSecChUaWoW64.getHeaderSpecification());
    }

    public static class HeaderSpecification {
        private final String headerName;
        private final String specificationUrl;
        private final String specificationSummary;
        private final String fieldName;

        public HeaderSpecification(String headerName, String specificationUrl, String specificationSummary, String fieldName) {
            this.headerName = headerName;
            this.specificationUrl = specificationUrl;
            this.specificationSummary = specificationSummary;
            this.fieldName = fieldName;
        }

        public String toString() {
            return "AbstractUserAgentAnalyzerDirect.HeaderSpecification(headerName=" + this.getHeaderName() + ", specificationUrl=" + this.getSpecificationUrl() + ", specificationSummary=" + this.getSpecificationSummary() + ", fieldName=" + this.getFieldName() + ")";
        }

        public String getHeaderName() {
            return this.headerName;
        }

        public String getSpecificationUrl() {
            return this.specificationUrl;
        }

        public String getSpecificationSummary() {
            return this.specificationSummary;
        }

        public String getFieldName() {
            return this.fieldName;
        }
    }

    public static abstract class AbstractUserAgentAnalyzerDirectBuilder<UAA extends AbstractUserAgentAnalyzerDirect, B extends AbstractUserAgentAnalyzerDirectBuilder<UAA, B>> {
        private final UAA uaa;
        private boolean didBuildStep = false;
        private int preheatIterations = 0;
        private final Set<String> wantedFieldNames = new TreeSet<String>();
        private final List<String> resources = new ArrayList<String>();
        private final List<String> optionalResources = new ArrayList<String>();
        private final List<String> yamlRules = new ArrayList<String>();
        private boolean showMatcherStats = false;
        private int userAgentMaxLength = -1;
        private boolean delayInitialization = true;
        private boolean keepTests = true;
        boolean showFullVersion = true;

        protected void failIfAlreadyBuilt() {
            if (this.didBuildStep) {
                throw new IllegalStateException("A builder can provide only a single instance. It is not allowed to set values after doing build()");
            }
        }

        protected AbstractUserAgentAnalyzerDirectBuilder(UAA newUaa) {
            this.uaa = newUaa;
            this.resources.add("classpath*:UserAgents/**/*.yaml");
        }

        public B dropDefaultResources() {
            this.failIfAlreadyBuilt();
            this.resources.remove("classpath*:UserAgents/**/*.yaml");
            return (B)this;
        }

        public B addResources(String resourceString) {
            this.failIfAlreadyBuilt();
            this.resources.add(resourceString);
            return (B)this;
        }

        public B addOptionalResources(String resourceString) {
            this.failIfAlreadyBuilt();
            this.optionalResources.add(resourceString);
            return (B)this;
        }

        public B addYamlRule(String yamlRule) {
            this.failIfAlreadyBuilt();
            this.yamlRules.add(yamlRule);
            return (B)this;
        }

        public B preheat(int iterations) {
            this.failIfAlreadyBuilt();
            this.preheatIterations = iterations;
            return (B)this;
        }

        public B preheat() {
            this.failIfAlreadyBuilt();
            this.preheatIterations = -1;
            return (B)this;
        }

        public B withField(String fieldName) {
            this.failIfAlreadyBuilt();
            this.wantedFieldNames.add(fieldName);
            return (B)this;
        }

        public B withFields(Collection<String> fieldNames) {
            for (String fieldName : fieldNames) {
                this.withField(fieldName);
            }
            return (B)this;
        }

        public B withFields(String ... fieldNames) {
            for (String fieldName : fieldNames) {
                this.withField(fieldName);
            }
            return (B)this;
        }

        public B withAllFields() {
            this.failIfAlreadyBuilt();
            this.wantedFieldNames.clear();
            return (B)this;
        }

        public B showMatcherLoadStats() {
            this.failIfAlreadyBuilt();
            this.showMatcherStats = true;
            return (B)this;
        }

        public B hideMatcherLoadStats() {
            this.failIfAlreadyBuilt();
            this.showMatcherStats = false;
            return (B)this;
        }

        public B withUserAgentMaxLength(int newUserAgentMaxLength) {
            this.failIfAlreadyBuilt();
            this.userAgentMaxLength = newUserAgentMaxLength;
            return (B)this;
        }

        public B keepTests() {
            this.failIfAlreadyBuilt();
            this.keepTests = true;
            return (B)this;
        }

        public B dropTests() {
            this.failIfAlreadyBuilt();
            this.keepTests = false;
            return (B)this;
        }

        public B delayInitialization() {
            this.failIfAlreadyBuilt();
            this.delayInitialization = true;
            return (B)this;
        }

        public B immediateInitialization() {
            this.failIfAlreadyBuilt();
            this.delayInitialization = false;
            return (B)this;
        }

        public B showMinimalVersion() {
            this.showFullVersion = false;
            return (B)this;
        }

        public B showFullVersion() {
            this.showFullVersion = true;
            return (B)this;
        }

        public UAA build() {
            this.failIfAlreadyBuilt();
            YauaaVersion.logVersion(this.showFullVersion);
            if (!this.wantedFieldNames.isEmpty()) {
                this.wantedFieldNames.add("__Set_ALL_Fields__");
                this.wantedFieldNames.add("DeviceClass");
            }
            ConfigLoader configLoader = new ConfigLoader(this.showMatcherStats).keepTests(this.keepTests).addResource(this.resources, false).addResource(this.optionalResources, true);
            int yamlRuleCount = 1;
            for (String yamlRule : this.yamlRules) {
                configLoader.addYaml(yamlRule, "Manually Inserted Rules " + yamlRuleCount++);
            }
            AnalyzerConfig analyzerConfig = configLoader.load().setUserAgentMaxLength(this.userAgentMaxLength).wantedFieldNames(this.wantedFieldNames);
            ((AbstractUserAgentAnalyzerDirect)this.uaa).configure(analyzerConfig, this.showMatcherStats, this.delayInitialization);
            if (this.preheatIterations < 0) {
                this.uaa.preHeat();
            } else if (this.preheatIterations > 0) {
                this.uaa.preHeat(this.preheatIterations);
            }
            this.didBuildStep = true;
            return this.uaa;
        }
    }

    public static class KryoSerializer
    extends FieldSerializer<AbstractUserAgentAnalyzerDirect> {
        public KryoSerializer(Kryo kryo, Class<?> type) {
            super(kryo, type);
        }

        public void write(Kryo kryo, Output output, AbstractUserAgentAnalyzerDirect object) {
            object.reset();
            super.write(kryo, output, (Object)object);
        }

        public AbstractUserAgentAnalyzerDirect read(Kryo kryo, Input input, Class<? extends AbstractUserAgentAnalyzerDirect> type) {
            return (AbstractUserAgentAnalyzerDirect)super.read(kryo, input, type);
        }
    }
}

