/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.utils.springframework.core.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.annotation.Nullable;
import nl.basjes.parse.useragent.utils.springframework.core.io.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractResource
implements Resource {
    @Override
    public URL getURL() throws IOException {
        throw new FileNotFoundException(this.getDescription() + " cannot be resolved to URL");
    }

    @Override
    public File getFile() throws IOException {
        throw new FileNotFoundException(this.getDescription() + " cannot be resolved to absolute file path");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long contentLength() throws IOException {
        InputStream is = this.getInputStream();
        try {
            int read;
            long size = 0L;
            byte[] buf = new byte[256];
            while ((read = is.read(buf)) != -1) {
                size += (long)read;
            }
            long l = size;
            return l;
        }
        finally {
            block8: {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    Logger logger = LogManager.getLogger(this.getClass());
                    if (!logger.isDebugEnabled()) break block8;
                    logger.debug("Could not close content-length InputStream for {}", (Object)this.getDescription(), (Object)ex);
                }
            }
        }
    }

    @Override
    public Resource createRelative(String relativePath) throws IOException {
        throw new FileNotFoundException("Cannot create a relative resource for " + this.getDescription());
    }

    @Override
    @Nullable
    public String getFilename() {
        return null;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof Resource && ((Resource)other).getDescription().equals(this.getDescription());
    }

    public int hashCode() {
        return this.getDescription().hashCode();
    }

    public String toString() {
        return this.getDescription();
    }
}

