/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.utils.springframework.core.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import javax.annotation.Nullable;
import nl.basjes.parse.useragent.utils.springframework.core.io.AbstractFileResolvingResource;
import nl.basjes.parse.useragent.utils.springframework.core.io.Resource;
import nl.basjes.parse.useragent.utils.springframework.util.Assert;
import nl.basjes.parse.useragent.utils.springframework.util.StringUtils;

public class UrlResource
extends AbstractFileResolvingResource {
    @Nullable
    private final URI uri;
    private final URL url;
    @Nullable
    private volatile URL cleanedUrl;

    public UrlResource(URL url) {
        Assert.notNull(url, "URL must not be null");
        this.uri = null;
        this.url = url;
    }

    public UrlResource(String path) throws MalformedURLException {
        Assert.notNull(path, "Path must not be null");
        this.uri = null;
        this.url = new URL(path);
        this.cleanedUrl = UrlResource.getCleanedUrl(this.url, path);
    }

    private static URL getCleanedUrl(URL originalUrl, String originalPath) {
        String cleanedPath = StringUtils.cleanPath(originalPath);
        if (!cleanedPath.equals(originalPath)) {
            try {
                return new URL(cleanedPath);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return originalUrl;
    }

    private URL getCleanedUrl() {
        URL cleanedurl = this.cleanedUrl;
        if (cleanedurl != null) {
            return cleanedurl;
        }
        this.cleanedUrl = cleanedurl = UrlResource.getCleanedUrl(this.url, (this.uri != null ? this.uri : this.url).toString());
        return cleanedurl;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        URLConnection con = this.url.openConnection();
        this.customizeConnection(con);
        try {
            return con.getInputStream();
        }
        catch (IOException ex) {
            if (con instanceof HttpURLConnection) {
                ((HttpURLConnection)con).disconnect();
            }
            throw ex;
        }
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public File getFile() throws IOException {
        if (this.uri != null) {
            return super.getFile(this.uri);
        }
        return super.getFile();
    }

    @Override
    public Resource createRelative(String relativePath) throws MalformedURLException {
        return new UrlResource(this.createRelativeURL(relativePath));
    }

    protected URL createRelativeURL(String relativePath) throws MalformedURLException {
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        relativePath = StringUtils.replace(relativePath, "#", "%23");
        return new URL(this.url, relativePath);
    }

    @Override
    public String getFilename() {
        return StringUtils.getFilename(this.getCleanedUrl().getPath());
    }

    @Override
    public String getDescription() {
        return "URL [" + this.url + "]";
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof UrlResource && this.getCleanedUrl().equals(((UrlResource)other).getCleanedUrl());
    }

    @Override
    public int hashCode() {
        return this.getCleanedUrl().hashCode();
    }
}

