/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.utils.springframework.util;

import java.util.Collection;
import java.util.HashMap;
import javax.annotation.Nullable;

public abstract class CollectionUtils {
    static final float DEFAULT_LOAD_FACTOR = 0.75f;

    public static boolean isEmpty(@Nullable Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static <K, V> HashMap<K, V> newHashMap(int expectedSize) {
        return new HashMap(CollectionUtils.computeMapInitialCapacity(expectedSize), 0.75f);
    }

    private static int computeMapInitialCapacity(int expectedSize) {
        return (int)Math.ceil((double)expectedSize / 0.75);
    }
}

