/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.utils.springframework.core.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import nl.basjes.parse.useragent.utils.springframework.core.io.AbstractResource;
import nl.basjes.parse.useragent.utils.springframework.core.io.Resource;
import nl.basjes.parse.useragent.utils.springframework.core.io.VfsResource;
import nl.basjes.parse.useragent.utils.springframework.core.io.VfsUtils;
import nl.basjes.parse.useragent.utils.springframework.util.ResourceUtils;

public abstract class AbstractFileResolvingResource
extends AbstractResource {
    @Override
    public boolean exists() {
        try {
            HttpURLConnection httpCon;
            URL url = this.getURL();
            if (ResourceUtils.isFileURL(url)) {
                return this.getFile().exists();
            }
            URLConnection con = url.openConnection();
            this.customizeConnection(con);
            HttpURLConnection httpURLConnection = httpCon = con instanceof HttpURLConnection ? (HttpURLConnection)con : null;
            if (httpCon != null) {
                httpCon.setRequestMethod("HEAD");
                int code = httpCon.getResponseCode();
                if (code == 200) {
                    return true;
                }
                if (code == 404) {
                    return false;
                }
            }
            if (con.getContentLengthLong() > 0L) {
                return true;
            }
            if (httpCon != null) {
                httpCon.disconnect();
                return false;
            }
            this.getInputStream().close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Override
    public boolean isFile() {
        try {
            URL url = this.getURL();
            if (url.getProtocol().startsWith("vfs")) {
                return VfsResourceDelegate.getResource(url).isFile();
            }
            return "file".equals(url.getProtocol());
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Override
    public File getFile() throws IOException {
        URL url = this.getURL();
        if (url.getProtocol().startsWith("vfs")) {
            return VfsResourceDelegate.getResource(url).getFile();
        }
        return ResourceUtils.getFile(url, this.getDescription());
    }

    protected boolean isFile(URI uri) {
        try {
            if (uri.getScheme().startsWith("vfs")) {
                return VfsResourceDelegate.getResource(uri).isFile();
            }
            return "file".equals(uri.getScheme());
        }
        catch (IOException ex) {
            return false;
        }
    }

    protected File getFile(URI uri) throws IOException {
        if (uri.getScheme().startsWith("vfs")) {
            return VfsResourceDelegate.getResource(uri).getFile();
        }
        return ResourceUtils.getFile(uri, this.getDescription());
    }

    @Override
    public long contentLength() throws IOException {
        URL url = this.getURL();
        if (ResourceUtils.isFileURL(url)) {
            File file = this.getFile();
            long length = file.length();
            if (length == 0L && !file.exists()) {
                throw new FileNotFoundException(this.getDescription() + " cannot be resolved in the file system for checking its content length");
            }
            return length;
        }
        URLConnection con = url.openConnection();
        this.customizeConnection(con);
        if (con instanceof HttpURLConnection) {
            HttpURLConnection httpCon = (HttpURLConnection)con;
            httpCon.setRequestMethod("HEAD");
        }
        return con.getContentLengthLong();
    }

    protected void customizeConnection(URLConnection con) throws IOException {
        ResourceUtils.useCachesIfNecessary(con);
        if (con instanceof HttpURLConnection) {
            this.customizeConnection((HttpURLConnection)con);
        }
    }

    protected void customizeConnection(HttpURLConnection ignoredCon) throws IOException {
    }

    private static class VfsResourceDelegate {
        private VfsResourceDelegate() {
        }

        public static Resource getResource(URL url) throws IOException {
            return new VfsResource(VfsUtils.getRoot(url));
        }

        public static Resource getResource(URI uri) throws IOException {
            return new VfsResource(VfsUtils.getRoot(uri));
        }
    }
}

