/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.analyze.treewalker.steps.value;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nl.basjes.parse.useragent.analyze.WordRangeVisitor;
import nl.basjes.parse.useragent.analyze.treewalker.steps.Step;
import nl.basjes.parse.useragent.analyze.treewalker.steps.WalkList;
import nl.basjes.parse.useragent.parser.UserAgentParser;
import nl.basjes.parse.useragent.utils.VersionSplitter;
import nl.basjes.parse.useragent.utils.WordSplitter;
import nl.basjes.shaded.org.antlr.v4.runtime.tree.ParseTree;

public class StepWordRange
extends Step {
    private final int firstWord;
    private final int lastWord;

    private StepWordRange() {
        this.firstWord = -1;
        this.lastWord = -1;
    }

    public StepWordRange(WordRangeVisitor.Range range) {
        this.firstWord = range.getFirst();
        this.lastWord = range.getLast();
    }

    @Override
    public WalkList.WalkResult walk(@Nonnull ParseTree tree, @Nullable String value) {
        String actualValue = this.getActualValue(tree, value);
        String filteredValue = tree.getChildCount() == 1 && (tree.getChild(0) instanceof UserAgentParser.SingleVersionContext || tree.getChild(0) instanceof UserAgentParser.SingleVersionWithCommasContext) ? VersionSplitter.getInstance().getSplitRange(actualValue, this.firstWord, this.lastWord) : WordSplitter.getInstance().getSplitRange(actualValue, this.firstWord, this.lastWord);
        if (filteredValue == null) {
            return null;
        }
        return this.walkNextStep(tree, filteredValue);
    }

    @Override
    public boolean canFail() {
        return this.firstWord != 1 || this.lastWord != 1;
    }

    public String toString() {
        return "WordRange([" + this.firstWord + ":" + this.lastWord + "])";
    }
}

