/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.parse;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.regex.Pattern;
import nl.basjes.parse.useragent.utils.Normalize;

public final class EvilManualUseragentStringHacks {
    private static final Pattern MISSING_PRODUCT_AT_START = Pattern.compile("^\\(( |;|null|compatible|windows|android|linux).*", 2);
    private static final Pattern MISSING_SPACE = Pattern.compile("(/[0-9]+\\.[0-9]+)([A-Z][a-z][a-z][a-z]+ )");
    private static final Pattern MULTIPLE_SPACES = Pattern.compile(" {2,}");
    private static final Pattern AVOID_BASE64_MATCH = Pattern.compile("(android/[0-9]+)(/)", 2);
    private static final Pattern ANDROID_DASH_VERSION = Pattern.compile("(android)-([0-9]+)", 2);
    private static final Pattern TENCENT_NETTYPE_FIX = Pattern.compile("(NetType)/([0-9a-z._-]+)", 2);
    private static final Pattern TENCENT_LANGUAGE_FIX = Pattern.compile("(Language)/([a-z_-]+)", 2);
    private static final Pattern GLUED_VERSION_FIX = Pattern.compile("(Java|Wazzup)([0-9])", 2);

    private EvilManualUseragentStringHacks() {
    }

    public static String fixIt(String useragent) {
        if (useragent == null || useragent.isEmpty()) {
            return useragent;
        }
        String result = useragent;
        result = MULTIPLE_SPACES.matcher(result).replaceAll(" ");
        if ((result = Normalize.replaceString(result, "\u2002", " ")).charAt(0) == ' ') {
            result = result.trim();
        }
        result = TENCENT_NETTYPE_FIX.matcher(result).replaceAll("() $1/$2()");
        result = TENCENT_LANGUAGE_FIX.matcher(result).replaceAll("() $1/$2()");
        if ((result = Normalize.replaceString(result, "SSL/TLS", "SSL TLS")).contains("MSIE")) {
            result = Normalize.replaceString(result, "MSIE7", "MSIE 7");
            result = Normalize.replaceString(result, "MSIE8", "MSIE 8");
            result = Normalize.replaceString(result, "MSIE9", "MSIE 9");
        }
        result = Normalize.replaceString(result, "MSOffice", "MS-Office");
        result = Normalize.replaceString(result, "Ant.com Toolbar", "Ant.com_Toolbar");
        result = ANDROID_DASH_VERSION.matcher(result).replaceAll("$1 $2");
        result = MISSING_SPACE.matcher(result).replaceAll("$1 $2");
        result = AVOID_BASE64_MATCH.matcher(result).replaceAll("$1 $2");
        result = GLUED_VERSION_FIX.matcher(result).replaceAll("$1 $2");
        result = Normalize.replaceString(result, " (Macintosh); ", " (Macintosh; ");
        result = Normalize.replaceString(result, "Microsoft Windows NT 6.2.9200.0);", "Microsoft Windows NT 6.2.9200.0;");
        result = Normalize.replaceString(result, "You Build/VM", "You Build/VM)");
        result = Normalize.replaceString(result, "(/", "(Unknown/");
        result = Normalize.replaceString(result, "; /", "; Unknown/");
        if (MISSING_PRODUCT_AT_START.matcher(result = Normalize.replaceString(result, ", _TV_", " _TV_")).matches() || result.charAt(0) == '[') {
            result = "FakeYauaaProduct/3.14 " + result;
        } else if (result.charAt(0) == '/') {
            result = "FakeYauaaProduct" + result;
        }
        result = Normalize.replaceString(result, ",gzip(gfe)", "");
        result = Normalize.replaceString(result, "__", " ");
        if (result.indexOf(37) != -1 && (result.contains("%20") || result.contains("%3B") || result.contains("%25") || result.contains("%2F") || result.contains("%28"))) {
            try {
                result = URLDecoder.decode(result, "UTF-8");
            }
            catch (UnsupportedEncodingException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return result;
    }
}

