/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.clienthints.parsers;

import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nonnull;
import nl.basjes.parse.useragent.AbstractUserAgentAnalyzer;
import nl.basjes.parse.useragent.clienthints.ClientHints;
import nl.basjes.parse.useragent.clienthints.parsers.BrandListParser;
import nl.basjes.parse.useragent.clienthints.parsers.CHParser;

public class ParseSecChUa
implements CHParser {
    public static final String HEADER_FIELD = "Sec-CH-UA";
    public static final String HEADER_SPEC_URL = "https://wicg.github.io/ua-client-hints/#sec-ch-ua";
    public static final String HEADER_SPEC = "The Sec-CH-UA request header field gives a server information about a user agent's branding and version.";
    private transient Map<String, ArrayList<ClientHints.Brand>> cache = null;

    @Override
    public void initializeCache(@Nonnull AbstractUserAgentAnalyzer.ClientHintsCacheInstantiator<?> clientHintsCacheInstantiator, int cacheSize) {
        this.cache = cacheSize <= 0 ? null : clientHintsCacheInstantiator.instantiateCache(cacheSize);
    }

    @Override
    public void clearCache() {
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    @Override
    @Nonnull
    public ClientHints parse(@Nonnull Map<String, String> clientHintsHeaders, @Nonnull ClientHints clientHints, @Nonnull String headerName) {
        String input = clientHintsHeaders.get(headerName);
        if (input == null) {
            return clientHints;
        }
        ArrayList brands = this.cache == null ? BrandListParser.parse(input) : this.cache.computeIfAbsent(input, value -> BrandListParser.parse(input));
        if (!brands.isEmpty()) {
            clientHints.setBrands(brands);
        }
        return clientHints;
    }

    @Override
    @Nonnull
    public String inputField() {
        return HEADER_FIELD;
    }
}

