/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.clienthints.parsers;

import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nonnull;
import nl.basjes.parse.useragent.AbstractUserAgentAnalyzer;
import nl.basjes.parse.useragent.clienthints.ClientHints;
import nl.basjes.parse.useragent.clienthints.parsers.CHParser;

public class ParseSecChUaFullVersion
implements CHParser {
    public static final String HEADER_FIELD = "Sec-CH-UA-Full-Version";
    public static final String HEADER_SPEC_URL = "https://wicg.github.io/ua-client-hints/#sec-ch-ua-full-version";
    public static final String HEADER_SPEC = "The Sec-CH-UA-Full-Version request header field gives a server information about the user agent\u2019s full version. Sec-CH-UA-Full-Version is deprecated and will be removed in the future. Developers should use Sec-CH-UA-Full-Version-List instead.";
    private transient Map<String, ArrayList<ClientHints.Brand>> cache;

    @Override
    public void initializeCache(@Nonnull AbstractUserAgentAnalyzer.ClientHintsCacheInstantiator<?> clientHintsCacheInstantiator, int cacheSize) {
        this.cache = cacheSize <= 0 ? null : clientHintsCacheInstantiator.instantiateCache(cacheSize);
    }

    @Override
    public void clearCache() {
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    @Override
    @Nonnull
    public ClientHints parse(@Nonnull Map<String, String> clientHintsHeaders, @Nonnull ClientHints clientHints, @Nonnull String headerName) {
        String input = clientHintsHeaders.get(headerName);
        String value = this.parseSfString(input);
        if (value != null && !value.isEmpty()) {
            clientHints.setFullVersion(value);
        }
        return clientHints;
    }

    @Override
    @Nonnull
    public String inputField() {
        return HEADER_FIELD;
    }
}

