/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.analyze.treewalker.steps.value;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nl.basjes.parse.useragent.analyze.WordRangeVisitor;
import nl.basjes.parse.useragent.analyze.treewalker.steps.Step;
import nl.basjes.parse.useragent.analyze.treewalker.steps.WalkList;
import nl.basjes.parse.useragent.utils.ListSplitter;
import nl.basjes.shaded.org.antlr.v4.runtime.tree.ParseTree;

public class StepSegmentRange
extends Step {
    private final int firstSegment;
    private final int lastSegment;

    private StepSegmentRange() {
        this.firstSegment = -1;
        this.lastSegment = -1;
    }

    public StepSegmentRange(WordRangeVisitor.Range range) {
        this.firstSegment = range.getFirst();
        this.lastSegment = range.getLast();
    }

    @Override
    public WalkList.WalkResult walk(@Nonnull ParseTree tree, @Nullable String value) {
        String actualValue = this.getActualValue(tree, value);
        String filteredValue = ListSplitter.getInstance().getSplitRange(actualValue, this.firstSegment, this.lastSegment);
        if (filteredValue == null) {
            return null;
        }
        return this.walkNextStep(tree, filteredValue);
    }

    @Override
    public boolean canFail() {
        return this.firstSegment != 1 || this.lastSegment != 1;
    }

    public String toString() {
        return "SegmentRange([" + this.firstSegment + ":" + this.lastSegment + "])";
    }
}

