/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.ingest.yauaa;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.UserAgentAnalyzer;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;

public class YauaaProcessor
extends AbstractProcessor {
    public static final String TYPE = "yauaa";
    private final String field;
    private final String targetField;
    private final UserAgentAnalyzer uaa;

    YauaaProcessor(String tag, String description, String field, String targetField, UserAgentAnalyzer uaa) {
        super(tag, description);
        this.field = field;
        this.targetField = targetField;
        this.uaa = uaa;
    }

    public IngestDocument execute(IngestDocument ingestDocument) {
        String content = (String)ingestDocument.getFieldValue(this.field, String.class);
        UserAgent.ImmutableUserAgent userAgent = this.uaa.parse(content);
        Map resultMap = userAgent.toMap();
        resultMap.remove("Useragent");
        ingestDocument.setFieldValue(this.targetField, (Object)resultMap);
        return ingestDocument;
    }

    public String getType() {
        return TYPE;
    }

    public static final class Factory
    implements Processor.Factory {
        public Processor create(Map<String, Processor.Factory> processorFactories, String tag, String description, Map<String, Object> config) {
            String field = ConfigurationUtils.readStringProperty((String)YauaaProcessor.TYPE, (String)tag, config, (String)"field");
            String targetField = ConfigurationUtils.readStringProperty((String)YauaaProcessor.TYPE, (String)tag, config, (String)"target_field", (String)"user_agent");
            List fieldNames = ConfigurationUtils.readOptionalList((String)YauaaProcessor.TYPE, (String)tag, config, (String)"fieldNames");
            Integer cacheSize = ConfigurationUtils.readIntProperty((String)YauaaProcessor.TYPE, (String)tag, config, (String)"cacheSize", (Integer)-1);
            Integer preheat = ConfigurationUtils.readIntProperty((String)YauaaProcessor.TYPE, (String)tag, config, (String)"preheat", (Integer)-1);
            String extraRules = ConfigurationUtils.readOptionalStringProperty((String)YauaaProcessor.TYPE, (String)tag, config, (String)"extraRules");
            UserAgentAnalyzer.UserAgentAnalyzerBuilder builder = (UserAgentAnalyzer.UserAgentAnalyzerBuilder)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)UserAgentAnalyzer.newBuilder().dropTests()).immediateInitialization();
            if (cacheSize >= 0) {
                builder.withCache(cacheSize.intValue());
            }
            if (preheat >= 0) {
                builder.preheat(preheat.intValue());
            }
            if (extraRules != null) {
                builder.addYamlRule(extraRules);
            }
            if (fieldNames != null && !fieldNames.isEmpty()) {
                builder.withFields((Collection)fieldNames);
            }
            return new YauaaProcessor(tag, description, field, targetField, (UserAgentAnalyzer)builder.build());
        }
    }
}

