/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.ingest.yauaa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.UserAgentAnalyzer;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;

public class YauaaProcessor
extends AbstractProcessor {
    public static final String TYPE = "yauaa";
    private final Map<String, String> fieldToHeaderMapping;
    private final String targetField;
    private final UserAgentAnalyzer uaa;

    YauaaProcessor(String tag, String description, Map<String, String> fieldToHeaderMapping, String targetField, UserAgentAnalyzer uaa) {
        super(tag, description);
        this.fieldToHeaderMapping = fieldToHeaderMapping;
        this.targetField = targetField;
        this.uaa = uaa;
    }

    public IngestDocument execute(IngestDocument ingestDocument) {
        TreeMap<String, String> headers = new TreeMap<String, String>();
        for (Map.Entry<String, String> entry : this.fieldToHeaderMapping.entrySet()) {
            String content = (String)ingestDocument.getFieldValue(entry.getKey(), String.class);
            if (content == null) continue;
            headers.put(entry.getValue(), content);
        }
        UserAgent.ImmutableUserAgent userAgent = this.uaa.parse(headers);
        Map resultMap = userAgent.toMap();
        resultMap.remove("Useragent");
        ingestDocument.setFieldValue(this.targetField, (Object)resultMap);
        return ingestDocument;
    }

    public String getType() {
        return TYPE;
    }

    public static final class Factory
    implements Processor.Factory {
        public Processor create(Map<String, Processor.Factory> processorFactories, String tag, String description, Map<String, Object> config) {
            String field = ConfigurationUtils.readOptionalStringProperty((String)YauaaProcessor.TYPE, (String)tag, config, (String)"field");
            Map fieldToHeaderMappingConfig = ConfigurationUtils.readOptionalMap((String)YauaaProcessor.TYPE, (String)tag, config, (String)"field_to_header_mapping");
            String targetField = ConfigurationUtils.readStringProperty((String)YauaaProcessor.TYPE, (String)tag, config, (String)"target_field", (String)"user_agent");
            List fieldNames = ConfigurationUtils.readOptionalList((String)YauaaProcessor.TYPE, (String)tag, config, (String)"fieldNames");
            Integer cacheSize = ConfigurationUtils.readIntProperty((String)YauaaProcessor.TYPE, (String)tag, config, (String)"cacheSize", (Integer)-1);
            Integer preheat = ConfigurationUtils.readIntProperty((String)YauaaProcessor.TYPE, (String)tag, config, (String)"preheat", (Integer)-1);
            String extraRules = ConfigurationUtils.readOptionalStringProperty((String)YauaaProcessor.TYPE, (String)tag, config, (String)"extraRules");
            UserAgentAnalyzer.UserAgentAnalyzerBuilder builder = (UserAgentAnalyzer.UserAgentAnalyzerBuilder)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)UserAgentAnalyzer.newBuilder().dropTests()).immediateInitialization()).useJava8CompatibleCaching();
            if (cacheSize >= 0) {
                builder.withCache(cacheSize.intValue());
            }
            if (preheat >= 0) {
                builder.preheat(preheat.intValue());
            }
            if (extraRules != null) {
                builder.addYamlRule(extraRules);
            }
            if (fieldNames != null && !fieldNames.isEmpty()) {
                builder.withFields((Collection)fieldNames);
            }
            UserAgentAnalyzer userAgentAnalyzer = (UserAgentAnalyzer)builder.build();
            ArrayList<String> supportedHeaders = new ArrayList<String>(userAgentAnalyzer.supportedClientHintHeaders());
            supportedHeaders.add("User-Agent");
            TreeMap<String, String> fieldToHeaderMapping = new TreeMap<String, String>();
            if (fieldToHeaderMappingConfig != null) {
                for (Map.Entry entry : fieldToHeaderMappingConfig.entrySet()) {
                    boolean supportedHeaderName = false;
                    String wantedHeader = (String)entry.getValue();
                    for (String allowedHeader : supportedHeaders) {
                        if (!allowedHeader.equalsIgnoreCase(wantedHeader)) continue;
                        supportedHeaderName = true;
                        break;
                    }
                    if (!supportedHeaderName) {
                        throw new IllegalArgumentException("The provided header name \"" + wantedHeader + "\"is not allowed.Allowed header names are: " + supportedHeaders);
                    }
                    fieldToHeaderMapping.put((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if (field != null) {
                fieldToHeaderMapping.put(field, "User-Agent");
            }
            return new YauaaProcessor(tag, description, fieldToHeaderMapping, targetField, userAgentAnalyzer);
        }
    }
}

